package com.example.meituandemo;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;

public class MyScrollView extends ScrollView {
	private OnScrollListener onScrollListener;//ͨsetOnScrollListener()Activityеļ뱾ʹ
	/**
	 * Ҫûָ뿪MyScrollViewMyScrollViewڼYľ룬ȻȽ
	 */
	private int lastScrollY;
	
	public MyScrollView(Context context) {
		this(context, null);
	}
	
	public MyScrollView(Context context, AttributeSet attrs) {
		this(context, attrs, 0);
	}

	public MyScrollView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}
	
	/**
	 * ùӿ
	 * @param onScrollListener
	 */
	public void setOnScrollListener(OnScrollListener onScrollListener) {
		this.onScrollListener = onScrollListener;
	}


	/**
	 * ûָ뿪MyScrollViewʱȡMyScrollViewY룬ȻصonScroll
	 */
	private Handler handler = new Handler() {

		public void handleMessage(android.os.Message msg) {
			int scrollY = MyScrollView.this.getScrollY();//õǰyֵ
			
			//ʱľͼ¼µľ벻ȣٸ5handlerϢ
			if(lastScrollY != scrollY){
				lastScrollY = scrollY;//ѵǰyֵlastScrollYԱ´αȽ
				handler.sendMessageDelayed(handler.obtainMessage(), 5);  
			}
			if(onScrollListener != null){
				onScrollListener.onScroll(scrollY);//ѻõĵǰֵ룬ִмеĴ
			}
			
		};

	}; 

	/**
	 * дonTouchEvent
	 * ûMyScrollViewʱֱӽMyScrollViewYصonScrollУ
	 * ûֵ̧ʱMyScrollViewܻڻԵû̧Ǹ5handlerϢ
	 * handlerдMyScrollViewľ
	 */
	@Override
	public boolean onTouchEvent(MotionEvent ev) {
		if(onScrollListener != null){//Ѵд¼ʱѹy¼lastScrollY,
			onScrollListener.onScroll(lastScrollY = this.getScrollY());//һֵ䣬һ¼
		}
		switch(ev.getAction()){
		case MotionEvent.ACTION_UP:
	         handler.sendMessageDelayed(handler.obtainMessage(), 5); // 뿪,ʱ5뷢Ϣhandler
			break;
		}
		return super.onTouchEvent(ev);
	}


	/**
	 * ĻصӿڣڻǰscrollʱѹֵشActivityж봦
	 * @author xiaanming
	 *
	 */
	public interface OnScrollListener{
		/**
		 * ص MyScrollViewY
		 * @param scrollY
		 */
		public void onScroll(int scrollY);
	}
	
	

}
