/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.animation.AnimationUtils;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final int[] AnimatorSet = new int[]{16843490};
    private static final int AnimatorSet_ordering = 0;
    private static final int[] PropertyAnimator = new int[]{16843489};
    private static final int PropertyAnimator_propertyName = 0;
    private static final int[] Animator = new int[]{0x1010141, 16843160, 16843198, 16843199, 0x10101C0, 16843486, 16843487, 16843488};
    private static final int Animator_interpolator = 0;
    private static final int Animator_duration = 1;
    private static final int Animator_startOffset = 2;
    private static final int Animator_repeatCount = 3;
    private static final int Animator_repeatMode = 4;
    private static final int Animator_valueFrom = 5;
    private static final int Animator_valueTo = 6;
    private static final int Animator_valueType = 7;
    private static final int TOGETHER = 0;
    private static final int VALUE_TYPE_FLOAT = 0;

    public static Animator loadAnimator(Context context, int id) throws Resources.NotFoundException {
        XmlResourceParser parser = null;
        try {
            parser = context.getResources().getAnimation(id);
            Animator animator = AnimatorInflater.createAnimatorFromXml(context, (XmlPullParser)parser);
            return animator;
        }
        catch (XmlPullParserException ex) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id));
            rnf.initCause((Throwable)ex);
            throw rnf;
        }
        catch (IOException ex) {
            Resources.NotFoundException rnf = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(id));
            rnf.initCause((Throwable)ex);
            throw rnf;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private static Animator createAnimatorFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(c, parser, Xml.asAttributeSet((XmlPullParser)parser), null, 0);
    }

    private static Animator createAnimatorFromXml(Context c, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering) throws XmlPullParserException, IOException {
        int type;
        Animator anim = null;
        ArrayList<ObjectAnimator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("objectAnimator")) {
                anim = AnimatorInflater.loadObjectAnimator(c, attrs);
            } else if (name.equals("animator")) {
                anim = AnimatorInflater.loadAnimator(c, attrs, null);
            } else if (name.equals("set")) {
                anim = new AnimatorSet();
                TypedArray a = c.obtainStyledAttributes(attrs, AnimatorSet);
                TypedValue orderingValue = new TypedValue();
                a.getValue(0, orderingValue);
                int n = orderingValue.type == 16 ? orderingValue.data : 0;
                AnimatorInflater.createAnimatorFromXml(c, parser, attrs, (AnimatorSet)anim, n);
                a.recycle();
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<ObjectAnimator>();
            }
            childAnims.add((ObjectAnimator)anim);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator animator : childAnims) {
                animsArray[index++] = animator;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim;
    }

    private static ObjectAnimator loadObjectAnimator(Context context, AttributeSet attrs) throws Resources.NotFoundException {
        ObjectAnimator anim = new ObjectAnimator();
        AnimatorInflater.loadAnimator(context, attrs, anim);
        TypedArray a = context.obtainStyledAttributes(attrs, PropertyAnimator);
        String propertyName = a.getString(0);
        anim.setPropertyName(propertyName);
        a.recycle();
        return anim;
    }

    private static ValueAnimator loadAnimator(Context context, AttributeSet attrs, ValueAnimator anim) throws Resources.NotFoundException {
        int resID;
        int toType;
        TypedArray a = context.obtainStyledAttributes(attrs, Animator);
        long duration = a.getInt(1, 0);
        long startDelay = a.getInt(2, 0);
        int valueType = a.getInt(7, 0);
        if (anim == null) {
            anim = new ValueAnimator();
        }
        int valueFromIndex = 5;
        int valueToIndex = 6;
        boolean getFloats = valueType == 0;
        TypedValue tvFrom = a.peekValue(valueFromIndex);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = a.peekValue(valueToIndex);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (hasFrom && fromType >= 28 && fromType <= 31 || hasTo && toType >= 28 && toType <= 31) {
            getFloats = false;
            anim.setEvaluator(new ArgbEvaluator());
        }
        if (getFloats) {
            if (hasFrom) {
                float valueFrom = fromType == 5 ? a.getDimension(valueFromIndex, 0.0f) : a.getFloat(valueFromIndex, 0.0f);
                if (hasTo) {
                    float valueTo = toType == 5 ? a.getDimension(valueToIndex, 0.0f) : a.getFloat(valueToIndex, 0.0f);
                    anim.setFloatValues(valueFrom, valueTo);
                } else {
                    anim.setFloatValues(valueFrom);
                }
            } else {
                float valueTo = toType == 5 ? a.getDimension(valueToIndex, 0.0f) : a.getFloat(valueToIndex, 0.0f);
                anim.setFloatValues(valueTo);
            }
        } else if (hasFrom) {
            int valueFrom = fromType == 5 ? (int)a.getDimension(valueFromIndex, 0.0f) : (fromType >= 28 && fromType <= 31 ? a.getColor(valueFromIndex, 0) : a.getInt(valueFromIndex, 0));
            if (hasTo) {
                int valueTo = toType == 5 ? (int)a.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? a.getColor(valueToIndex, 0) : a.getInt(valueToIndex, 0));
                anim.setIntValues(valueFrom, valueTo);
            } else {
                anim.setIntValues(valueFrom);
            }
        } else if (hasTo) {
            int valueTo = toType == 5 ? (int)a.getDimension(valueToIndex, 0.0f) : (toType >= 28 && toType <= 31 ? a.getColor(valueToIndex, 0) : a.getInt(valueToIndex, 0));
            anim.setIntValues(valueTo);
        }
        anim.setDuration(duration);
        anim.setStartDelay(startDelay);
        if (a.hasValue(3)) {
            anim.setRepeatCount(a.getInt(3, 0));
        }
        if (a.hasValue(4)) {
            anim.setRepeatMode(a.getInt(4, 1));
        }
        if ((resID = a.getResourceId(0, 0)) > 0) {
            anim.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resID));
        }
        a.recycle();
        return anim;
    }
}

