/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.mapcore.util.e;
import com.amap.api.mapcore.util.u;
import com.amap.api.maps.model.CameraPositionCreator;
import com.amap.api.maps.model.LatLng;

public final class CameraPosition
implements Parcelable {
    public static final CameraPositionCreator CREATOR = new CameraPositionCreator();
    public final LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    public CameraPosition(LatLng latLng, float f2, float f3, float f4) {
        e.a(latLng, (Object)"CameraPosition \u4f4d\u7f6e\u4e0d\u80fd\u4e3anull ");
        this.target = latLng;
        this.zoom = u.b(f2);
        this.tilt = u.a(f3);
        this.bearing = ((double)f4 <= 0.0 ? f4 % 360.0f + 360.0f : f4) % 360.0f;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeFloat(this.bearing);
        parcel.writeFloat((float)this.target.latitude);
        parcel.writeFloat((float)this.target.longitude);
        parcel.writeFloat(this.tilt);
        parcel.writeFloat(this.zoom);
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static final CameraPosition fromLatLngZoom(LatLng latLng, float f2) {
        return new CameraPosition(latLng, f2, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraPosition) {
        return new Builder(cameraPosition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)object;
        return this.target.equals(cameraPosition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraPosition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraPosition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraPosition.bearing);
    }

    public String toString() {
        return u.a(u.a("target", this.target), u.a("zoom", Float.valueOf(this.zoom)), u.a("tilt", Float.valueOf(this.tilt)), u.a("bearing", Float.valueOf(this.bearing)));
    }

    public static final class Builder {
        private LatLng a;
        private float b;
        private float c;
        private float d;

        public Builder() {
        }

        public Builder(CameraPosition cameraPosition) {
            CameraPosition cameraPosition2 = cameraPosition;
            this.target(cameraPosition2.target).bearing(cameraPosition2.bearing).tilt(cameraPosition2.tilt).zoom(cameraPosition2.zoom);
        }

        public Builder target(LatLng latLng) {
            this.a = latLng;
            return this;
        }

        public Builder zoom(float f2) {
            this.b = f2;
            return this;
        }

        public Builder tilt(float f2) {
            this.c = f2;
            return this;
        }

        public Builder bearing(float f2) {
            this.d = f2;
            return this;
        }

        public CameraPosition build() {
            e.a(this.a);
            return new CameraPosition(this.a, this.b, this.c, this.d);
        }
    }
}

