/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.amap.api.mapcore.util.e;
import com.amap.api.mapcore.util.u;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBoundsCreator;

public final class LatLngBounds
implements Parcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int a;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n2, LatLng latLng, LatLng latLng2) {
        e.a(latLng, (Object)"null southwest");
        e.a(latLng2, (Object)"null northeast");
        e.a(latLng2.latitude >= latLng.latitude, "southern latitude exceeds northern latitude (%s > %s)", new Object[]{latLng.latitude, latLng2.latitude});
        this.a = n2;
        this.southwest = latLng;
        this.northeast = latLng2;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    int a() {
        return this.a;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        LatLng latLng2 = latLng;
        return this.a(latLng2.latitude) && this.b(latLng2.longitude);
    }

    public boolean contains(LatLngBounds latLngBounds) {
        boolean bl2 = false;
        if (latLngBounds == null) {
            return bl2;
        }
        if (this.contains(latLngBounds.southwest) && this.contains(latLngBounds.northeast)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean intersects(LatLngBounds latLngBounds) {
        if (latLngBounds == null) {
            return false;
        }
        return this.a(latLngBounds) || latLngBounds.a(this);
    }

    private boolean a(LatLngBounds latLngBounds) {
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null || this.northeast == null || this.southwest == null) {
            return false;
        }
        double d2 = latLngBounds.northeast.longitude + latLngBounds.southwest.longitude - this.northeast.longitude - this.southwest.longitude;
        double d3 = this.northeast.longitude - this.southwest.longitude + latLngBounds.northeast.longitude - this.southwest.longitude;
        double d4 = latLngBounds.northeast.latitude + latLngBounds.southwest.latitude - this.northeast.latitude - this.southwest.latitude;
        double d5 = this.northeast.latitude - this.southwest.latitude + latLngBounds.northeast.latitude - latLngBounds.southwest.latitude;
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    public LatLngBounds including(LatLng latLng) {
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.c(d5, d6) < LatLngBounds.d(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5, false), new LatLng(d3, d4, false));
    }

    private static double c(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double d(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return u.a(new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)object;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return u.a(u.a("southwest", this.southwest), u.a("northeast", this.northeast));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        LatLngBoundsCreator.a(this, parcel, n2);
    }

    public static final class Builder {
        private double a = Double.POSITIVE_INFINITY;
        private double b = Double.NEGATIVE_INFINITY;
        private double c = Double.NaN;
        private double d = Double.NaN;

        public Builder include(LatLng latLng) {
            this.a = Math.min(this.a, latLng.latitude);
            this.b = Math.max(this.b, latLng.latitude);
            double d2 = latLng.longitude;
            if (Double.isNaN(this.c)) {
                this.c = d2;
                this.d = d2;
            } else if (!this.a(d2)) {
                if (LatLngBounds.c(this.c, d2) < LatLngBounds.d(this.d, d2)) {
                    this.c = d2;
                } else {
                    this.d = d2;
                }
            }
            return this;
        }

        private boolean a(double d2) {
            if (this.c <= this.d) {
                return this.c <= d2 && d2 <= this.d;
            }
            return this.c <= d2 || d2 <= this.d;
        }

        public LatLngBounds build() {
            e.a(!Double.isNaN(this.c), (Object)"no included points");
            return new LatLngBounds(new LatLng(this.a, this.c, false), new LatLng(this.b, this.d, false));
        }
    }
}

