/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.amap.api.mapcore.n;
import com.amap.api.mapcore.util.s;
import com.amap.api.mapcore.util.u;
import com.amap.api.maps.AMap;
import com.amap.api.maps.CameraUpdateFactory;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.BitmapDescriptorFactory;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.Polyline;
import com.amap.api.maps.model.PolylineOptions;
import com.amap.api.maps.overlay.a;
import com.amap.api.services.busline.BusLineItem;
import com.amap.api.services.busline.BusStationItem;
import com.amap.api.services.core.LatLonPoint;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class BusLineOverlay {
    private BusLineItem a;
    private AMap b;
    private ArrayList<Marker> c = new ArrayList();
    private Polyline d;
    private List<BusStationItem> e;
    private BitmapDescriptor f;
    private BitmapDescriptor g;
    private BitmapDescriptor h;
    private Context i;

    public BusLineOverlay(Context context, AMap aMap, BusLineItem busLineItem) {
        this.i = context;
        this.a = busLineItem;
        this.b = aMap;
        this.e = this.a.getBusStations();
    }

    public void addToMap() {
        try {
            Marker marker;
            List list = this.a.getDirectionsCoordinates();
            ArrayList<LatLng> arrayList = com.amap.api.maps.overlay.a.a(list);
            this.d = this.b.addPolyline(new PolylineOptions().addAll(arrayList).color(this.getBusColor()).width(this.getBuslineWidth()));
            if (this.e.size() < 1) {
                return;
            }
            for (int i2 = 1; i2 < this.e.size() - 1; ++i2) {
                marker = this.b.addMarker(this.a(i2));
                this.c.add(marker);
            }
            Marker marker2 = this.b.addMarker(this.a(0));
            this.c.add(marker2);
            marker = this.b.addMarker(this.a(this.e.size() - 1));
            this.c.add(marker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void removeFromMap() {
        if (this.d != null) {
            this.d.remove();
        }
        try {
            for (Marker marker : this.c) {
                marker.remove();
            }
            this.a();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void a() {
        if (this.f != null) {
            this.f.recycle();
            this.f = null;
        }
        if (this.g != null) {
            this.g.recycle();
            this.g = null;
        }
        if (this.h != null) {
            this.h.recycle();
            this.h = null;
        }
    }

    public void zoomToSpan() {
        if (this.b == null) {
            return;
        }
        try {
            List list = this.a.getDirectionsCoordinates();
            if (list != null && list.size() > 0) {
                LatLngBounds latLngBounds = this.a(list);
                this.b.moveCamera(CameraUpdateFactory.newLatLngBounds(latLngBounds, 5));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private LatLngBounds a(List<LatLonPoint> list) {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            builder.include(new LatLng(list.get(i2).getLatitude(), list.get(i2).getLongitude()));
        }
        return builder.build();
    }

    private MarkerOptions a(int n2) {
        MarkerOptions markerOptions = new MarkerOptions().position(new LatLng(this.e.get(n2).getLatLonPoint().getLatitude(), this.e.get(n2).getLatLonPoint().getLongitude())).title(this.getTitle(n2)).snippet(this.getSnippet(n2));
        if (n2 == 0) {
            markerOptions.icon(this.getStartBitmapDescriptor());
        } else if (n2 == this.e.size() - 1) {
            markerOptions.icon(this.getEndBitmapDescriptor());
        } else {
            markerOptions.anchor(0.5f, 0.5f);
            markerOptions.icon(this.getBusBitmapDescriptor());
        }
        return markerOptions;
    }

    protected BitmapDescriptor getStartBitmapDescriptor() {
        this.f = this.a("amap_start.png");
        return this.f;
    }

    protected BitmapDescriptor getEndBitmapDescriptor() {
        this.g = this.a("amap_end.png");
        return this.g;
    }

    protected BitmapDescriptor getBusBitmapDescriptor() {
        this.h = this.a("amap_bus.png");
        return this.h;
    }

    protected String getTitle(int n2) {
        return this.e.get(n2).getBusStationName();
    }

    protected String getSnippet(int n2) {
        return "";
    }

    public int getBusStationIndex(Marker marker) {
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            if (!this.c.get(i2).equals(marker)) continue;
            return i2;
        }
        return -1;
    }

    public BusStationItem getBusStationItem(int n2) {
        if (n2 < 0 || n2 >= this.e.size()) {
            return null;
        }
        return this.e.get(n2);
    }

    protected int getBusColor() {
        return Color.parseColor((String)"#537edc");
    }

    protected float getBuslineWidth() {
        return 18.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapDescriptor a(String string) {
        InputStream inputStream = null;
        Bitmap bitmap = null;
        try {
            inputStream = s.a(this.i).open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            bitmap = u.a(bitmap, n.a);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return BitmapDescriptorFactory.fromBitmap(bitmap);
    }
}

