/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import com.amap.api.mapcore.util.az;
import com.autonavi.amap.mapcore.ConnectionManager;
import com.autonavi.amap.mapcore.IBaseMapCallback;
import com.autonavi.amap.mapcore.IMapCallback;
import com.autonavi.amap.mapcore.MapCore;
import com.autonavi.amap.mapcore.MapLoader;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.TextTextureGenerator;
import com.autonavi.amap.mapcore.d;
import com.autonavi.amap.mapcore.e;
import java.util.ArrayList;

public abstract class BaseMapCallImplement
implements IBaseMapCallback,
IMapCallback {
    private ArrayList<MapSourceGridData> baseMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> bldMapGrids = new ArrayList();
    private ArrayList<MapSourceGridData> bmpbmMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> vectmcMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> stiMapGirds = new ArrayList();
    private ArrayList<MapSourceGridData> mapModels = new ArrayList();
    private ArrayList<MapSourceGridData> screenGirds = new ArrayList();
    private ConnectionManager connectionManager = null;
    e tileProcessCtrl = null;
    d connectionPool;

    private void destory() {
        this.baseMapGrids.clear();
        this.bldMapGrids.clear();
        this.bmpbmMapGirds.clear();
        this.vectmcMapGirds.clear();
        this.stiMapGirds.clear();
        this.mapModels.clear();
        this.screenGirds.clear();
    }

    @Override
    public void OnMapDataRequired(MapCore mapCore, int n2, String[] stringArray) {
        ArrayList<MapSourceGridData> arrayList = null;
        switch (n2) {
            case 0: {
                arrayList = this.baseMapGrids;
                break;
            }
            case 1: {
                arrayList = this.bldMapGrids;
                break;
            }
            case 2: {
                arrayList = this.bmpbmMapGirds;
                break;
            }
            case 4: {
                arrayList = this.vectmcMapGirds;
                break;
            }
            case 5: {
                arrayList = this.screenGirds;
                break;
            }
            case 3: {
                arrayList = this.stiMapGirds;
                break;
            }
            case 6: {
                arrayList = this.mapModels;
                break;
            }
        }
        if (arrayList != null) {
            arrayList.clear();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(new MapSourceGridData(stringArray[i2], n2));
            }
            if (5 != n2) {
                try {
                    this.proccessRequiredData(mapCore, arrayList, n2);
                }
                catch (Throwable throwable) {
                    az.a(throwable, "BaseMapCallImplement", "OnMapDataRequired");
                }
            }
        }
    }

    public ArrayList<MapSourceGridData> getScreenGridList(int n2) {
        ArrayList<MapSourceGridData> arrayList = null;
        switch (n2) {
            case 0: {
                arrayList = this.baseMapGrids;
                break;
            }
            case 1: {
                arrayList = this.bldMapGrids;
                break;
            }
            case 2: {
                arrayList = this.bmpbmMapGirds;
                break;
            }
            case 4: {
                arrayList = this.vectmcMapGirds;
                break;
            }
            case 5: {
                arrayList = this.screenGirds;
                break;
            }
            case 3: {
                arrayList = this.stiMapGirds;
                break;
            }
            case 6: {
                arrayList = this.mapModels;
                break;
            }
        }
        return arrayList;
    }

    public boolean isGridsInScreen(ArrayList<MapSourceGridData> arrayList, int n2) {
        try {
            if (arrayList.size() == 0) {
                return false;
            }
            if (!this.isMapEngineValid()) {
                return false;
            }
            ArrayList<MapSourceGridData> arrayList2 = this.getScreenGridList(n2);
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (!this.isGridInList(arrayList.get(i2), arrayList2)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            az.a(throwable, "BaseMapCallImplement", "isGridsInScreen");
            return true;
        }
    }

    public boolean isGridInList(MapSourceGridData mapSourceGridData, ArrayList<MapSourceGridData> arrayList) {
        if (mapSourceGridData == null || arrayList == null) {
            return false;
        }
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            if (!arrayList.get(i2).getGridName().equals(mapSourceGridData.getGridName())) continue;
            return true;
        }
        return false;
    }

    private void proccessRequiredData(MapCore mapCore, ArrayList<MapSourceGridData> arrayList, int n2) {
        ArrayList<MapSourceGridData> arrayList2 = new ArrayList<MapSourceGridData>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            MapSourceGridData mapSourceGridData = arrayList.get(i2);
            if (this.tileProcessCtrl == null || mapSourceGridData == null) {
                return;
            }
            if (this.tileProcessCtrl.b(mapSourceGridData.getKeyGridName())) continue;
            arrayList2.add(mapSourceGridData);
        }
        if (arrayList2.size() > 0) {
            this.sendMapDataRequest(mapCore, arrayList2, n2);
        }
    }

    private synchronized void sendMapDataRequest(MapCore mapCore, ArrayList<MapSourceGridData> arrayList, int n2) {
        if (arrayList.size() == 0) {
            return;
        }
        MapLoader mapLoader = new MapLoader(this, mapCore, n2);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            MapSourceGridData mapSourceGridData = arrayList.get(i2);
            if (this.tileProcessCtrl == null) {
                return;
            }
            if (this.tileProcessCtrl.b(mapSourceGridData.getKeyGridName())) continue;
            this.tileProcessCtrl.c(mapSourceGridData.getKeyGridName());
            mapLoader.addReuqestTiles(mapSourceGridData);
        }
        if (this.connectionManager != null) {
            this.connectionManager.insertConntionTask(mapLoader);
        }
    }

    public void OnMapSurfaceCreate(MapCore mapCore) {
        this.onResume();
    }

    public synchronized void onPause() {
        block5: {
            try {
                if (this.connectionManager == null) break block5;
                this.connectionManager.threadFlag = false;
                try {
                    this.connectionPool = (d)this.connectionManager.connectionPool.clone();
                    this.connectionManager.connectionPool.clear();
                    if (this.connectionManager.isAlive()) {
                        this.connectionManager.interrupt();
                        this.connectionManager = null;
                    }
                }
                catch (Throwable throwable) {
                    az.a(throwable, "BaseMapCallImplement", "onPause");
                    throwable.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public synchronized void onResume() {
        try {
            if (this.tileProcessCtrl == null) {
                this.tileProcessCtrl = new e();
            }
            if (this.connectionManager == null) {
                this.connectionManager = new ConnectionManager();
                if (this.connectionPool != null) {
                    this.connectionManager.connectionPool = this.connectionPool;
                }
                this.connectionManager.start();
            }
        }
        catch (Throwable throwable) {
            az.a(throwable, "BaseMapCallImplement", "onResume");
            throwable.printStackTrace();
        }
    }

    public void OnMapDestory(MapCore mapCore) {
        try {
            this.destory();
            this.onPause();
        }
        catch (Throwable throwable) {
            az.a(throwable, "BaseMapCallImplement", "OnMapDestory");
            throwable.printStackTrace();
        }
    }

    @Override
    public byte[] OnMapCharsWidthsRequired(MapCore mapCore, int[] nArray, int n2, int n3) {
        return TextTextureGenerator.getCharsWidths(nArray);
    }

    @Override
    public void OnMapLabelsRequired(MapCore mapCore, int[] nArray, int n2) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                TextTextureGenerator textTextureGenerator = new TextTextureGenerator();
                byte[] byArray = textTextureGenerator.getTextPixelBuffer(n3);
                mapCore.putCharbitmap(n3, byArray);
            }
        }
        catch (Throwable throwable) {
            az.a(throwable, "BaseMapCallImplement", "OnMapLabelsRequired");
            throwable.printStackTrace();
        }
    }
}

