/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.amap.api.mapcore.util.az;
import com.amap.api.mapcore.util.u;
import com.autonavi.amap.mapcore.IMapCallback;
import com.autonavi.amap.mapcore.MapProjection;
import javax.microedition.khronos.opengles.GL10;

public class MapCore {
    public static final int TEXTURE_ICON = 0;
    public static final int TEXTURE_BACKGROUND = 1;
    public static final int TEXTURE_ROADARROW = 2;
    public static final int TEXTURE_ROADROUND = 3;
    public static final int TEXTURE_TMC_RED = 4;
    public static final int TEXTURE_TMC_YELLOW = 5;
    public static final int TEXTURE_TMC_GREEN = 6;
    public static final int TEXTURE_TMC_BLACK = 7;
    public static final int TEXTURE_RAILWAY = 8;
    public static final int AM_DATA_BASEMAP = 0;
    public static final int AM_DATA_GEO_BUILDING = 1;
    public static final int AM_DATA_BMP_BASEMAP = 2;
    public static final int AM_DATA_SATELLITE = 3;
    public static final int AM_DATA_VEC_TMC = 4;
    public static final int AM_DATA_SCREEN = 5;
    public static final int AM_DATA_MODEL = 6;
    public static final int MAPRENDER_ENTER = 0;
    public static final int MAPRENDER_BASEMAPBEGIN = 1;
    public static final int MAPRENDER_BUILDINGBEGIN = 2;
    public static final int MAPRENDER_LABELSBEGIN = 3;
    public static final int MAPRENDER_RENDEROVER = 4;
    public static final int MAPRENDER_NOMORENEEDRENDER = 5;
    private Object mut_lock = new Object();
    public View view;
    private IMapCallback mMapcallback = null;
    long native_instance = 0L;
    GL10 mGL = null;

    public MapCore(Context context) {
        String string = u.a(context);
        this.native_instance = MapCore.nativeNewInstance(string);
    }

    public void setGL(GL10 gL10) {
        this.mGL = gL10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMapEngineValid() {
        Object object = this.mut_lock;
        synchronized (object) {
            return this.native_instance != 0L;
        }
    }

    public void setMapCallback(IMapCallback iMapCallback) {
        this.mMapcallback = iMapCallback;
    }

    public void surfaceCreate(GL10 gL10) {
        MapCore.nativeSurfaceCreate(this.native_instance, this);
    }

    private byte[] OnMapCharsWidthsRequired(int[] nArray, int n2, int n3) {
        if (this.mMapcallback != null) {
            return this.mMapcallback.OnMapCharsWidthsRequired(this, nArray, n2, n3);
        }
        return new byte[0];
    }

    public void surfaceChange(GL10 gL10, int n2, int n3) {
        MapCore.nativeSurfaceChange(this.native_instance, this, n2, n3);
    }

    public void drawFrame(GL10 gL10) {
        MapCore.nativeSurfaceRenderMap(this.native_instance, this);
    }

    public void setStyleData(byte[] byArray, int n2) {
        MapCore.nativeSetStyleData(this.native_instance, byArray, n2);
    }

    public void setInternaltexture(byte[] byArray, int n2) {
        MapCore.nativeSetInternaltexture(this.native_instance, byArray, n2);
    }

    public long getInstanceHandle() {
        return this.native_instance;
    }

    public MapProjection getMapstate() {
        long l2 = MapCore.nativeGetMapstate(this.native_instance);
        return new MapProjection(l2);
    }

    public void setMapstate(MapProjection mapProjection) {
        mapProjection.recalculate();
        MapCore.nativeSetMapstate(this.native_instance, mapProjection.getInstanceHandle());
    }

    public void setParameter(int n2, int n3, int n4, int n5, int n6) {
        MapCore.nativeSetparameter(this.native_instance, n2, n3, n4, n5, n6);
        if (this.mMapcallback != null) {
            this.mMapcallback.onSetParameter(this);
        }
    }

    public void putMapData(byte[] byArray, int n2, int n3, int n4) {
        if (byArray.length == n3 && n2 == 0) {
            MapCore.nativePutMapdata(this.native_instance, n4, byArray);
        } else {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            MapCore.nativePutMapdata(this.native_instance, n4, byArray2);
        }
        if (this.mMapcallback != null) {
            this.mMapcallback.onSetParameter(this);
        }
    }

    public void putCharbitmap(int n2, byte[] byArray) {
        MapCore.nativePutCharbitmap(this.native_instance, n2, byArray);
        if (this.mMapcallback != null) {
            this.mMapcallback.onSetParameter(this);
        }
    }

    public int getLabelBuffer(int n2, int n3, int n4, byte[] byArray) {
        return MapCore.nativeGetSelectedMapPois(this.native_instance, n2, n3, n4, byArray);
    }

    private void OnMapSurfaceCreate() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSurfaceCreate(this.mGL, this);
        }
    }

    private void OnMapSurfaceRenderer(int n2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSurfaceRenderer(this.mGL, this, n2);
        }
    }

    private void OnMapSufaceChanged(int n2, int n3) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapSufaceChanged(this.mGL, this, n2, n3);
        }
    }

    private void OnMapProcessEvent() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapProcessEvent(this);
        }
    }

    private void OnMapDestory() {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapDestory(this.mGL, this);
        }
    }

    private void OnMapDataRequired(int n2, String[] stringArray) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapDataRequired(this, n2, stringArray);
        }
    }

    private void OnMapLabelsRequired(int[] nArray, int n2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapLabelsRequired(this, nArray, n2);
        }
    }

    private void OnMapReferencechanged(String string, String string2) {
        if (this.mMapcallback != null) {
            this.mMapcallback.OnMapReferencechanged(this, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            Object object = this.mut_lock;
            synchronized (object) {
                if (this.native_instance != 0L) {
                    MapCore.nativeDestroy(this.native_instance, this);
                    this.native_instance = 0L;
                }
            }
        }
        catch (Throwable throwable) {
            az.a(throwable, "MapCore", "destroy");
            Log.d((String)"minimap", (String)("finalize erro:" + throwable.getMessage()));
        }
    }

    private static native long nativeNewInstance(String var0);

    private static native void nativeDestroy(long var0, MapCore var2);

    private static native void nativeSetStyleData(long var0, byte[] var2, int var3);

    private static native void nativeSetInternaltexture(long var0, byte[] var2, int var3);

    private static native void nativeSurfaceCreate(long var0, MapCore var2);

    private static native void nativeSurfaceChange(long var0, MapCore var2, int var3, int var4);

    private static native void nativeSurfaceRenderMap(long var0, MapCore var2);

    private static native void nativeSetMapstate(long var0, long var2);

    private static native long nativeGetMapstate(long var0);

    private static native void nativeSetparameter(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native void nativePutMapdata(long var0, int var2, byte[] var3);

    private static native void nativePutCharbitmap(long var0, int var2, byte[] var3);

    private static native int nativeGetSelectedMapPois(long var0, int var2, int var3, int var4, byte[] var5);

    static {
        try {
            System.loadLibrary("amapv304");
            System.loadLibrary("amapv304ex");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }
}

