/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amap.api.mapcore.n;
import com.amap.api.mapcore.util.az;
import com.amap.api.mapcore.util.o;
import com.amap.api.maps.MapsInitializer;
import com.autonavi.amap.mapcore.BaseMapCallImplement;
import com.autonavi.amap.mapcore.Convert;
import com.autonavi.amap.mapcore.MapCore;
import com.autonavi.amap.mapcore.MapSourceGridData;
import com.autonavi.amap.mapcore.VTMCDataCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class MapLoader {
    BaseMapCallImplement mMapCallback;
    MapCore mMapCore;
    public ArrayList<MapSourceGridData> mapTiles = new ArrayList();
    boolean mCanceled = false;
    long createtime;
    byte[] recievedDataBuffer;
    int recievedDataSize = 0;
    int nextImgDataLength = 0;
    boolean recievedHeader = false;
    int datasource = 0;

    public void destory() {
        this.mapTiles.clear();
        this.mapTiles = null;
        this.recievedDataBuffer = null;
        VTMCDataCache.vtmcHs.clear();
        VTMCDataCache.vtmcList.clear();
    }

    public String getGridParma() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.mapTiles.size(); ++i2) {
            String string = this.mapTiles.get(i2).getGridName();
            stringBuffer.append(string + ";");
        }
        if (stringBuffer.length() <= 0) {
            return null;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (this.datasource == 0) {
            return "t=VMMV3&cp=1&mesh=" + stringBuffer.toString();
        }
        if (this.datasource == 1) {
            return "t=VMMBLDV3&cp=1&mesh=" + stringBuffer.toString();
        }
        if (this.datasource == 2) {
            return "t=BMPBM&mesh=" + stringBuffer.toString();
        }
        if (this.datasource == 3) {
            return "t=BMTI&mesh=" + stringBuffer.toString();
        }
        if (this.datasource == 4) {
            return "t=TMCV&v=6.0.1&mesh=" + stringBuffer.toString();
        }
        if (this.datasource == 6) {
            return "t=VMMV3&type=mod&cp=0&mid=" + stringBuffer.toString();
        }
        return null;
    }

    public MapLoader(BaseMapCallImplement baseMapCallImplement, MapCore mapCore, int n2) {
        this.mMapCallback = baseMapCallImplement;
        this.datasource = n2;
        this.mMapCore = mapCore;
        this.createtime = System.currentTimeMillis();
    }

    public void OnException(int n2) {
        if (this.datasource != 4 && this.datasource != 1) {
            this.mMapCallback.OnMapLoaderError(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequest() {
        block22: {
            if (!MapsInitializer.getNetWorkEnable()) {
                return;
            }
            if (!this.isRequestValid()) {
                this.onConnectionOver(this);
                return;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mMapCallback.getContext().getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            String string = null;
            int n2 = 0;
            Proxy proxy = null;
            if (networkInfo != null) {
                if (networkInfo.getType() == 1) {
                    string = android.net.Proxy.getHost((Context)this.mMapCallback.getContext());
                    n2 = android.net.Proxy.getPort((Context)this.mMapCallback.getContext());
                } else {
                    string = android.net.Proxy.getDefaultHost();
                    n2 = android.net.Proxy.getDefaultPort();
                    if (string != null) {
                        proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n2));
                    }
                }
            }
            InputStream inputStream = null;
            try {
                Object object;
                BasicHttpParams basicHttpParams = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)20000);
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient((HttpParams)basicHttpParams);
                defaultHttpClient.getParams().setParameter("User-Agent", (Object)n.c);
                if (proxy != null) {
                    object = new HttpHost(string, n2);
                    defaultHttpClient.getParams().setParameter("http.route.default-proxy", object);
                }
                object = "" + this.getGridParma();
                String string2 = this.mMapCallback.getMapSvrAddress() + "/amapsrv/MPS?" + (String)object;
                o.a("amapv2", " getTile-->" + string2, 111);
                HttpGet httpGet = new HttpGet(string2);
                HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    HttpEntity httpEntity = httpResponse.getEntity();
                    inputStream = httpEntity.getContent();
                    this.onConnectionOpened(this);
                    byte[] byArray = new byte[2048];
                    int n3 = -1;
                    int n4 = 0;
                    while ((n3 = inputStream.read(byArray)) > -1 && this.isRequestValid()) {
                        if (this.mCanceled) {
                            break block22;
                        }
                        n4 += n3;
                        this.onConnectionRecieveData(this, 0, byArray, n3);
                    }
                    break block22;
                }
                this.OnException(1002);
            }
            catch (IOException iOException) {
                this.OnException(1002);
            }
            finally {
                this.onConnectionOver(this);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.OnException(1002);
                    }
                }
            }
        }
    }

    public boolean isRequestValid() {
        return this.mMapCallback.isGridsInScreen(this.mapTiles, this.datasource);
    }

    public void onConnectionError(MapLoader mapLoader, int n2, String string) {
    }

    public void onConnectionOpened(MapLoader mapLoader) {
        this.recievedDataBuffer = new byte[262144];
        this.nextImgDataLength = 0;
        this.recievedDataSize = 0;
        this.recievedHeader = false;
    }

    public void addReuqestTiles(MapSourceGridData mapSourceGridData) {
        this.mapTiles.add(mapSourceGridData);
    }

    public void onConnectionOver(MapLoader mapLoader) {
        this.recievedDataBuffer = null;
        this.nextImgDataLength = 0;
        this.recievedDataSize = 0;
        if (this.mMapCallback == null || this.mMapCallback.tileProcessCtrl == null || mapLoader == null || mapLoader.mapTiles == null) {
            return;
        }
        for (int i2 = 0; i2 < mapLoader.mapTiles.size(); ++i2) {
            MapSourceGridData mapSourceGridData = mapLoader.mapTiles.get(i2);
            if (mapSourceGridData == null) continue;
            this.mMapCallback.tileProcessCtrl.a(mapLoader.mapTiles.get(i2).getKeyGridName());
        }
    }

    public void onConnectionRecieveData(MapLoader mapLoader, int n2, byte[] byArray, int n3) {
        if (mapLoader == null || byArray == null) {
            return;
        }
        System.arraycopy(byArray, 0, this.recievedDataBuffer, this.recievedDataSize, n3);
        this.recievedDataSize += n3;
        boolean bl2 = false;
        if (!this.recievedHeader) {
            if (this.recievedDataSize > 7) {
                int n4 = 0;
                boolean bl3 = false;
                int n5 = Convert.getInt(this.recievedDataBuffer, n4);
                if (n5 != 0) {
                    mapLoader.mCanceled = true;
                    return;
                }
                n4 += 4;
                Convert.moveArray(this.recievedDataBuffer, n4 += 4, this.recievedDataBuffer, 0, n3 - 8);
                this.recievedDataSize -= n4;
                this.nextImgDataLength = 0;
                this.recievedHeader = true;
                this.processRecivedData();
            } else {
                return;
            }
        }
        this.processRecivedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecivedData() {
        if (this.nextImgDataLength == 0) {
            if (this.recievedDataSize >= 8) {
                this.nextImgDataLength = Convert.getInt(this.recievedDataBuffer, 0) + 8;
                this.processRecivedData();
            }
        } else if (this.recievedDataSize >= this.nextImgDataLength) {
            int n2 = Convert.getInt(this.recievedDataBuffer, 0);
            int n3 = Convert.getInt(this.recievedDataBuffer, 4);
            if (n3 == 0) {
                if (this.datasource == 2) {
                    this.processRecivedTileDataBmp(this.recievedDataBuffer, 8, n2 + 8);
                } else if (this.datasource == 4) {
                    this.processRecivedTileDataVTmc(this.recievedDataBuffer, 8, n2 + 8);
                } else if (this.datasource == 6) {
                    this.processRecivedModels(this.recievedDataBuffer, 8, n2 + 8);
                } else {
                    this.processRecivedTileData(this.recievedDataBuffer, 8, n2 + 8);
                }
            } else {
                GZIPInputStream gZIPInputStream = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.recievedDataBuffer, 8, n2);
                    gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[128];
                    int n4 = -1;
                    while ((n4 = gZIPInputStream.read(byArray)) > -1) {
                        byteArrayOutputStream.write(byArray, 0, n4);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    this.processRecivedTileData(byArray2, 0, n3);
                }
                catch (Throwable throwable) {
                    az.a(throwable, "MapLoader", "processRecivedData");
                    throwable.printStackTrace();
                }
                finally {
                    try {
                        if (gZIPInputStream != null) {
                            gZIPInputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            Convert.moveArray(this.recievedDataBuffer, this.nextImgDataLength, this.recievedDataBuffer, 0, this.recievedDataSize - this.nextImgDataLength);
            this.recievedDataSize -= this.nextImgDataLength;
            this.nextImgDataLength = 0;
            this.processRecivedData();
        }
    }

    void processRecivedTileData(byte[] byArray, int n2, int n3) {
        if (!this.mMapCore.isMapEngineValid()) {
            return;
        }
        this.mMapCore.putMapData(byArray, n2, n3 - n2, this.datasource);
    }

    void processRecivedTileDataBmp(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        if (!this.mMapCore.isMapEngineValid()) {
            return;
        }
        this.mMapCore.putMapData(byArray, n4, n3 - n4, this.datasource);
    }

    void processRecivedTileDataVTmc(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        n2 += 4;
        byte by2 = byArray[n2++];
        String string = "";
        try {
            string = new String(byArray, n2, (int)by2, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            az.a(unsupportedEncodingException, "MapLoader", "processRecivedTileDataVTmc");
            unsupportedEncodingException.printStackTrace();
        }
        if (!this.mMapCore.isMapEngineValid()) {
            return;
        }
        VTMCDataCache vTMCDataCache = VTMCDataCache.getInstance();
        byte[] byArray2 = new byte[n3 - n4];
        System.arraycopy(byArray, n4, byArray2, 0, n3 - n4);
        vTMCDataCache.putData(string, byArray2);
        this.mMapCore.putMapData(byArray, n4, n3 - n4, this.datasource);
    }

    void processRecivedModels(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        if (!this.mMapCore.isMapEngineValid()) {
            return;
        }
        byte[] byArray2 = new byte[n3 - n4];
        System.arraycopy(byArray, n4, byArray2, 0, n3 - n4);
        this.mMapCore.putMapData(byArray, n4, n3 - n4, this.datasource);
    }
}

