/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.amap.api.mapcore.util.az;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TextTextureGenerator {
    static Paint paint = null;
    static final int TEXT_FONTSIZE = 24;
    static final int AN_LABEL_MAXCHARINLINE = 7;
    static final int AN_LABEL_MULITYLINE_SPAN = 2;
    private float base_line = 0.0f;
    private float start_x = 0.0f;
    private static final int ALIGNCENTER = 51;
    private static final int ALIGNLEFT = 49;
    private static final int ALIGNRIGHT = 50;

    public static int GetNearstSize2N(int n2) {
        int n3 = 1;
        while (n2 > n3) {
            n3 *= 2;
        }
        return n3;
    }

    public TextTextureGenerator() {
        paint = TextTextureGenerator.newPaint(null, 24, 49);
        this.start_x = 0.0f;
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        float f2 = fontMetrics.bottom - fontMetrics.top;
        this.base_line = (24.0f - f2) / 2.0f - fontMetrics.top;
    }

    private static Paint newPaint(String string, int n2, int n3) {
        Paint paint = new Paint();
        paint.setColor(-1);
        paint.setTextSize((float)n2);
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setTypeface(Typeface.DEFAULT);
        switch (n3) {
            case 51: {
                paint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 49: {
                paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 50: {
                paint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                paint.setTextAlign(Paint.Align.LEFT);
            }
        }
        return paint;
    }

    public byte[] getTextPixelBuffer(int n2) {
        char[] cArray = new char[]{(char)n2};
        ByteBuffer byteBuffer = null;
        Bitmap bitmap = Bitmap.createBitmap((int)24, (int)24, (Bitmap.Config)Bitmap.Config.ALPHA_8);
        Canvas canvas = new Canvas(bitmap);
        byte[] byArray = new byte[576];
        byteBuffer = ByteBuffer.wrap(byArray);
        float f2 = paint.measureText(cArray[0] + "");
        Paint.Align align = paint.getTextAlign();
        float f3 = f2 - 24.0f;
        if (align != Paint.Align.CENTER && f3 >= 4.0f) {
            paint.setTextAlign(Paint.Align.CENTER);
            paint.setTextSize(24.0f - f3);
            canvas.drawText(cArray, 0, 1, (24.0f - f3) / 2.0f, this.base_line, paint);
            paint.setTextAlign(align);
        } else {
            canvas.drawText(cArray, 0, 1, this.start_x, this.base_line, paint);
        }
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        bitmap.recycle();
        bitmap = null;
        byteBuffer = null;
        return byArray;
    }

    private byte[] getPixels(Bitmap bitmap) {
        if (bitmap != null) {
            byte[] byArray = new byte[bitmap.getWidth() * bitmap.getHeight() * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.nativeOrder());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            return byArray;
        }
        return new byte[0];
    }

    public static byte[] getCharsWidths(int[] nArray) {
        try {
            Paint paint = TextTextureGenerator.newPaint(null, 24, 49);
            int n2 = nArray.length;
            byte[] byArray = new byte[n2];
            float[] fArray = new float[1];
            for (int i2 = 0; i2 < n2; ++i2) {
                paint.getTextWidths((char)nArray[i2] + "", fArray);
                byArray[i2] = (byte)fArray[0];
            }
            return byArray;
        }
        catch (Throwable throwable) {
            az.a(throwable, "TextTextureGenerator", "getCharsWidths");
            return new byte[0];
        }
    }

    public static byte[] getCharWidths() {
        Paint paint = TextTextureGenerator.newPaint(null, 24, 49);
        byte[] byArray = new byte[256];
        float[] fArray = new float[1];
        for (int i2 = 0; i2 < 256; ++i2) {
            paint.getTextWidths((char)i2 + "", fArray);
            byArray[i2] = (byte)fArray[0];
        }
        return byArray;
    }
}

