/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.bitmap.core;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import net.tsz.afinal.bitmap.core.BitmapCommonUtils;
import net.tsz.afinal.bitmap.core.BitmapDisplayConfig;
import net.tsz.afinal.bitmap.core.LruDiskCache;
import net.tsz.afinal.bitmap.download.Downloader;

public class BitmapProcess {
    private static final String TAG = "BitmapProcess";
    private boolean mHttpDiskCacheStarting = true;
    private int cacheSize;
    private static final int DEFAULT_CACHE_SIZE = 0x1400000;
    private LruDiskCache mOriginalDiskCache;
    private final Object mHttpDiskCacheLock = new Object();
    private static final int DISK_CACHE_INDEX = 0;
    private File mOriginalCacheDir;
    private Downloader downloader;

    public BitmapProcess(Downloader downloader, String filePath, int cacheSize) {
        this.mOriginalCacheDir = new File(String.valueOf(filePath) + "/original");
        this.downloader = downloader;
        if (cacheSize <= 0) {
            cacheSize = 0x1400000;
        }
        this.cacheSize = cacheSize;
    }

    /*
     * Exception decompiling
     */
    public Bitmap processBitmap(String data, BitmapDisplayConfig config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initHttpDiskCache() {
        if (!this.mOriginalCacheDir.exists()) {
            this.mOriginalCacheDir.mkdirs();
        }
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (BitmapCommonUtils.getUsableSpace(this.mOriginalCacheDir) > (long)this.cacheSize) {
                try {
                    this.mOriginalDiskCache = LruDiskCache.open(this.mOriginalCacheDir, 1, 1, this.cacheSize);
                }
                catch (IOException e) {
                    this.mOriginalDiskCache = null;
                }
            }
            this.mHttpDiskCacheStarting = false;
            this.mHttpDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null && !this.mOriginalDiskCache.isClosed()) {
                try {
                    this.mOriginalDiskCache.delete();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCacheInternal - " + e));
                }
                this.mOriginalDiskCache = null;
                this.mHttpDiskCacheStarting = true;
                this.initHttpDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null) {
                try {
                    this.mOriginalDiskCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null) {
                try {
                    if (!this.mOriginalDiskCache.isClosed()) {
                        this.mOriginalDiskCache.close();
                        this.mOriginalDiskCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("closeCacheInternal - " + e));
                }
            }
        }
    }
}

