/*
 * Decompiled with CFR 0.152.
 */
package net.tsz.afinal.http;

import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import net.tsz.afinal.http.entityhandler.StringEntityHandler;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

public class SyncRequestHandler {
    private final AbstractHttpClient client;
    private final HttpContext context;
    private final StringEntityHandler entityHandler = new StringEntityHandler();
    private int executionCount = 0;
    private String charset;

    public SyncRequestHandler(AbstractHttpClient client, HttpContext context, String charset) {
        this.client = client;
        this.context = context;
        this.charset = charset;
    }

    private Object makeRequestWithRetries(HttpUriRequest request) throws ConnectException {
        boolean retry = true;
        IOException cause = null;
        HttpRequestRetryHandler retryHandler = this.client.getHttpRequestRetryHandler();
        while (retry) {
            try {
                HttpResponse response = this.client.execute(request, this.context);
                return this.entityHandler.handleEntity(response.getEntity(), null, this.charset);
            }
            catch (UnknownHostException e) {
                cause = e;
            }
            catch (IOException e) {
                cause = e;
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
            catch (NullPointerException e) {
                retry = retryHandler.retryRequest(cause, ++this.executionCount, this.context);
            }
        }
        return null;
    }

    public Object sendRequest(HttpUriRequest ... params) {
        try {
            return this.makeRequestWithRetries(params[0]);
        }
        catch (ConnectException e) {
            e.printStackTrace();
            return null;
        }
    }
}

