/*
 * Decompiled with CFR 0.152.
 */
package com.qq.e.v2.util;

import com.qq.e.v2.util.GDTLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtil {
    public static boolean copyTo(InputStream inputStream, File file) {
        if (inputStream == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            return true;
        }
        catch (IOException iOException) {
            GDTLogger.report(String.format("Exception while copy  from InputStream to File %s", file.getAbsolutePath()), iOException);
            return false;
        }
        finally {
            FileUtil.tryClose(inputStream);
            FileUtil.tryClose(fileOutputStream);
        }
    }

    public static boolean renameTo(File file, File file2) {
        if (file == null || file2 == null || !file.exists()) {
            return false;
        }
        if (!file.renameTo(file2)) {
            return FileUtil.copyTo(null, file2);
        }
        return true;
    }

    public static void tryClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static void tryClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
                return;
            }
            catch (Exception exception) {}
        }
    }
}

