/*
 * Decompiled with CFR 0.152.
 */
package app.mosn.zdepthshadowlayout;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import app.mosn.zdepthshadowlayout.ZDepth;
import app.mosn.zdepthshadowlayout.ZDepthParam;
import app.mosn.zdepthshadowlayout.shadow.Shadow;
import app.mosn.zdepthshadowlayout.shadow.ShadowOval;
import app.mosn.zdepthshadowlayout.shadow.ShadowRect;

public class ShadowView
extends View {
    protected static final String TAG = "ShadowView";
    protected static final String ANIM_PROPERTY_ALPHA_TOP_SHADOW = "alphaTopShadow";
    protected static final String ANIM_PROPERTY_ALPHA_BOTTOM_SHADOW = "alphaBottomShadow";
    protected static final String ANIM_PROPERTY_OFFSET_TOP_SHADOW = "offsetTopShadow";
    protected static final String ANIM_PROPERTY_OFFSET_BOTTOM_SHADOW = "offsetBottomShadow";
    protected static final String ANIM_PROPERTY_BLUR_TOP_SHADOW = "blurTopShadow";
    protected static final String ANIM_PROPERTY_BLUR_BOTTOM_SHADOW = "blurBottomShadow";
    protected Shadow mShadow;
    protected ZDepthParam mZDepthParam;
    protected int mZDepthPaddingLeft;
    protected int mZDepthPaddingTop;
    protected int mZDepthPaddingRight;
    protected int mZDepthPaddingBottom;
    protected long mZDepthAnimDuration;
    protected boolean mZDepthDoAnimation;

    protected ShadowView(Context context) {
        this(context, null);
        this.init();
    }

    protected ShadowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.init();
    }

    protected ShadowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    protected void setZDepthDoAnimation(boolean doAnimation) {
        this.mZDepthDoAnimation = doAnimation;
    }

    protected void setZDepthAnimDuration(long duration) {
        this.mZDepthAnimDuration = duration;
    }

    protected void setZDepthPaddingLeft(int zDepthPaddingLeftValue) {
        ZDepth zDepth = this.getZDepthWithAttributeValue(zDepthPaddingLeftValue);
        this.mZDepthPaddingLeft = this.measureZDepthPadding(zDepth);
    }

    protected void setZDepthPaddingTop(int zDepthPaddingTopValue) {
        ZDepth zDepth = this.getZDepthWithAttributeValue(zDepthPaddingTopValue);
        this.mZDepthPaddingTop = this.measureZDepthPadding(zDepth);
    }

    protected void setZDepthPaddingRight(int zDepthPaddingRightValue) {
        ZDepth zDepth = this.getZDepthWithAttributeValue(zDepthPaddingRightValue);
        this.mZDepthPaddingRight = this.measureZDepthPadding(zDepth);
    }

    protected void setZDepthPaddingBottom(int zDepthPaddingBottomValue) {
        ZDepth zDepth = this.getZDepthWithAttributeValue(zDepthPaddingBottomValue);
        this.mZDepthPaddingBottom = this.measureZDepthPadding(zDepth);
    }

    protected int measureZDepthPadding(ZDepth zDepth) {
        float maxAboveBlurRadius = zDepth.getBlurTopShadowPx(this.getContext());
        float maxAboveOffset = zDepth.getOffsetYTopShadowPx(this.getContext());
        float maxBelowBlurRadius = zDepth.getBlurBottomShadowPx(this.getContext());
        float maxBelowOffset = zDepth.getOffsetYBottomShadowPx(this.getContext());
        float maxAboveSize = maxAboveBlurRadius + maxAboveOffset;
        float maxBelowSize = maxBelowBlurRadius + maxBelowOffset;
        return (int)Math.max(maxAboveSize, maxBelowSize);
    }

    protected int getZDepthPaddingLeft() {
        return this.mZDepthPaddingLeft;
    }

    protected int getZDepthPaddingTop() {
        return this.mZDepthPaddingTop;
    }

    protected int getZDepthPaddingRight() {
        return this.mZDepthPaddingRight;
    }

    protected int getZDepthPaddingBottom() {
        return this.mZDepthPaddingBottom;
    }

    protected void setShape(int shape) {
        switch (shape) {
            case 0: {
                this.mShadow = new ShadowRect();
                break;
            }
            case 1: {
                this.mShadow = new ShadowOval();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown shape value.");
            }
        }
    }

    protected void setZDepth(int zDepthValue) {
        ZDepth zDepth = this.getZDepthWithAttributeValue(zDepthValue);
        this.setZDepth(zDepth);
    }

    protected void setZDepth(ZDepth zDepth) {
        this.mZDepthParam = new ZDepthParam();
        this.mZDepthParam.initZDepth(this.getContext(), zDepth);
    }

    private ZDepth getZDepthWithAttributeValue(int zDepthValue) {
        switch (zDepthValue) {
            case 0: {
                return ZDepth.Depth0;
            }
            case 1: {
                return ZDepth.Depth1;
            }
            case 2: {
                return ZDepth.Depth2;
            }
            case 3: {
                return ZDepth.Depth3;
            }
            case 4: {
                return ZDepth.Depth4;
            }
            case 5: {
                return ZDepth.Depth5;
            }
        }
        throw new IllegalArgumentException("unknown zDepth value.");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int wSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int hSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (wMode) {
            case 0x40000000: {
                break;
            }
            case -2147483648: 
            case 0: {
                wSize = 0;
            }
        }
        switch (hMode) {
            case 0x40000000: {
                break;
            }
            case -2147483648: 
            case 0: {
                hSize = 0;
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)wSize, (int)wMode), View.MeasureSpec.makeMeasureSpec((int)hSize, (int)hMode));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int parentWidth = right - left;
        int parentHeight = bottom - top;
        this.mShadow.setParameter(this.mZDepthParam, this.mZDepthPaddingLeft, this.mZDepthPaddingTop, parentWidth - this.mZDepthPaddingRight, parentHeight - this.mZDepthPaddingBottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mShadow.onDraw(canvas);
    }

    protected void changeZDepth(ZDepth zDepth) {
        int newAlphaTopShadow = zDepth.getAlphaTopShadow();
        int newAlphaBottomShadow = zDepth.getAlphaBottomShadow();
        float newOffsetYTopShadow = zDepth.getOffsetYTopShadowPx(this.getContext());
        float newOffsetYBottomShadow = zDepth.getOffsetYBottomShadowPx(this.getContext());
        float newBlurTopShadow = zDepth.getBlurTopShadowPx(this.getContext());
        float newBlurBottomShadow = zDepth.getBlurBottomShadowPx(this.getContext());
        if (!this.mZDepthDoAnimation) {
            this.mZDepthParam.mAlphaTopShadow = newAlphaTopShadow;
            this.mZDepthParam.mAlphaBottomShadow = newAlphaBottomShadow;
            this.mZDepthParam.mOffsetYTopShadowPx = newOffsetYTopShadow;
            this.mZDepthParam.mOffsetYBottomShadowPx = newOffsetYBottomShadow;
            this.mZDepthParam.mBlurTopShadowPx = newBlurTopShadow;
            this.mZDepthParam.mBlurBottomShadowPx = newBlurBottomShadow;
            this.mShadow.setParameter(this.mZDepthParam, this.mZDepthPaddingLeft, this.mZDepthPaddingTop, this.getWidth() - this.mZDepthPaddingRight, this.getHeight() - this.mZDepthPaddingBottom);
            this.invalidate();
            return;
        }
        int nowAlphaTopShadow = this.mZDepthParam.mAlphaTopShadow;
        int nowAlphaBottomShadow = this.mZDepthParam.mAlphaBottomShadow;
        float nowOffsetYTopShadow = this.mZDepthParam.mOffsetYTopShadowPx;
        float nowOffsetYBottomShadow = this.mZDepthParam.mOffsetYBottomShadowPx;
        float nowBlurTopShadow = this.mZDepthParam.mBlurTopShadowPx;
        float nowBlurBottomShadow = this.mZDepthParam.mBlurBottomShadowPx;
        PropertyValuesHolder alphaTopShadowHolder = PropertyValuesHolder.ofInt((String)ANIM_PROPERTY_ALPHA_TOP_SHADOW, (int[])new int[]{nowAlphaTopShadow, newAlphaTopShadow});
        PropertyValuesHolder alphaBottomShadowHolder = PropertyValuesHolder.ofInt((String)ANIM_PROPERTY_ALPHA_BOTTOM_SHADOW, (int[])new int[]{nowAlphaBottomShadow, newAlphaBottomShadow});
        PropertyValuesHolder offsetTopShadowHolder = PropertyValuesHolder.ofFloat((String)ANIM_PROPERTY_OFFSET_TOP_SHADOW, (float[])new float[]{nowOffsetYTopShadow, newOffsetYTopShadow});
        PropertyValuesHolder offsetBottomShadowHolder = PropertyValuesHolder.ofFloat((String)ANIM_PROPERTY_OFFSET_BOTTOM_SHADOW, (float[])new float[]{nowOffsetYBottomShadow, newOffsetYBottomShadow});
        PropertyValuesHolder blurTopShadowHolder = PropertyValuesHolder.ofFloat((String)ANIM_PROPERTY_BLUR_TOP_SHADOW, (float[])new float[]{nowBlurTopShadow, newBlurTopShadow});
        PropertyValuesHolder blurBottomShadowHolder = PropertyValuesHolder.ofFloat((String)ANIM_PROPERTY_BLUR_BOTTOM_SHADOW, (float[])new float[]{nowBlurBottomShadow, newBlurBottomShadow});
        ValueAnimator anim = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{alphaTopShadowHolder, alphaBottomShadowHolder, offsetTopShadowHolder, offsetBottomShadowHolder, blurTopShadowHolder, blurBottomShadowHolder});
        anim.setDuration(this.mZDepthAnimDuration);
        anim.setInterpolator((TimeInterpolator)new LinearInterpolator());
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int alphaTopShadow = (Integer)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_ALPHA_TOP_SHADOW);
                int alphaBottomShadow = (Integer)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_ALPHA_BOTTOM_SHADOW);
                float offsetTopShadow = ((Float)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_OFFSET_TOP_SHADOW)).floatValue();
                float offsetBottomShadow = ((Float)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_OFFSET_BOTTOM_SHADOW)).floatValue();
                float blurTopShadow = ((Float)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_BLUR_TOP_SHADOW)).floatValue();
                float blurBottomShadow = ((Float)animation.getAnimatedValue(ShadowView.ANIM_PROPERTY_BLUR_BOTTOM_SHADOW)).floatValue();
                ShadowView.this.mZDepthParam.mAlphaTopShadow = alphaTopShadow;
                ShadowView.this.mZDepthParam.mAlphaBottomShadow = alphaBottomShadow;
                ShadowView.this.mZDepthParam.mOffsetYTopShadowPx = offsetTopShadow;
                ShadowView.this.mZDepthParam.mOffsetYBottomShadowPx = offsetBottomShadow;
                ShadowView.this.mZDepthParam.mBlurTopShadowPx = blurTopShadow;
                ShadowView.this.mZDepthParam.mBlurBottomShadowPx = blurBottomShadow;
                ShadowView.this.mShadow.setParameter(ShadowView.this.mZDepthParam, ShadowView.this.mZDepthPaddingLeft, ShadowView.this.mZDepthPaddingTop, ShadowView.this.getWidth() - ShadowView.this.mZDepthPaddingRight, ShadowView.this.getHeight() - ShadowView.this.mZDepthPaddingBottom);
                ShadowView.this.invalidate();
            }
        });
        anim.start();
    }
}

