/*
 * Decompiled with CFR 0.152.
 */
package app.mosn.zdepthshadowlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import app.mosn.zdepthshadowlayout.R;
import app.mosn.zdepthshadowlayout.ShadowView;
import app.mosn.zdepthshadowlayout.ZDepth;

public class ZDepthShadowLayout
extends FrameLayout {
    public static final String TAG = "ZDepthShadowLayout";
    protected static final int DEFAULT_ATTR_SHAPE = 0;
    protected static final int DEFAULT_ATTR_ZDEPTH = 1;
    protected static final int DEFAULT_ATTR_ZDEPTH_PADDING = 5;
    protected static final int DEFAULT_ATTR_ZDEPTH_ANIM_DURATION = 150;
    protected static final boolean DEFAULT_ATTR_ZDEPTH_DO_ANIMATION = true;
    protected static final int SHAPE_RECT = 0;
    protected static final int SHAPE_OVAL = 1;
    protected ShadowView mShadowView;
    protected int mAttrShape;
    protected int mAttrZDepth;
    protected int mAttrZDepthPaddingLeft;
    protected int mAttrZDepthPaddingTop;
    protected int mAttrZDepthPaddingRight;
    protected int mAttrZDepthPaddingBottom;
    protected long mAttrZDepthAnimDuration;
    protected boolean mAttrZDepthDoAnimation;

    public ZDepthShadowLayout(Context context) {
        this(context, null);
    }

    public ZDepthShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ZDepthShadowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    protected void init(AttributeSet attrs, int defStyle) {
        this.setClipToPadding(false);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ZDepthShadowLayout, defStyle, 0);
        this.mAttrShape = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_shape, 0);
        this.mAttrZDepth = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth, 1);
        this.mAttrZDepthAnimDuration = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_animDuration, 150);
        this.mAttrZDepthDoAnimation = typedArray.getBoolean(R.styleable.ZDepthShadowLayout_z_depth_doAnim, true);
        int attrZDepthPadding = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_padding, -1);
        int attrZDepthPaddingLeft = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_paddingLeft, -1);
        int attrZDepthPaddingTop = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_paddingTop, -1);
        int attrZDepthPaddingRight = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_paddingRight, -1);
        int attrZDepthPaddingBottom = typedArray.getInt(R.styleable.ZDepthShadowLayout_z_depth_paddingBottom, -1);
        if (attrZDepthPadding > -1) {
            this.mAttrZDepthPaddingLeft = attrZDepthPadding;
            this.mAttrZDepthPaddingTop = attrZDepthPadding;
            this.mAttrZDepthPaddingRight = attrZDepthPadding;
            this.mAttrZDepthPaddingBottom = attrZDepthPadding;
        } else {
            this.mAttrZDepthPaddingLeft = attrZDepthPaddingLeft > -1 ? attrZDepthPaddingLeft : 5;
            this.mAttrZDepthPaddingTop = attrZDepthPaddingTop > -1 ? attrZDepthPaddingTop : 5;
            this.mAttrZDepthPaddingRight = attrZDepthPaddingRight > -1 ? attrZDepthPaddingRight : 5;
            this.mAttrZDepthPaddingBottom = attrZDepthPaddingBottom > -1 ? attrZDepthPaddingBottom : 5;
        }
        typedArray.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mShadowView = new ShadowView(this.getContext());
        this.mShadowView.setShape(this.mAttrShape);
        this.mShadowView.setZDepth(this.mAttrZDepth);
        this.mShadowView.setZDepthPaddingLeft(this.mAttrZDepthPaddingLeft);
        this.mShadowView.setZDepthPaddingTop(this.mAttrZDepthPaddingTop);
        this.mShadowView.setZDepthPaddingRight(this.mAttrZDepthPaddingRight);
        this.mShadowView.setZDepthPaddingBottom(this.mAttrZDepthPaddingBottom);
        this.mShadowView.setZDepthAnimDuration(this.mAttrZDepthAnimDuration);
        this.mShadowView.setZDepthDoAnimation(this.mAttrZDepthDoAnimation);
        this.addView(this.mShadowView, 0);
        int paddingLeft = this.mShadowView.getZDepthPaddingLeft();
        int paddingTop = this.mShadowView.getZDepthPaddingTop();
        int paddingRight = this.mShadowView.getZDepthPaddingRight();
        int paddingBottom = this.mShadowView.getZDepthPaddingBottom();
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        int maxChildViewWidth = 0;
        int maxChildViewHeight = 0;
        int i = 0;
        while (i < childCount) {
            View child = this.getChildAt(i);
            if (maxChildViewWidth < child.getMeasuredWidth()) {
                maxChildViewWidth = child.getMeasuredWidth();
            }
            if (maxChildViewHeight < child.getMeasuredHeight()) {
                maxChildViewHeight = child.getMeasuredHeight();
            }
            ++i;
        }
        int paddingLeft = this.mShadowView.getZDepthPaddingLeft();
        int paddingTop = this.mShadowView.getZDepthPaddingTop();
        int paddingRight = this.mShadowView.getZDepthPaddingRight();
        int paddingBottom = this.mShadowView.getZDepthPaddingBottom();
        this.mShadowView.measure(View.MeasureSpec.makeMeasureSpec((int)(maxChildViewWidth += paddingLeft + paddingRight), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(maxChildViewHeight += paddingTop + paddingBottom), (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = right - left;
        int height = bottom - top;
        this.mShadowView.layout(0, 0, width, height);
    }

    public int getWidthExceptShadow() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public int getHeightExceptShadow() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public void changeZDepth(ZDepth zDepth) {
        this.mShadowView.changeZDepth(zDepth);
    }
}

