/*
 * Decompiled with CFR 0.152.
 */
package app.mosn.zdepthshadowlayout.shadow;

import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.RectF;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import app.mosn.zdepthshadowlayout.ZDepthParam;
import app.mosn.zdepthshadowlayout.shadow.Shadow;

public class ShadowOval
implements Shadow {
    private ShapeDrawable mTopShadow;
    private ShapeDrawable mBottomShadow;
    private RectF mRectTopShadow = new RectF();
    private RectF mRectBottomShadow = new RectF();

    public ShadowOval() {
        this.mTopShadow = new ShapeDrawable((Shape)new OvalShape());
        this.mBottomShadow = new ShapeDrawable((Shape)new OvalShape());
    }

    @Override
    public void setParameter(ZDepthParam param, int left, int top, int right, int bottom) {
        this.mRectTopShadow.left = left;
        this.mRectTopShadow.top = (float)top + param.mOffsetYTopShadowPx;
        this.mRectTopShadow.right = right;
        this.mRectTopShadow.bottom = (float)bottom + param.mOffsetYTopShadowPx;
        this.mRectBottomShadow.left = left;
        this.mRectBottomShadow.top = (float)top + param.mOffsetYBottomShadowPx;
        this.mRectBottomShadow.right = right;
        this.mRectBottomShadow.bottom = (float)bottom + param.mOffsetYBottomShadowPx;
        this.mTopShadow.getPaint().setColor(Color.argb((int)param.mAlphaTopShadow, (int)0, (int)0, (int)0));
        if (0.0f < param.mBlurTopShadowPx) {
            this.mTopShadow.getPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(param.mBlurTopShadowPx, BlurMaskFilter.Blur.NORMAL));
        } else {
            this.mTopShadow.getPaint().setMaskFilter(null);
        }
        this.mBottomShadow.getPaint().setColor(Color.argb((int)param.mAlphaBottomShadow, (int)0, (int)0, (int)0));
        if (0.0f < param.mBlurBottomShadowPx) {
            this.mBottomShadow.getPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(param.mBlurBottomShadowPx, BlurMaskFilter.Blur.NORMAL));
        } else {
            this.mBottomShadow.getPaint().setMaskFilter(null);
        }
    }

    @Override
    public void onDraw(Canvas canvas) {
        canvas.drawOval(this.mRectBottomShadow, this.mBottomShadow.getPaint());
        canvas.drawOval(this.mRectTopShadow, this.mTopShadow.getPaint());
    }
}

