/*
 * Decompiled with CFR 0.152.
 */
package app.mosn.zdepthshadowlayout.shadow;

import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Rect;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import app.mosn.zdepthshadowlayout.ZDepthParam;
import app.mosn.zdepthshadowlayout.shadow.Shadow;

public class ShadowRect
implements Shadow {
    private ShapeDrawable mTopShadow;
    private ShapeDrawable mBottomShadow;
    private Rect mRectTopShadow = new Rect();
    private Rect mRectBottomShadow = new Rect();

    public ShadowRect() {
        this.mTopShadow = new ShapeDrawable((Shape)new RectShape());
        this.mBottomShadow = new ShapeDrawable((Shape)new RectShape());
    }

    @Override
    public void setParameter(ZDepthParam param, int left, int top, int right, int bottom) {
        this.mRectTopShadow.left = left;
        this.mRectTopShadow.top = (int)((float)top + param.mOffsetYTopShadowPx);
        this.mRectTopShadow.right = right;
        this.mRectTopShadow.bottom = (int)((float)bottom + param.mOffsetYTopShadowPx);
        this.mRectBottomShadow.left = left;
        this.mRectBottomShadow.top = (int)((float)top + param.mOffsetYBottomShadowPx);
        this.mRectBottomShadow.right = right;
        this.mRectBottomShadow.bottom = (int)((float)bottom + param.mOffsetYBottomShadowPx);
        this.mTopShadow.getPaint().setColor(Color.argb((int)param.mAlphaTopShadow, (int)0, (int)0, (int)0));
        if (0.0f < param.mBlurTopShadowPx) {
            this.mTopShadow.getPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(param.mBlurTopShadowPx, BlurMaskFilter.Blur.NORMAL));
        } else {
            this.mTopShadow.getPaint().setMaskFilter(null);
        }
        this.mBottomShadow.getPaint().setColor(Color.argb((int)param.mAlphaBottomShadow, (int)0, (int)0, (int)0));
        if (0.0f < param.mBlurBottomShadowPx) {
            this.mBottomShadow.getPaint().setMaskFilter((MaskFilter)new BlurMaskFilter(param.mBlurBottomShadowPx, BlurMaskFilter.Blur.NORMAL));
        } else {
            this.mBottomShadow.getPaint().setMaskFilter(null);
        }
    }

    @Override
    public void onDraw(Canvas canvas) {
        canvas.drawRect(this.mRectBottomShadow, this.mBottomShadow.getPaint());
        canvas.drawRect(this.mRectTopShadow, this.mTopShadow.getPaint());
    }
}

