package com.oyp.thermometer;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.animation.ScaleAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;

/**
 * @author 欧阳鹏
 * @date 2015年9月14日 <br>
 *       <a href="http://blog.csdn.net/ouyang_peng">欧阳鹏CSDN博客地址</a></n>
 */
public class ThermometerActivity extends Activity implements SensorEventListener {
	private LinearLayout alcohol;
	private LinearLayout meter;
	private SensorManager mSensorManager;
	private Sensor temperatureSensor;
	private TextView thermo_c;
	private TextView thermo_f;

	public float staratemp;
	public float temp;
	private float temperatureC;

	/**
	 * 获取华氏温度
	 * 
	 * @author ouyang
	 * @date 2015年9月14日
	 * @return
	 */
	public float getTemperatureF() {
		float temperatureF = (temperatureC * 9 / 5) + 32;
		return getFloatOne(temperatureF);
	}

	/**
	 * 保留一位小数点
	 * 
	 * @author ouyang
	 * @date 2015年9月14日
	 * @param tempFloat
	 * @return
	 */
	public float getFloatOne(float tempFloat) {
		return (float) (Math.round(tempFloat * 10)) / 10;
	}

	/**
	 * 获取摄氏温度
	 * 
	 * @author ouyang
	 * @date 2015年9月14日
	 * @return
	 */
	public float getTemperatureC() {
		return getFloatOne(temperatureC);
	}

	public void setTemperatureC(float temperatureC) {
		this.temperatureC = temperatureC;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.layout_thermometer);
		meter = ((LinearLayout) findViewById(R.id.meter));
		alcohol = ((LinearLayout) findViewById(R.id.alcohol));
		thermo_c = (TextView) findViewById(R.id.thermo_c);
		thermo_f = (TextView) findViewById(R.id.thermo_f);
	}

	@Override
	protected void onResume() {
		super.onResume();
		mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		temperatureSensor = mSensorManager.getDefaultSensor(Sensor.TYPE_AMBIENT_TEMPERATURE);
		mSensorManager.registerListener(this, temperatureSensor, SensorManager.SENSOR_DELAY_NORMAL);
	}

	@Override
	public final void onSensorChanged(SensorEvent event) {
		float temperatureValue = event.values[0]; // 得到温度
		setTemperatureC(temperatureValue);// 设置温度
		mUpdateUi();// 更新UI
	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {

	}

	/**
	 * 更新刻度上水银柱的长度
	 * 
	 * @author ouyang
	 * @date 2015年9月14日
	 */
	private void mUpdateUi() {
		ScaleAnimation localScaleAnimation1 = new ScaleAnimation(1.0F, 1.0F, this.staratemp, this.temp, 1, 0.5F, 1,
				1.0F);
		localScaleAnimation1.setDuration(2000L);
		localScaleAnimation1.setFillEnabled(true);
		localScaleAnimation1.setFillAfter(true);
		this.alcohol.startAnimation(localScaleAnimation1);
		this.staratemp = this.temp;

		ScaleAnimation localScaleAnimation2 = new ScaleAnimation(1.0F, 1.0F, 1.0F, 1.0F, 1, 0.5F, 1, 0.5F);
		localScaleAnimation2.setDuration(10L);
		localScaleAnimation2.setFillEnabled(true);
		localScaleAnimation2.setFillAfter(true);
		this.meter.startAnimation(localScaleAnimation2);

		// 把刻度表看出总共700份，如何计算缩放比例。从-20°到50°。
		// 例如，现在温度是30°的话，应该占（30+20）*10=500份 其中20是0到-20°所占有的份
		this.temp = (float) ((20.0F + getTemperatureC()) * 10) / (70.0F * 10);

		thermo_c.setText(getTemperatureC() + "");
		thermo_f.setText(getTemperatureF() + "");
	}
}
