/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int MINIMUM_DIMENSION = 40;
    private BitMatrix matrix = null;

    public HybridBinarizer(LuminanceSource source) {
        super(source);
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        this.binarizeEntireImage();
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new HybridBinarizer(source);
    }

    private void binarizeEntireImage() throws NotFoundException {
        if (this.matrix == null) {
            LuminanceSource source = this.getLuminanceSource();
            if (source.getWidth() >= 40 && source.getHeight() >= 40) {
                byte[] luminances = source.getMatrix();
                int width = source.getWidth();
                int height = source.getHeight();
                int subWidth = width >> 3;
                if ((width & 7) != 0) {
                    ++subWidth;
                }
                int subHeight = height >> 3;
                if ((height & 7) != 0) {
                    ++subHeight;
                }
                int[][] blackPoints = HybridBinarizer.calculateBlackPoints(luminances, subWidth, subHeight, width, height);
                this.matrix = new BitMatrix(width, height);
                HybridBinarizer.calculateThresholdForBlock(luminances, subWidth, subHeight, width, height, blackPoints, this.matrix);
            } else {
                this.matrix = super.getBlackMatrix();
            }
        }
    }

    private static void calculateThresholdForBlock(byte[] luminances, int subWidth, int subHeight, int width, int height, int[][] blackPoints, BitMatrix matrix) {
        int y = 0;
        while (y < subHeight) {
            int yoffset = y << 3;
            if (yoffset + 8 >= height) {
                yoffset = height - 8;
            }
            int x = 0;
            while (x < subWidth) {
                int xoffset = x << 3;
                if (xoffset + 8 >= width) {
                    xoffset = width - 8;
                }
                int left = x > 1 ? x : 2;
                left = left < subWidth - 2 ? left : subWidth - 3;
                int top = y > 1 ? y : 2;
                top = top < subHeight - 2 ? top : subHeight - 3;
                int sum = 0;
                int z = -2;
                while (z <= 2) {
                    int[] blackRow = blackPoints[top + z];
                    sum += blackRow[left - 2];
                    sum += blackRow[left - 1];
                    sum += blackRow[left];
                    sum += blackRow[left + 1];
                    sum += blackRow[left + 2];
                    ++z;
                }
                int average = sum / 25;
                HybridBinarizer.threshold8x8Block(luminances, xoffset, yoffset, average, width, matrix);
                ++x;
            }
            ++y;
        }
    }

    private static void threshold8x8Block(byte[] luminances, int xoffset, int yoffset, int threshold, int stride, BitMatrix matrix) {
        int y = 0;
        while (y < 8) {
            int offset = (yoffset + y) * stride + xoffset;
            int x = 0;
            while (x < 8) {
                int pixel = luminances[offset + x] & 0xFF;
                if (pixel < threshold) {
                    matrix.set(xoffset + x, yoffset + y);
                }
                ++x;
            }
            ++y;
        }
    }

    private static int[][] calculateBlackPoints(byte[] luminances, int subWidth, int subHeight, int width, int height) {
        int[][] blackPoints = new int[subHeight][subWidth];
        int y = 0;
        while (y < subHeight) {
            int yoffset = y << 3;
            if (yoffset + 8 >= height) {
                yoffset = height - 8;
            }
            int x = 0;
            while (x < subWidth) {
                int xoffset = x << 3;
                if (xoffset + 8 >= width) {
                    xoffset = width - 8;
                }
                int sum = 0;
                int min = 255;
                int max = 0;
                int yy = 0;
                while (yy < 8) {
                    int offset = (yoffset + yy) * width + xoffset;
                    int xx = 0;
                    while (xx < 8) {
                        int pixel = luminances[offset + xx] & 0xFF;
                        sum += pixel;
                        if (pixel < min) {
                            min = pixel;
                        }
                        if (pixel > max) {
                            max = pixel;
                        }
                        ++xx;
                    }
                    ++yy;
                }
                int average = max - min > 24 ? sum >> 6 : (max == 0 ? 1 : min >> 1);
                blackPoints[y][x] = average;
                ++x;
            }
            ++y;
        }
        return blackPoints;
    }
}

