/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GF256;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.datamatrix.decoder.BitMatrixParser;
import com.google.zxing.datamatrix.decoder.DataBlock;
import com.google.zxing.datamatrix.decoder.DecodedBitStreamParser;
import com.google.zxing.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GF256.DATA_MATRIX_FIELD);

    public DecoderResult decode(boolean[][] image) throws FormatException, ChecksumException {
        int dimension = image.length;
        BitMatrix bits = new BitMatrix(dimension);
        int i = 0;
        while (i < dimension) {
            int j = 0;
            while (j < dimension) {
                if (image[i][j]) {
                    bits.set(j, i);
                }
                ++j;
            }
            ++i;
        }
        return this.decode(bits);
    }

    public DecoderResult decode(BitMatrix bits) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        Version version = parser.readVersion(bits);
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version);
        int totalBytes = 0;
        int i = 0;
        while (i < dataBlocks.length) {
            totalBytes += dataBlocks[i].getNumDataCodewords();
            ++i;
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        int j = 0;
        while (j < dataBlocks.length) {
            DataBlock dataBlock = dataBlocks[j];
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            int i2 = 0;
            while (i2 < numDataCodewords) {
                resultBytes[resultOffset++] = codewordBytes[i2];
                ++i2;
            }
            ++j;
        }
        return DecodedBitStreamParser.decode(resultBytes);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        int i = 0;
        while (i < numCodewords) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
            ++i;
        }
        int numECCodewords = codewordBytes.length - numDataCodewords;
        try {
            this.rsDecoder.decode(codewordsInts, numECCodewords);
        }
        catch (ReedSolomonException rse) {
            throw ChecksumException.getChecksumInstance();
        }
        int i2 = 0;
        while (i2 < numDataCodewords) {
            codewordBytes[i2] = (byte)codewordsInts[i2];
            ++i2;
        }
    }
}

