/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class Code128Writer
extends UPCEANWriter {
    @Override
    public BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        if (format != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + format);
        }
        return super.encode(contents, format, width, height, hints);
    }

    @Override
    public byte[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        int codeWidth = 35;
        int i = 0;
        while (i < length) {
            int[] patterns = Code128Reader.CODE_PATTERNS[contents.charAt(i) - 32];
            int j = 0;
            while (j < patterns.length) {
                codeWidth += patterns[j];
                ++j;
            }
            ++i;
        }
        byte[] result = new byte[codeWidth];
        int pos = Code128Writer.appendPattern(result, 0, Code128Reader.CODE_PATTERNS[104], 1);
        int check = 104;
        int i2 = 0;
        while (i2 < length) {
            check += (contents.charAt(i2) - 32) * (i2 + 1);
            pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[contents.charAt(i2) - 32], 1);
            ++i2;
        }
        pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[check %= 103], 1);
        pos += Code128Writer.appendPattern(result, pos, Code128Reader.CODE_PATTERNS[106], 1);
        return result;
    }
}

