/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.RSSUtils;
import com.google.zxing.oned.rss.expanded.BitArrayBuilder;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.Hashtable;
import java.util.Vector;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM;
    private static final int[][] FINDER_PATTERNS;
    private static final int[][] WEIGHTS;
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES;
    private static final int LONGEST_SEQUENCE_SIZE;
    private static final int MAX_PAIRS = 11;
    private final Vector pairs = new Vector(11);
    private final int[] startEnd = new int[2];
    private final int[] currentSequence = new int[LONGEST_SEQUENCE_SIZE];

    static {
        int[] nArray = new int[5];
        nArray[1] = 348;
        nArray[2] = 1388;
        nArray[3] = 2948;
        nArray[4] = 3988;
        GSUM = nArray;
        FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
        WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[2];
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 2;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[1] = 4;
        nArray4[2] = 1;
        nArray4[3] = 3;
        nArray4[4] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 4;
        nArray5[2] = 1;
        nArray5[3] = 3;
        nArray5[4] = 3;
        nArray5[5] = 5;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 4;
        nArray6[2] = 1;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 2;
        nArray7[5] = 2;
        nArray7[6] = 3;
        nArray7[7] = 3;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[9];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 2;
        nArray8[5] = 2;
        nArray8[6] = 3;
        nArray8[7] = 4;
        nArray8[8] = 4;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[10];
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[4] = 2;
        nArray9[5] = 2;
        nArray9[6] = 3;
        nArray9[7] = 4;
        nArray9[8] = 5;
        nArray9[9] = 5;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[11];
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[4] = 2;
        nArray10[5] = 3;
        nArray10[6] = 3;
        nArray10[7] = 4;
        nArray10[8] = 4;
        nArray10[9] = 5;
        nArray10[10] = 5;
        nArrayArray[9] = nArray10;
        FINDER_PATTERN_SEQUENCES = nArrayArray;
        LONGEST_SEQUENCE_SIZE = FINDER_PATTERN_SEQUENCES[FINDER_PATTERN_SEQUENCES.length - 1].length;
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws NotFoundException {
        this.reset();
        this.decodeRow2pairs(rowNumber, row);
        return RSSExpandedReader.constructResult(this.pairs);
    }

    @Override
    public void reset() {
        this.pairs.setSize(0);
    }

    Vector decodeRow2pairs(int rowNumber, BitArray row) throws NotFoundException {
        while (true) {
            ExpandedPair nextPair = this.retrieveNextPair(row, this.pairs, rowNumber);
            this.pairs.addElement(nextPair);
            if (!nextPair.mayBeLast()) continue;
            if (this.checkChecksum()) {
                return this.pairs;
            }
            if (nextPair.mustBeLast()) break;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Result constructResult(Vector pairs) throws NotFoundException {
        BitArray binary = BitArrayBuilder.buildBitArray(pairs);
        AbstractExpandedDecoder decoder = AbstractExpandedDecoder.createDecoder(binary);
        String resultingString = decoder.parseInformation();
        ResultPoint[] firstPoints = ((ExpandedPair)pairs.elementAt(0)).getFinderPattern().getResultPoints();
        ResultPoint[] lastPoints = ((ExpandedPair)pairs.lastElement()).getFinderPattern().getResultPoints();
        return new Result(resultingString, null, new ResultPoint[]{firstPoints[0], firstPoints[1], lastPoints[0], lastPoints[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        ExpandedPair firstPair = (ExpandedPair)this.pairs.elementAt(0);
        DataCharacter checkCharacter = firstPair.getLeftChar();
        DataCharacter firstCharacter = firstPair.getRightChar();
        int checksum = firstCharacter.getChecksumPortion();
        int S = 2;
        int i = 1;
        while (i < this.pairs.size()) {
            ExpandedPair currentPair = (ExpandedPair)this.pairs.elementAt(i);
            checksum += currentPair.getLeftChar().getChecksumPortion();
            ++S;
            if (currentPair.getRightChar() != null) {
                checksum += currentPair.getRightChar().getChecksumPortion();
                ++S;
            }
            ++i;
        }
        int checkCharacterValue = 211 * (S - 4) + (checksum %= 211);
        return checkCharacterValue == checkCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray row, int initialPos) {
        int currentPos = initialPos;
        boolean current = row.get(currentPos);
        while (currentPos < row.size && row.get(currentPos) == current) {
            ++currentPos;
        }
        current = !current;
        while (currentPos < row.size && row.get(currentPos) == current) {
            ++currentPos;
        }
        return currentPos;
    }

    ExpandedPair retrieveNextPair(BitArray row, Vector previousPairs, int rowNumber) throws NotFoundException {
        DataCharacter rightChar;
        FinderPattern pattern;
        boolean isOddPattern = previousPairs.size() % 2 == 0;
        boolean keepFinding = true;
        int forcedOffset = -1;
        do {
            this.findNextPair(row, previousPairs, forcedOffset);
            pattern = this.parseFoundFinderPattern(row, rowNumber, isOddPattern);
            if (pattern == null) {
                forcedOffset = RSSExpandedReader.getNextSecondBar(row, this.startEnd[0]);
                continue;
            }
            keepFinding = false;
        } while (keepFinding);
        boolean mayBeLast = this.checkPairSequence(previousPairs, pattern);
        DataCharacter leftChar = this.decodeDataCharacter(row, pattern, isOddPattern, true);
        try {
            rightChar = this.decodeDataCharacter(row, pattern, isOddPattern, false);
        }
        catch (NotFoundException nfe) {
            if (mayBeLast) {
                rightChar = null;
            }
            throw nfe;
        }
        return new ExpandedPair(leftChar, rightChar, pattern, mayBeLast);
    }

    private boolean checkPairSequence(Vector previousPairs, FinderPattern pattern) throws NotFoundException {
        int currentSequenceLength = previousPairs.size() + 1;
        if (currentSequenceLength > this.currentSequence.length) {
            throw NotFoundException.getNotFoundInstance();
        }
        int pos = 0;
        while (pos < previousPairs.size()) {
            this.currentSequence[pos] = ((ExpandedPair)previousPairs.elementAt(pos)).getFinderPattern().getValue();
            ++pos;
        }
        this.currentSequence[currentSequenceLength - 1] = pattern.getValue();
        int i = 0;
        while (i < FINDER_PATTERN_SEQUENCES.length) {
            int[] validSequence = FINDER_PATTERN_SEQUENCES[i];
            if (validSequence.length >= currentSequenceLength) {
                boolean valid = true;
                int pos2 = 0;
                while (pos2 < currentSequenceLength) {
                    if (this.currentSequence[pos2] != validSequence[pos2]) {
                        valid = false;
                        break;
                    }
                    ++pos2;
                }
                if (valid) {
                    return currentSequenceLength == validSequence.length;
                }
            }
            ++i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void findNextPair(BitArray row, Vector previousPairs, int forcedOffset) throws NotFoundException {
        int rowOffset;
        int[] counters = this.decodeFinderCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int width = row.getSize();
        if (forcedOffset >= 0) {
            rowOffset = forcedOffset;
        } else if (previousPairs.isEmpty()) {
            rowOffset = 0;
        } else {
            ExpandedPair lastPair = (ExpandedPair)previousPairs.lastElement();
            rowOffset = lastPair.getFinderPattern().getStartEnd()[1];
        }
        boolean searchingEvenPair = previousPairs.size() % 2 != 0;
        boolean isWhite = false;
        while (rowOffset < width) {
            boolean bl = isWhite = !row.get(rowOffset);
            if (!isWhite) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int patternStart = rowOffset;
        int x = rowOffset;
        while (x < width) {
            boolean pixel = row.get(x);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == 3) {
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    if (RSSExpandedReader.isFinderPattern(counters)) {
                        this.startEnd[0] = patternStart;
                        this.startEnd[1] = x;
                        return;
                    }
                    if (searchingEvenPair) {
                        RSSExpandedReader.reverseCounters(counters);
                    }
                    patternStart += counters[0] + counters[1];
                    counters[0] = counters[2];
                    counters[1] = counters[3];
                    counters[2] = 0;
                    counters[3] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] counters) {
        int length = counters.length;
        int i = 0;
        while (i < length / 2) {
            int tmp = counters[i];
            counters[i] = counters[length - i - 1];
            counters[length - i - 1] = tmp;
            ++i;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray row, int rowNumber, boolean oddPattern) {
        int value;
        int end;
        int start;
        int firstCounter;
        int firstElementStart;
        if (oddPattern) {
            firstElementStart = this.startEnd[0] - 1;
            while (firstElementStart >= 0 && !row.get(firstElementStart)) {
                --firstElementStart;
            }
            firstCounter = this.startEnd[0] - ++firstElementStart;
            start = firstElementStart;
            end = this.startEnd[1];
        } else {
            start = this.startEnd[0];
            firstElementStart = this.startEnd[1] + 1;
            while (row.get(firstElementStart) && firstElementStart < row.size) {
                ++firstElementStart;
            }
            end = firstElementStart;
            firstCounter = end - this.startEnd[1];
        }
        int[] counters = this.decodeFinderCounters;
        int i = counters.length - 1;
        while (i > 0) {
            counters[i] = counters[i - 1];
            --i;
        }
        counters[0] = firstCounter;
        try {
            value = RSSExpandedReader.parseFinderValue(counters, FINDER_PATTERNS);
        }
        catch (NotFoundException nfe) {
            return null;
        }
        return new FinderPattern(value, new int[]{start, end}, start, end, rowNumber);
    }

    DataCharacter decodeDataCharacter(BitArray row, FinderPattern pattern, boolean isOddPattern, boolean leftChar) throws NotFoundException {
        int[] counters = this.dataCharacterCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        counters[4] = 0;
        counters[5] = 0;
        counters[6] = 0;
        counters[7] = 0;
        if (leftChar) {
            RSSExpandedReader.recordPatternInReverse(row, pattern.getStartEnd()[0], counters);
        } else {
            RSSExpandedReader.recordPattern(row, pattern.getStartEnd()[1] + 1, counters);
            int i = 0;
            int j = counters.length - 1;
            while (i < j) {
                int temp = counters[i];
                counters[i] = counters[j];
                counters[j] = temp;
                ++i;
                --j;
            }
        }
        int numModules = 17;
        float elementWidth = (float)RSSExpandedReader.count(counters) / (float)numModules;
        int[] oddCounts = this.oddCounts;
        int[] evenCounts = this.evenCounts;
        float[] oddRoundingErrors = this.oddRoundingErrors;
        float[] evenRoundingErrors = this.evenRoundingErrors;
        int i = 0;
        while (i < counters.length) {
            float value = 1.0f * (float)counters[i] / elementWidth;
            int count = (int)(value + 0.5f);
            if (count < 1) {
                count = 1;
            } else if (count > 8) {
                count = 8;
            }
            int offset = i >> 1;
            if ((i & 1) == 0) {
                oddCounts[offset] = count;
                oddRoundingErrors[offset] = value - (float)count;
            } else {
                evenCounts[offset] = count;
                evenRoundingErrors[offset] = value - (float)count;
            }
            ++i;
        }
        this.adjustOddEvenCounts(numModules);
        int weightRowNumber = 4 * pattern.getValue() + (isOddPattern ? 0 : 2) + (leftChar ? 0 : 1) - 1;
        int oddSum = 0;
        int oddChecksumPortion = 0;
        int i2 = oddCounts.length - 1;
        while (i2 >= 0) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                int weight = WEIGHTS[weightRowNumber][2 * i2];
                oddChecksumPortion += oddCounts[i2] * weight;
            }
            oddSum += oddCounts[i2];
            --i2;
        }
        int evenChecksumPortion = 0;
        int evenSum = 0;
        int i3 = evenCounts.length - 1;
        while (i3 >= 0) {
            if (RSSExpandedReader.isNotA1left(pattern, isOddPattern, leftChar)) {
                int weight = WEIGHTS[weightRowNumber][2 * i3 + 1];
                evenChecksumPortion += evenCounts[i3] * weight;
            }
            evenSum += evenCounts[i3];
            --i3;
        }
        int checksumPortion = oddChecksumPortion + evenChecksumPortion;
        if ((oddSum & 1) != 0 || oddSum > 13 || oddSum < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int group = (13 - oddSum) / 2;
        int oddWidest = SYMBOL_WIDEST[group];
        int evenWidest = 9 - oddWidest;
        int vOdd = RSSUtils.getRSSvalue(oddCounts, oddWidest, true);
        int vEven = RSSUtils.getRSSvalue(evenCounts, evenWidest, false);
        int tEven = EVEN_TOTAL_SUBSET[group];
        int gSum = GSUM[group];
        int value = vOdd * tEven + vEven + gSum;
        return new DataCharacter(value, checksumPortion);
    }

    private static boolean isNotA1left(FinderPattern pattern, boolean isOddPattern, boolean leftChar) {
        return pattern.getValue() != 0 || !isOddPattern || !leftChar;
    }

    private void adjustOddEvenCounts(int numModules) throws NotFoundException {
        int oddSum = RSSExpandedReader.count(this.oddCounts);
        int evenSum = RSSExpandedReader.count(this.evenCounts);
        int mismatch = oddSum + evenSum - numModules;
        boolean oddParityBad = (oddSum & 1) == 1;
        boolean evenParityBad = (evenSum & 1) == 0;
        boolean incrementOdd = false;
        boolean decrementOdd = false;
        if (oddSum > 13) {
            decrementOdd = true;
        } else if (oddSum < 4) {
            incrementOdd = true;
        }
        boolean incrementEven = false;
        boolean decrementEven = false;
        if (evenSum > 13) {
            decrementEven = true;
        } else if (evenSum < 4) {
            incrementEven = true;
        }
        if (mismatch == 1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementEven = true;
            }
        } else if (mismatch == -1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementEven = true;
            }
        } else if (mismatch == 0) {
            if (oddParityBad) {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (oddSum < evenSum) {
                    incrementOdd = true;
                    decrementEven = true;
                } else {
                    decrementOdd = true;
                    incrementEven = true;
                }
            } else if (evenParityBad) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (incrementOdd) {
            if (decrementOdd) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.oddCounts, this.oddRoundingErrors);
        }
        if (decrementOdd) {
            RSSExpandedReader.decrement(this.oddCounts, this.oddRoundingErrors);
        }
        if (incrementEven) {
            if (decrementEven) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.evenCounts, this.oddRoundingErrors);
        }
        if (decrementEven) {
            RSSExpandedReader.decrement(this.evenCounts, this.evenRoundingErrors);
        }
    }
}

