/**
 * @file 常用方法、属性支持性检测
 * @import zepto.js
 * @module GMU
 */

(function($, undefined) {
    
    /**
     * 检测设备对某些属性或方法的支持情况
     * @method $.support
     * @grammar $.support.orientation ⇒ Boolean
     * @param {Boolean} orientation 检测是否支持转屏事件，UC中存在orientaion，但转屏不会触发该事件，故UC属于不支持转屏事件(iOS 4上qq, chrome都有这个现象)
     * @param {Boolean} touch 检测是否支持touch相关事件
     * @param {Boolean} cssTransitions 检测是否支持css3的transition
     * @param {Boolean} has3d 检测是否支持translate3d的硬件加速
     * @example
     * if ($.support.has3d) {      //在支持3d的设备上使用
     *     console.log('you can use transtion3d');
     * }
     */

    // TODO检测是否支持position: fixed
    function detectPosFixed () {

    }

    var br = $.browser;

    $.support = $.extend($.support || {}, {
        orientation: !(br.uc || (parseFloat($.os.version)<5 && (br.qq || br.chrome))) && !($.os.android && parseFloat($.os.version) > 3) && "orientation" in window && "onorientationchange" in window,
        touch: "ontouchend" in document,
        cssTransitions: "WebKitTransitionEvent" in window,
        has3d: 'WebKitCSSMatrix' in window && 'm11' in new WebKitCSSMatrix(),
        // fix: detectPosFixed,
        pushState: "pushState" in history && "replaceState" in history,
        scrolling: '',
        requestAnimationFrame: 'webkitRequestAnimationFrame' in window
    });

})(Zepto);