<?php
if(!defined("ROOT_PATH")){
	define("ROOT_PATH",dirname(str_replace("\\", "/", dirname(__FILE__)))."/");
}
/*
ļ
*/
if(!defined("ROOT_PATH")){
	define("ROOT_PATH","");
}
class cache
{
	public $expire=3600;
	public $cache_dir; 
	public $mem=null;
	public $cache_type="file";
	public $mysql;	
	function __construct()
	{
		$this->init();
	}
	
	public function init(){
		$this->cache_dir=ROOT_PATH."temp/filecache";
	}
 
	public function keydir($key){
		$d=md5($key);
		return "/".$d{0}."/".$d[1]."/".$d[2]."/";
	}
	public function setType($cache_type){
		$this->cache_type=$cache_type;
		return $this;
	}
	
	public function set($key,$val,$expire=3600)
	{
		 switch($this->cache_type){
			case "memcache":
					$this->mem_set($key,$val,$expire);
				break; 
			case "file":
					$this->file_set($key,$val,$expire);
					
				break;
			case "php":
					$this->php_set($key,$val,$expire);
				break;
			case "mysql":
					$this->mysql_set($key,$val,$expire);
				break;
		 }
	}
	
	public function get($key){
		 switch($this->cache_type){
			 case "memcache":
			 			return $this->mem_get($key);
					break;
			 case "file":
						return $this->file_get($key);
					break;
			 case "php":
			 			return $this->php_get($key);
			 		break;
			case "mysql":
						return $this->mysql_get($key);	
					break;
		 }
	}
	

	
	/*
	@ȡ
	*@file ļ
	*/
	public function file_get($key)
	{
		$key=preg_replace("/[^\w]/","",$key);
		$dir=$this->cache_dir.$this->keydir($key);
		
		$file=$dir.$key.".txt";
		if(file_exists($file)){
			$data=json_decode(file_get_contents($file),true);
			if($data['expire']<time()){
				return false;
			}
			return $data['data'];
			
		}else{
			return false;
		}
		 
	}
	
	/**
	*û
	*/
	public function file_set($key,$val,$expire=3600){
		$key=preg_replace("/[^\w]/","",$key);
		$dir=$this->cache_dir.$this->keydir($key);
		$file=$dir.$key.".txt";
		$this->umkdir($dir);
		$data=array("expire"=>time()+$expire,"data"=>$val);
		file_put_contents($file,json_encode($data)); 
	}
	
	/**
	*@ȡphp ֱincludeļ
	*/
	public function php_get($key)
	{
		$key=preg_replace("/[^\w]/","",$key);
		$dir=$this->cache_dir.$this->keydir($key);
		$file=$dir.$key.".php";
		if(file_exists($file)){
			@include($file);
			return $$key;
		}else{
			return false;
		}

	}
	 
	
	 
	/**
	*@дphp һû Ч
	*/
	public function php_set($key,$val,$expire=3600)
	{
		$key=preg_replace("/[^\w]/","",$key);
		$dir=$this->cache_dir.$this->keydir($key);
		$file=$dir.$key.".php";
		$content='<?php'." \r\n".'$'.$key.'='.var_export($val,true).";\r\n?>";
		file_put_contents($file,$content);
	}
	
	
	/*
	*mem
	*/
	
	public function mem_connect($memcache_host,$memcache_port){
		$this->mem = new Memcache;
		$this->mem->connect($memcache_host,$memcache_port,$this->expire);
	}
	
	public function mem_set($k,$v,$expire=0){
		$key=preg_replace("/[^\w]/","",$key);
		$this->mem->set($k,$v,0,$expire);
	}
	
	public function mem_get($k){
		$key=preg_replace("/[^\w]/","",$key);
		return $this->mem->get($k);
	}
	
	/**
	*mysql 
	*/
	
	public function mysql($my){
		$this->mysql=$my;
		$this->db=mysql_connect($my['host'],$my['user'],$my['password']);
		mysql_query("SET NAMES UTF8",$this->db);
		mysql_select_db($my['database'],$this->db);
	}
		
	public function mysql_set($k,$v,$expire=3600){
		$key=preg_replace("/[^\w]/","",$key);
		$k=trim($k);
		$sql="select * from ".$this->mysql['table']." WHERE k='$k' limit 1 ";
		$res=mysql_query($sql,$this->db);
		
		$row=mysql_fetch_array($res);
		if(!empty($row)){
			mysql_query("update ".$this->mysql['table']." SET k='$k',v='".addslashes(json_encode($v))."',expire=".(time()+3600)." WHERE id=".$row['id']." ",$this->db);
		}else{
			 
			mysql_query("insert into ".$this->mysql['table']." SET k='$k',v='".addslashes(json_encode($v))."',expire=".(time()+3600)." ",$this->db);
		}
	}
	
	public function mysql_get($k){
		$key=preg_replace("/[^\w]/","",$key);
		$k=trim($k);
		$sql="select * from ".$this->mysql['table']." WHERE k='$k' limit 1 ";
		$res=mysql_query($sql,$this->db);
		while($row=mysql_fetch_array($res)){
			if($row['expire']<time()){
				return false;
			}else{
				return json_decode($row['v'],true);
			}
		}
		return false;
	}
	
	
	/**
	@ɾĿ¼
	*/
	public function clear($type=0)
	{
		$this->delFile($this->cache_dir,$type);
	}
	
	/**
	@ɾĿ¼µļ ǰĿ¼
	*/
	function delfile($dir,$rmdir=0)
	{
		$hd=opendir($dir);
		while(($f=readdir($hd))!==false)
		{
			if($f!=".." and $f!=".")
			{
				if(is_file($dir."/".$f)){
					unlink($dir."/".$f);
				}else
				{
					self::delfile($dir."/".$f."/",$rmdir);
				}
			}
		}
		
		closedir($hd);
		if($rmdir)
		{
			rmdir($dir);
		}
	}
	
	
	/*ļ*/
	function umkdir($dir)
	{
		$dir=str_replace(ROOT_PATH,"",$dir);
		$arr=explode("/",$dir);
		foreach($arr as $key=>$val)
		{			
			$d="";
			for($i=0;$i<=$key;$i++)
			{
				$d.=$arr[$i]."/";
			}
			if(!file_exists(ROOT_PATH.$d))
			{ 
				mkdir(ROOT_PATH.$d,0755);
			} 
		}
		
	}

	

		
}

?>