<?php
class model{
	public $base;
	public $db;
	public $table;
	public $table_all=NULL;
	public $tmpTable=false;  
	function __construct(&$base)
	{
		$this->base=$base;
		$this->db=$base->db;		
	}
	
	public function setDb($config){
		$db=new mysql();
		$db->dbconfig=$config; 
		$db->connect();
		$this->db=$db;
		$this->db->base=$this->base;
	}
	
	public function setTable($table,$object_id=0,$table_num=10){
		if($object_id){
			$this->tmpTable=$this->table."_".($object_id%$table_num);
		}else{
			$this->tmpTable=$table;
		}
		return $this;
	}
	public function clearTable(){
		$this->tmpTable=false;
	}
	/*加载模型*/
	public function loadModel($model,$base=NULL){
		$this->base->loadModel($model,$base);
		if(is_array($model)){
			foreach($model as $m){
				$this->$m=$this->base->$m;
			}
		}else{
			$this->model=$this->base->$model;
		}
	}
	/**
	*执行sql语句
	*/
	public function query($sql){
		 
		return $this->db->query($sql);
	}
	
	/**
	 * 将结果集解析成数组
	 */
	public function fetch_array($res,$result_type=MYSQL_ASSOC){
		return $this->db->fetch_array($res,$result_type);	
	}
	
	/**
	 * 从结果集中取一行
	 */
	public function fetch_row($res){
		return $this->db->fetch_row($res);	
	}
	
	/**
	*获取全部数据
	*/
	public function getAll($sql,$cache=0,$expire=60){
		return $this->db->getAll($sql,$cache,$expire);
	}
	/**
	*获取一个字段数据
	*/
	public function getOne($sql,$cache=0,$expire=60){
		return $this->db->getOne($sql,$cache,$expire);
	}
	/**
	*获取一列数据
	*/
	public function getCols($sql,$cache=0,$expire=60){
		return $this->db->getCOls($sql,$cache,$expire);
	}
	/**
	*获取一行数据
	*/
	public function getRow($sql,$cache=0,$expire=60){
		return $this->db->getRow($sql,$cache,$expire);
	}
	/**
	*获取全部数据
	* data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function select($option=array(),&$rscount=false,$cache=0,$expire=60){
		$data=$this->db->select($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$option,$rscount,$cache,$expire);
		$this->clearTable();
		return $data;
	}
	/**
	*获取一个字段
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectOne($data=array(),$cache=0,$expire=60){
		$data=$this->db->selectOne($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$data,$cache,$expire);
		$this->clearTable();
		return $data;
	}
	/**
	*获取一行信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectRow($data=array(),$cache=0,$expire=60){
		$data=$this->db->selectRow($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$data,$cache,$expire);
		$this->clearTable();
		return $data;
	}
	/**
	*获取一列信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectCols($data=array(),&$rscount=false,$cache=0,$expire=60){
		$data=$this->db->selectCols($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$data,$rscount,$cache,$expire);
		$this->clearTable();
		return $data;
	}
	/*
	*获取记录总数
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function getCount($w=array(),$cache=0,$expire=60){
		$data=$this->db->getCount($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$w,$cache,$expire);
		$this->clearTable();
		return $data;
	}
	/**
	*插入数据
	*data array("title"=>'aaa');
	*/
	public function insert($data){
		$data=$this->db->insert($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$data);
		$this->clearTable();
		return $data;
	}
	/**
	*更新数据
	*data array("title"=>'aaa');
	*where array("id"=>1)
	*/
	public function update($data,$where=""){
		$data=$this->db->update($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$data,$where);
		$this->clearTable();
		return $data;
	}
	/**
	/*修改数字类型
	*/
	public function changenum($fields,$num,$w){
		$data=$this->db->query("UPDATE ".TABLE_PRE.($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table))." SET $fields=$fields+{$num} WHERE $w ");
		$this->clearTable();
		return $data;
	}
	/**
	*删除数据
	*where array("id"=>1)
	*/
	public function delete($where=""){
		$data=$this->db->delete($this->tmpTable?$this->tmpTable:($this->table_all?$this->table_all:$this->table),$where);
		$this->clearTable();
		return $data;
	}
	/*最近插入的id*/
	public function insert_id(){
		return $this->db->insert_id();
	}
	/*关闭数据库*/
	public function close(){
		$this->db->close();
	}
	
	
	
}
