<?php
class model_more{
	public $base;
	public $db;
	public $table;
	public $table_num=10;
	public $tmpTable; 
	function __construct(&$base)
	{
		$this->base=$base;
		$this->db=$base->db;
		
	}
	public function setDb($config){
		$db=new mysql();
		$db->dbconfig=$config; 
		$db->connect();
		$this->db=$db;
		$this->db->base=$this->base;
	}
	
	public function setTable($object_id){
		$this->tmpTable=$this->table."_".($object_id%$this->table_num);
	}
	
	/*加载模型*/
	public function loadModel($model,$base=NULL){
		$this->base->loadModel($model,$base);
		if(is_array($model)){
			foreach($model as $m){
				$this->$m=$this->base->$m;
			}
		}else{
			$this->model=$this->base->$model;
		}
	}
	/**
	*执行sql语句
	*/
	public function query($sql){
		 
		return $this->db->query($sql);
	}
	
	/**
	 * 将结果集解析成数组
	 */
	public function fetch_array($res,$result_type=MYSQL_ASSOC){
		return $this->db->fetch_array($res,$result_type);	
	}
	
	/**
	 * 从结果集中取一行
	 */
	public function fetch_row($res){
		return $this->db->fetch_row($res);	
	}
	
	/**
	*获取全部数据
	*/
	public function getAll($sql,$cache=0,$expire=60){
		return $this->db->getAll($sql,$cache,$expire);
	}
	/**
	*获取一个字段数据
	*/
	public function getOne($sql,$cache=0,$expire=60){
		return $this->db->getOne($sql,$cache,$expire);
	}
	/**
	*获取一列数据
	*/
	public function getCols($sql,$cache=0,$expire=60){
		return $this->db->getCOls($sql,$cache,$expire);
	}
	/**
	*获取一行数据
	*/
	public function getRow($sql,$cache=0,$expire=60){
		return $this->db->getRow($sql,$cache,$expire);
	}
	/**
	*获取全部数据
	* data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function select($object_id,$option=array(),&$rscount=false,$cache=0,$expire=60){
		$this->setTable($object_id);
		return $this->db->select($this->tmpTable,$option,$rscount,$cache,$expire);
	}
	/**
	*获取一个字段
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectOne($object_id,$data=array(),$cache=0,$expire=60){
		$this->setTable($object_id);
		return $this->db->selectOne($this->tmpTable,$data,$cache,$expire);
	}
	/**
	*获取一行信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectRow($object_id,$data=array(),$cache=0,$expire=60){
		$this->setTable($object_id);
		return $this->db->selectRow($this->tmpTable,$data,$cache,$expire);
	}
	/**
	*获取一列信息
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function selectCols($object_id,$data=array(),&$rscount=false,$cache=0,$expire=60){
		$this->setTable($object_id);
		return $this->db->selectCols($this->tmpTable,$data,$rscount,$cache,$expire);
	}
	/*
	*获取记录总数
	*data array("table","where"=>array(),"order","start","pagesize","fields")
	*/
	public function getCount($object_id,$w=array(),$cache=0,$expire=60){
		$this->setTable($object_id);
		return $this->db->getCount($this->tmpTable,$w,$cache,$expire);
	}
	/**
	*插入数据
	*data array("title"=>'aaa');
	*/
	public function insert($object_id,$data){
		$this->setTable($object_id);
		return $this->db->insert($this->tmpTable,$data);
	}
	/**
	*更新数据
	*data array("title"=>'aaa');
	*where array("id"=>1)
	*/
	public function update($object_id,$data,$where=""){
		$this->setTable($object_id);
		return $this->db->update($this->tmpTable,$data,$where);
	}
	/**
	/*修改数字类型
	*/
	public function changenum($object_id,$fields,$num,$w){
		$this->setTable($object_id);
		$this->db->query("UPDATE ".TABLE_PRE."{$this->tmpTable} SET $fields=$fields+{$num} WHERE $w ");
	}
	/**
	*删除数据
	*where array("id"=>1)
	*/
	public function delete($object_id,$where=""){
		$this->setTable($object_id);
		return $this->db->delete($this->tmpTable,$where);
	}
	
	public function insert_id(){
		return $this->db->insert_id();
	}
	
	/*关闭数据库*/
	public function close(){
		$this->db->close();
	}
	
	
}
