<?php
//格式化时间 多久前的
function timeago($dateline)
{
	$t=time()-$dateline;
	if($t<60)
	{
		return $t."秒前";
	}elseif($t<3600)
	{
		return ceil($t/60)."分前";
	}elseif($t<7200)
	{
		return "1小时".ceil(($t-3600)/60)."分前";
	}elseif($t<86400)//一天
	{
		return ceil($t/3600)."小时前";
	}elseif($t<604800)//一周
	{
		return ceil($t/86400)."天前";
	}else
	{
		return date("Y年m月d日",$dateline);
	}
}


/*计算开业时间函数*/
function opentype($starthour,$startminute,$endhour,$endminute)
{
	$opentype='doing';
	$h=intval(date("H"));
	$m=intval(date("i"));
	if($starthour>$endhour)
	{
		if(($endhour<$h && $starthour>$h) or (($endhour==$h && $endminute<$m) && ($starthour==$h && $startminute>$m)))
		{
			if(($starthour-$h)>(($starthour-$endhour)/2))
			{
				$opentype='done';
			}else
			{
				
				$opentype='will';
			}
		}elseif($endhour)
		{
			$opentype='doing';
		}
		
	}else
	{
		if($h<$starthour or ($h==$starthour && $m<$startminute))
		{
			$opentype='will';//未开时
		}elseif($h>$endhour or($h==$endhour && $m>$endminute))
		{
			$opentype='done';//一结束
		}else
		{
			$opentype='doing';
		}
	}
	return $opentype;
}


//星期几
function getweek($w="")
{
	if(date("N"))
	{
		return $w.date("N");
	}
	if(date("w")==0)
	{
		return $w."7";
	}else
	{
		return $w.intval(date("w"));
	}
}

function week_list($week=0){
	$data=array(
		'week1'=>'星期一',
		'week2'=>'星期二',
		'week3'=>'星期三',
		'week4'=>'星期四',
		'week5'=>'星期五',
		'week6'=>'星期六',
		'week7'=>'星期日',
	);
	if($week){
		return $data[$week];
	}else{
		return $data;
	}
}

?>