<?php
	if(!defined("ROOT_PATH")) exit("die Access ");
	class admin_adControl extends skymvc{
		
		public function __construct(){
			parent::__construct();
			$this->loadmodel(array("ad","ad_tags"));
		}
		
		public function onDefault(){
			$where="";
			$url="/index.php?m=admin_ad&a=default";
			$limit=20;
			$start=get("per_page","i");
			$option=array(
				"start"=>intval(get_post('per_page')),
				"limit"=>$limit,
				"order"=>" id DESC",
				"where"=>$where
			);
			$rscount=true;
			$data=$this->ad->select($option,$rscount);
			$pagelist=$this->pagelist($rscount,$limit,$url);
			$this->smarty->assign(
				array(
					"data"=>$data,
					"pagelist"=>$pagelist,
					"rscount"=>$rscount,
					"url"=>$url,
					"tag_list"=>$this->ad_tags->tagList(),
				)
			);
			$this->smarty->display("ad/index.html");
		}
		
		public function onAdd(){
			$id=get_post("id","i");
			if($id){
				$data=$this->ad->selectRow(array("where"=>"id={$id}"));
				$tag=$this->ad_tags->selectRow(array("where"=>"tag_id=".$data['tag_id'].""));
				$tag_2nd=$this->ad_tags->selectRow(array("where"=>"tag_id=".$data['tag_id_2nd'].""));
				$this->smarty->assign("tag_list_2nd",$this->ad_tags->tagList($data['tag_id'],0));
			}
			$this->smarty->assign(array(
				"data"=>$data,
				"tag_list"=>$this->ad_tags->tagList(0,0),
				"tag"=>$tag,
				"tag_2nd"=>$tag_2nd
			));
			$this->smarty->display("ad/add.html");
		}
		
		public function onSave(){
			
			$id=get_post("id","i");
			$data["tag_id"]=post("tag_id","i");
			 
			$data['tag_id_2nd']=post('tag_id_2nd','i');	
			 
			$data["title"]=post("title","h");
			$data["info"]=post("info","h");
			$data["link1"]=post("link1","h");
			$data["link2"]=post("link2","h");
			$data["starttime"]=strtotime(post("starttime"));
			$data["endtime"]=strtotime(post("endtime"));
			$data["imgurl"]=post("imgurl","h");
			$data["orderindex"]=post("orderindex","i");
			$data["status"]=post("status","i");
			$data["dateline"]=time();
			$data["price"]=post("price","r",2);
			$data["object_id"]=post("object_id","i");

			if($id){
				$this->ad->update($data,"id='$id'");
			}else{
				$this->ad->insert($data);
			}
			$this->gomsg("保存成功");
		}
		
		public function onStatus(){
			$id=get_post('id',"i");
			$status=get_post("status","i");
			$this->ad->update(array("status"=>$status),"id=$id");
			exit(json_encode(array("error"=>0,"message"=>"状态修改成功")));
		}
		
		public function onDelete(){
			$id=get_post('id',"i");
			$this->ad->delete("id={$id}");
			exit(json_encode(array("error"=>0,"message"=>"删除成功")));
		}
		
		
	}

?>