<?php
	if(!defined("ROOT_PATH")) exit("die Access ");
	class admin_bugControl extends skymvc{
		
		public function __construct(){
			parent::__construct();
			$this->loadmodel(array("bugs"));
		}
		
		public function onDefault(){
			$where="";
			$url="/index.php?m=admin_bug&a=default";
			$limit=20;
			$start=get("per_page","i");
			$option=array(
				"start"=>intval(get_post('per_page')),
				"limit"=>$limit,
				"order"=>" id DESC",
				"where"=>$where
			);
			$rscount=true;
			$data=$this->bugs->select($option,$rscount);
			$pagelist=$this->pagelist($rscount,$limit,$url);
			$this->smarty->assign(
				array(
					"data"=>$data,
					"pagelist"=>$pagelist,
					"rscount"=>$rscount,
					"url"=>$url
				)
			);
			 
			$this->smarty->display("bug/index.html");
		}
		
		public function onShow(){
			$id=get_post("id","i");
			if($plan_id){
				$data=$this->bugs->selectRow("id={$id}");
				
			}
			$this->smarty->assign(array(
				"data"=>$data
			));
			$this->smarty->display("bug/add.html");
		}
		public function onAdd(){
			$id=get_post("id","i");
			if($plan_id){
				$data=$this->bugs->selectRow("id={$id}");
				
			}
			$this->smarty->assign(array(
				"data"=>$data
			));
			$this->smarty->display("bug/add.html");
		}
		
		public function onSave(){
			
			$id=intval(get_post("id"));
			$data["title"]=htmlspecialchars(trim(get_post("title")));
			$data["content"]=htmlspecialchars(trim(get_post("content")));
			
			$data["status"]=intval(get_post("status"));

			if($id){
				$this->bugs->update($data,"id='id'");
			}else{
				$data["dateline"]=time();
				$this->bugs->insert($data);
			}
			$this->gomsg("保存成功");
		}
		
		public function onDelete(){
			$id=get_post('id',"i");
			$this->bugs->delete("id={$id}");
			exit(json_encode(array("error"=>0,"message"=>"删除成功")));
		}
		
		
	}

?>