<?php
class admin_categoryControl extends skymvc{
	private $type_list;
	public function __construct(){
		parent::__construct();
		if(empty($_SESSION['ssadmin'])){
			$this->gourl("".APPADMIN."?m=admin&a=login");	
		}
		$this->loadModel(array("category","attribute_cat"));
		$this->loadConfig("table");
		$this->type_list=	$this->config_item("category_type_list");
	}
	
	public function onDefault(){
		$data=$this->category->select(array("where"=>array("pid"=>0),"order"=>"status desc,orderindex asc"));
		if(!empty($data)){
			foreach($data as $k=>$v){
				$child=$this->category->select(array("where"=>array("pid"=>$v['id']),"order"=>"status desc,orderindex asc"));
				if(!empty($child)){
					foreach($child as $kk=>$vv){
						$child2=$this->category->select(array("where"=>array("pid"=>$vv['id']),"order"=>"status desc,orderindex asc"));
						$child[$kk]['child']=$child2;
					}
				}
				$data[$k]['child']=$child;
			}
		}
		$this->smarty->assign(
			array(
				"data"=>$data,
				"type_list"=>$this->type_list
			)
		);
		$this->smarty->display("category/category.html");
	}
	
	public function onAdd(){
		$id=intval(get('id'));
								
		if($id){
			$data=$this->category->selectRow(array("where"=>"id=$id"));
			if($data['level']>2){
				$parent_2nd=$this->category->selectRow(array("where"=>"id=".$data['pid']));  
				$cat_2nd_list=$this->category->select(array("where"=>array("pid"=>$parent_2nd['pid']),"order"=>"orderindex asc"));
				
				$this->smarty->assign(array(
					"cat_2nd_list"=>$cat_2nd_list,
					"parent_2nd_id"=>$parent_2nd['id'],
					"parent_id"=>$parent_2nd['pid']
				));
			}else{
				$this->smarty->assign(array(
					"parent_id"=>$data['pid']
				));
			}
			$this->smarty->assign(array(
				"data"=>$data,
				
			));
		}		
		$cat_list=$this->category->select(array("where"=>array("pid"=>0),"order"=>"orderindex asc"));
		$this->smarty->assign(
			array(
				"cat_list"=>$cat_list,
				"type_list"=>$this->type_list,
				"attr_cat"=>$this->attribute_cat->attr_cat(),
			)
		);
		$this->smarty->display("category/category_add.html");
	}
	
	public function onSave(){
		$data['cname']=htmlspecialchars(trim(post('cname')));
		$data['title']=htmlspecialchars(trim(post('title')));
		$data['keywords']=trim(post('title'));
		$data['description']=trim(post('description'));
		$data['othername']=trim(post('othername'));
		$data['is_cat']=post('is_cat','i');
		$data['is_tag']=post('is_tag','i');
		$data['is_stole']=post('is_stole','i');
		$data['pid']=0;
		$data['type_id']=post('type_id','i');
		$data['attr_cat_id']=post('attr_cat_id','i');
		$pids=$_POST['pid'];
		krsort($pids);
		foreach($pids as $pid){
			if($pid){
				$data['pid']=$pid;
				break; 
			}
		}
		
		if($data['pid']){
			$parent=$this->category->selectRow(array("where"=>" id=".$data['pid'] ));
			$data['level']=$parent['level']+1;
		}else{
			$data['level']=1;
		}
		$data['listtpl']=post('listtpl','h');
		$data['showtpl']=post('showtpl','h');
		$data['pagesize']=post('pagesize','i');
		$id=intval(get_post('id'));
		$data['orderindex']=post('orderindex','i');
		$data['user_add']=post('user_add','i');
		$data['tags']=post('tags','h');
		$data['link_url']=post('link_url','h');
		if($id){
			$this->category->update($data,"  id='$id' ");
		}else{
			$this->category->insert($data);
		}
		$this->Onlevel(0);
		$this->gomsg("保存成功");
	}
	
	public function onDelete(){
		$id=intval(get('id'));
		if($id<20){
			exit(json_encode(array("error"=>1,"message"=>"该分类不能删除"))); 
		}
		$this->category->delete("id=$id ");
		//$this->gomsg("删除成功");
		exit(json_encode(array("error"=>0,"message"=>"删除成功"))); 
	}
	
	public function onChange(){
		$id=intval(get('id'));
		if(isset($_GET['status'])){
			$data['status']=intval(get('status'));
		}
		if(isset($_GET['user_add'])){
			$data['user_add']=get('user_add','i');
		}
		if(isset($_GET['is_stole'])){
			$data['is_stole']=get('is_stole','i');
		}
		
		if(isset($_GET['is_tag'])){
			$data['is_tag']=get('is_tag','i');
		}
		
		$this->category->update($data,"id=$id");
		$this->gomsg("修改成功");
	}
	
	public function onSort(){
		$orderindexs=$_POST['orderindex'];
		foreach($orderindexs as $id=>$orderindex){
			$this->category->update(array("orderindex"=>intval($orderindex)),"id=".intval($id));
		}
		$this->gomsg("修改成功");
	}
	
	/*重新生成分类*/
	public function Onlevel($e=1){
		/*-------------修复level-------------------*/
		$cat_list=$this->category->select(array("where"=>"pid=0"));
		if($cat_list){
			foreach($cat_list as $k=>$v){
				//修改成level 1
				$this->category->update(array("level"=>1),"id=".$v['id']);
				$cat_list_2nd=$this->category->select(array("where"=>"pid=".$v['id']));
				if($cat_list_2nd){
					foreach($cat_list_2nd as $kk=>$vv){
						//level 改成2
						$this->category->update(array("level"=>2),"id=".$vv['id']);
						$cat_list_3nd=$this->category->select(array("where"=>"pid=".$vv['id']));
						if($cat_list_3nd){
							foreach($cat_list_3nd as $kkk=>$vvv){
								$this->category->update(array("level"=>3),"id=".$vvv['id']);
							}
						}
					}
					
				}
			}
		}
		/*-----------------------生成上下级关系-----------------------------*/
		$data=$this->category->select(array("fields"=>"id,pid"));
		foreach($data as $k=>$v){
			$ids[]=$v['id'];
			$pids[]=$v['pid'];
		}
		array_multisort($pids,SORT_DESC,$ids,SORT_DESC,$data);
		$c=array();
		foreach($data as $k=>$v){
			$c[$v['id']][]=$v['id'];
			if($v['pid']){
				if(isset($c[$v['pid']])){
					$c[$v['pid']]=array_merge($c[$v['pid']],$c[$v['id']]);
				}else{
					$c[$v['pid']]=$c[$v['id']];
				}
			}
		}
		$str="<?php\r\n";
		foreach($c as $k=>$v){
			$str.='$config["category_children"]['.$k.']=array('.implode(",",$v).');'."\r\n"; 
		}
		file_put_contents("config/c_category_children.php",$str);
		if($e){
			$this->gomsg("修复完毕","/admin.php?m=admin_category");
		}
	}
	
	
}
?>