<?php
class admin_linksControl extends skymvc{
	
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("links"));
	}
	
	public function onDefault(){
		$data=$this->links->select();
		$this->smarty->assign(array(
			"data"=>$data
		));
		$this->smarty->display("links/index.html");	
	}
	
	public function onAdd(){
		$id=get_post("id","i");
		if($id){
			$data=$this->links->selectRow(array("where"=>"id=$id"));
		}
		$this->smarty->assign(
			array(
				"data"=>$data
			)
		);
		$this->smarty->display("links/add.html");	
	}
	
	public function onSave(){
		$id=get_post("id","i");
		$data["title"]=get_post("title","h");
		
		$data["status"]=get_post("status","i");
		$data["url"]=get_post("url","h");
		if($id){
			$this->links->update($data,array('id'=>$id));
		}else{
			$data["dateline"]=time();
			$this->links->insert($data);
		}
		$this->gomsg($this->lang["save_success"]);
	}
	
	public function onDelete(){
		$id=get_post("id","i");
		$this->links->delete("id=$id");
		$this->gomsg($this->lang['delete_success']);
	}
	
	public function onStatus(){
		$id=get_post("id","i");
		$status=get_post('status','i');
		$this->links->update(array("status"=>$status),"id=$id");
	}
	
	
}
?>