<?php
class admin_mainControl extends skymvc{
	
	function __construct(){
		parent::__construct();
		if(empty($_SESSION['ssadmin'])){
				$this->gourl("".APPADMIN."?m=admin&a=login");	
		}
		$this->loadConfig("version");
	}
	
	public function onDefault(){
		
		$this->loadModel(array("user","product"));
		$user_num=$this->user->SelectOne(array("fields"=>"count(*) as c"));
		$product_num=$this->product->SelectOne(array("fields"=>"count(*) as c"));
		$product_0_num=$this->product->SelectOne(array("fields"=>"count(*) as c","where"=>"status=0"));
		$product_1_num=$this->product->SelectOne(array("fields"=>"count(*) as c","where"=>"status=1"));
		$product_2_num=$this->product->SelectOne(array("fields"=>"count(*) as c","where"=>"status=2"));
		$this->smarty->assign(
			array(
				"user_num"=>$user_num,
				"product_num"=>$product_num,
				"product_0_num"=>$product_0_num,
				"product_1_num"=>$product_1_num,
				"product_2_num"=>$product_2_num,
			)
		);
		$this->smarty->display("main.html");
	}
	
	
	
	public function onCheckNewVersion(){
		$data=file_get_contents(CHECKVERSION);
		if($data>VERSION_NUM){
			echo "最新版本为".$data."，<a href='javascript:;' id='update_submit' class='btn btn-warning'>在线更新</a>。";
		}else{
			echo "目前已经是最新版本了。";
		}
	}
	
	public function onShouQuan(){
		$data=file_get_contents(CHECKSHOUQUAN."&domain=".$_SERVER['HTTP_HOST']);
		echo $data;
	}
	
	public function onUpdate(){
		set_time_limit(10000);
		$v=file_get_contents(ONLINEUPDATE."version.php");
		$v=unserialize($v);
		asort($v);
		$now=VERSION_NUM;
		foreach($v as $d){
			if($d>$now){
				$this->updateNow($d);
				$now=$d;
			}
		}
		exit(json_encode(array("error"=>0,"message"=>"success")));
		break;
	}
	
	
	function updateNow($d){
		
		file_put_contents(ROOT_PATH."update/update.zip",file_get_contents(ONLINEUPDATE."zip/{$d}/{$d}.zip"));
		$this->loadClass("pclzip",false,false);
		$zip = new pclzip(ROOT_PATH."update/update.zip");
		$zip->extract(ROOT_PATH."update");
		file_get_contents("http://".$_SERVER['HTTP_HOST']."/update/index.php?a=update");
		delfile(ROOT_PATH."update");
		return true;
	}
}
?>