<?php
class admin_navbarControl extends skymvc{
	public $siteid;
	function __construct(){
		parent::__construct();
		$this->loadModel(array('navbar'));		 
	}

	
	public function onDefault(){
		$rscount=true;
		$where['pid']=0;
		$group_id=get_post('group_id','i');
		$group_id=$group_id?$group_id:4;
 
		$where['group_id']=$group_id;
		$option=array(
			"where"=>$where,
			"order"=>" orderindex ASC",
		);
		$data=$this->navbar->select($option,$rscount);
		if($data){
			foreach($data as $k=>$v){
				$v['child']=$this->navbar->select(array("where"=>array("pid"=>$v['id']),"order"=>" orderindex ASC"));
				$data[$k]=$v;
			}
		}
		$this->smarty->assign(
			array(
				"navlist"=>$data,
				"rscount"=>$rscount,
				"group_list"=>$this->navbar->getGroup(),
			)
		);
		$this->smarty->display("navbar/index.html");
	}
	
	public function onAdd(){
		$id=get_post('id','i');
		$pid=get_post('pid','i');
		if($id){
			$data=$this->navbar->selectRow(array("where"=>array("id"=>$id)));
			$pid=$data['pid'];
		}
		if($pid){
			$parent=$this->navbar->selectRow(array("where"=>array("id"=>$pid)));
		}
		$this->smarty->assign(
			array(
				"nav"=>$data,
				"group_list"=>$this->navbar->getGroup(),
				"parent"=>$parent,
			)
		);
		$this->smarty->display("navbar/add.html");
	}
	
	public function onSave(){
		$id=get_post('id','i');
		$data['pid']=$pid=post('pid','i');
		if($pid){
			$parent=$this->navbar->selectRow(array("where"=>array("id"=>$pid)));
			$data['group_id']=$parent['group_id'];
		}else{
			$data['group_id']=post('group_id');
		}
		$data['title']=post('title','h');
		$data['orderindex']=post('orderindex');
		$data['link_url']=post('link_url','h');
		$data['target']=post('target','h');
		$data['m']=post('m','h');
		$data['a']=post('a','h');
		$data['status']=max(1,post('status','i'));
		if($id){
			$this->navbar->update($data,array("id"=>$id));
		}else{
			$this->navbar->insert($data);
		}
		$this->gomsg($this->lang['edit_success']);
	}
	
	public function onDelete(){
		$id=get_post('id','i');
		$data=$this->navbar->selectRow(array("where"=>array("pid"=>$id)));
		if($data){
			exit(array("error"=>1,"message"=>$this->lang['delete_wrong_child']));
		} 
		$this->navbar->delete(array("id"=>$id));
		exit(json_encode(array("error"=>0,"message"=>$this->lang['delete_success'])));
	}
	
	public function onStatus(){
		$id=get('id','i');
		$status=max(1,get('status'));
		$this->navbar->update(array("status"=>$status),"id=$id");
		exit(json_encode(array("error"=>0,"message"=>$this->lang['save_success'])));
	}
	
	public function onOrder(){
		$ids=post('id','i');
		$orderindexs=post('orderindex','i');
		foreach($ids as $k=>$id){
			$this->navbar->update(array("orderindex"=>intval($orderindexs[$k])),array("id"=>intval($id)));
		}
		$this->gourl();
	}
	
}
?>