<?php
	if(!defined("ROOT_PATH")) exit("die Access ");
	class admin_shopControl extends skymvc{
		
		public function __construct(){
			parent::__construct();
			$this->loadmodel(array("shop","site_city"));
		}
		
		public function onDefault(){
			$where=" 1 ";
			$url=APPADMIN."?m=admin_shop&a=default";
			$order=" shopid DESC";
			$limit=20;
			$start=get("per_page","i");
			$orderby=get('orderby','i');
			if($orderby){
				switch($orderby){
					case 1:
							$order="rank DESC";
						break;
					case 2:
							$order="sold_num DESC";
						break;
					case 3:
							$order="goodsgrade DESC";
						break;	
				}
				 
				$url.="&orderby=".urlencode($orderby);
			}
			
			$shopname=get('shopname','h');
			if($shopname){
				$where.=" AND shopname='".$shopname."' ";
				$url.="&shopname=".urlencode($shopname);
			}
			
			$nickname=get('nickname','h');
			if($nickname){
				$where.=" AND nickname='".$nickname."' ";
				$url.="&nickname=".urlencode($nickname);
			}
			$is_invite=get('is_invite','i');
			if($is_invite){
				$where.=" AND is_invite=".$is_invite;
				$url.="&is_invite=".$is_invite;
			}
			$option=array(
				"start"=>intval(get_post('per_page')),
				"limit"=>$limit,
				"order"=>$order,
				"where"=>$where
			);
			$rscount=true;
			$data=$this->shop->select($option,$rscount);
			$pagelist=$this->pagelist($rscount,$limit,$url);
			$this->smarty->assign(
				array(
					"data"=>$data,
					"pagelist"=>$pagelist,
					"rscount"=>$rscount,
					"url"=>$url,
					"is_invite_list"=>$this->shop->is_invite(),
				)
			);
			$this->smarty->display("shop/index.html");
		}
		
		public function onShow(){
			$shopid=get_post("shopid","i");
			if($shopid){
				$data=$this->shop->selectRow(array("where"=>"shopid={$shopid}"));
				
			}
			$this->smarty->assign(array(
				"data"=>$data,
				"is_invite_list"=>$this->shop->is_invite(),
			));
			$this->smarty->display("shop/show.html");
		}
		public function onAdd(){
			$shopid=get_post("shopid","i");
			if($shopid){
				$data=$this->shop->selectRow(array("where"=>"shopid={$shopid}"));
				if($data['sc_id']){
					$t_3=$this->site_city->selectRow(array("where"=>" sc_id=".$data['sc_id']));
					if($t_3['pid']){
						$t_2=$this->site_city->selectRow(array("where"=>" sc_id=".$t_3['pid']));
						
						if($t_2['pid']){
							$t_1=$this->site_city->selectRow(array("where"=>" sc_id=".$t_2['pid']));
							$sc_2nd_list=$this->site_city->select(array("where"=>" pid=".$t_2['pid']));							
							$sc_3nd_list=$this->site_city->select(array("where"=>" pid=".$t_2['sc_id']));
							$sc_top_id=$t_1['sc_id'];
							$sc_2nd_id=$t_2['sc_id'];
							$sc_3nd_id=$t_3['sc_id'];
						}else{
							$sc_2nd_list=$this->site_city->select(array("where"=>" pid=".$t_2['pid']));
							$sc_top_id=$t_2['sc_id'];
							$sc_2nd_id=$t_3['sc_id'];
						}
					}else{
						$sc_top_id=$t_1['sc_id'];
					}
				}
			}
			$sc_top_list=$this->site_city->select(array("where"=>"pid=0"));
			$this->smarty->assign(array(
				"data"=>$data,
				"is_invite_list"=>$this->shop->is_invite(),
				"sc_top_list"=>$sc_top_list,
				"sc_2nd_list"=>$sc_2nd_list,
				"sc_3nd_list"=>$sc_3nd_list,
				"sc_top_id"=>$sc_top_id,
				"sc_2nd_id"=>$sc_2nd_id,
				"sc_3nd_id"=>$sc_3nd_id,
			));
			$this->smarty->display("shop/add.html");
		}
		
		public function onSave(){
			
			$shopid=get_post("shopid","i");
			$data["userid"]=post("userid","i");
			$data["word"]=post("word","h");
			$data["shopname"]=post("shopname","h");
			$data["shopurl"]=post("shopurl","h");
			$data["shop_uid"]=post("shop_uid","i");
			$data["nickname"]=post("nickname","h");
			$data["goods_num"]=post("goods_num","i");
			$data["sold_num"]=post("sold_num","i");
			$data["rank"]=post("rank","i");
			$data["ismall"]=post("ismall","i");
			$data["goodsgrade"]=post("goodsgrade","r",2);
			
			$data["last_time"]=time();
			$data["logo"]=post("logo","h");
			$data["is_invite"]=post("is_invite","i");
			//gps信息
			if(post('latlng')){
				$latlng=explode(",",post('latlng'));
				$data['lat']=$latlng[0];
				$data['lng']=$latlng[1];
			}
			$data["status"]=get_post("status","i");
			$data["info"]=get_post("info","h");
			$data["telephone"]=get_post("telephone","h");
			$data["sc_id"]=array_lastnum(get_post("sc_id","i"));
			$data["address"]=get_post("address","h");
			$data["fav_num"]=get_post("fav_num","i");
			$data["grade"]=get_post("grade","i");
			$data["send_time"]=get_post("send_time","i");
			$data["send_startprice"]=round(get_post("send_startprice"),1);
			$data["send_info"]=get_post("send_info","h");
			$data["open_time"]=get_post("open_time","h");
			$data["tags"]=get_post("tags","h");
			if($shopid){
				
				$this->shop->update($data,"shopid='$shopid'");
			}else{
				$data["dateline"]=time();
				$this->shop->insert($data);
			}
			$this->gomsg("保存成功");
		}
		
		public function onStatus(){
			$shopid=get_post('shopid',"i");
			$status=get_post("status","i");
			$this->shop->update(array("status"=>$status),"shopid=$shopid");
			exit(json_encode(array("error"=>0,"message"=>"状态修改成功")));
		}
		
		public function onDelete(){
			$shopid=get_post('shopid',"i");
			$this->shop->delete("shopid={$shopid}");
			exit(json_encode(array("error"=>0,"message"=>"删除成功")));
		}
		
			/*采集店铺*/
	public function onStole(){
		$this->loadClass("taobao");
		header("Content-type:text/html;charset=utf8");
		$s=isset($_GET['s'])?$_GET['s']:0;
		$w=get_post('w');
		if(empty($w)){
			echo '<form method="post" action="'.APPADMIN.'?m=admin_shop&a=stole"><input type="text" name="w" ><input type="submit"></form>';
			exit;
		}
		$data=$this->taobao->searchShop($w,$s);
		if(empty($data)){
			exit('采集完毕或者采集出错');
		}else{
			foreach( $data as $k=>$v){
				
				$v['last_time']=time();
				if(!$rs=$this->shop->selectRow(array("where"=>"nickname='".addslashes($v['nickname'])."' AND shopname='".addslashes($v['shopname'])."' "))){
					$v['dateline']=time();
					$dir=("attach/shop/".date("Y/m/d"))."/";
					umkdir($dir);
					$logo=$dir.time().basename($v['logo']);
					file_put_contents($logo,file_get_contents($v['logo']));
					$v['logo']=$logo;
					$this->shop->insert($v);
					
				}else{
					unset($v['word']);
					unset($v['logo']);
					$this->shop->update($rs,"shopid=".$rs['shopid']);
				}
			}
		}
		
		$s+=20;
		if($s>2000 ){
			exit("采集完毕");
		} 
		echo "<script>window.location.href='".APPADMIN."?m=admin_shop&a=stole&s=$s&w=".$w."';</script>";
		exit; 
	}
		
		
	}

?>