<?php 
class admin_userControl extends skymvc{
	
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("user"));
		if(empty($_SESSION['ssadmin'])){
			$this->gourl("".APPADMIN."?m=admin&a=login");	
		}
	}
	
	public function onDefault(){
		$url="".APPADMIN."?m=admin_user&a=default";
		$where=" 1=1 ";
		$userid=get('userid','i');
		if($userid){
			$where.=" AND userid=$userid";
			$url.="&userid=$userid";
		}
		
		$nickname=get('nickname','h');
		if($nickname){
			$where.=" AND nickname like '".$nickname."' ";
			$url.="&nickname=".urlencode($nickname);
		}
		$option=array(
			"where"=>$where,
			"order"=>"userid DESC",
			"start"=>get('per_page','i'),
			"limit"=>20
		);
		$rscount=true;
		$data=$this->user->select($option,$rscount);
		$pagelist=$this->pagelist($rscount,20,$url);
		
		$this->loadConfig("user");
	 
		$this->smarty->assign(array(
			"data"=>$data,
			"rscount"=>$rscount,
			"pagelist"=>$pagelist,
			"user_type_list"=>$this->config_item('user_type_list'),
		));
		$this->smarty->display("user/index.html");
	}
	
	public function onAdd(){
		$userid=get('userid','i');
		$data=$this->user->selectRow(array("where"=>" userid=$userid"));
		$this->loadConfig("user");
		$this->smarty->assign(array(
			"data"=>$data,
			"user_type_list"=>$this->config_item('user_type_list'),
		));
		$this->smarty->display("user/add.html");
	}
	
	public function onSave(){
		$userid=get_post("userid","i");
		$data["nickname"]=get_post("nickname","h");
		$data["user_type"]=get_post("user_type","i");
		$data["status"]=get_post("status","i");
		$data["user_card"]=get_post("user_card","h");
		$data["truename"]=get_post("truename","h");
		$data["is_auth"]=get_post("is_auth","i");
		$data["user_head"]=get_post("user_head","h");
		$data["telephone"]=get_post("telephone","h");
		$data['is_post']=get_post('is_post','i');
		if($userid){
			$this->user->update($data,array('userid'=>$userid));
		}else{
			$this->user->insert($data);
		}
		$this->gomsg("保存成功");
		
	}
	
}

?>