<?php
class admin_xfapiControl extends skymvc{
	
	public function __construct(){
		parent::__construct();
		if(empty($_SESSION['ssadmin'])){
			$this->gourl("".APPADMIN."?m=admin&a=login");	
		}
		$this->loadModel(array("category","product","product_data"));
	}

	
	public function onDefault(){
 		set_time_limit(100);
		$xfCat=file_get_contents("http://www.xingfunv.com/index.php?m=xfapi&a=category");
 
		 
		$xfCatList=json_decode($xfCat,true);
		if(file_exists(ROOT_PATH."config/xfapi_config.php")){
			$c=json_decode(file_get_contents(ROOT_PATH."config/xfapi_config.php"),true);
			$this->smarty->assign(array(
				"catids"=>$c['catids'],
				"is_stoles"=>$c['is_stoles'],
				"data"=>$c['data']
			));
		}
		$this->smarty->assign(array(
			"xfCatList"=>$xfCatList,
		));
		$this->smarty->display("xfapi/index.html");
	}
	
	public function onSave(){
		$catids=$_POST['catid'];
		$is_stoles=$_POST['is_stole'];
		$data=array();
		foreach($catids as $k=>$v){
			if($is_stoles[$k]){
				$data[$k]=$v;
			}
		}
		$content=array(
			"catids"=>$catids,
			"is_stoles"=>$is_stoles,
			"data"=>$data
		);
		file_put_contents(ROOT_PATH."config/xfapi_config.php",json_encode($content));
		$this->gomsg("保存成功");
	}
	//开始采集
	public function onStole(){
		set_time_limit(600);
		if(file_exists(ROOT_PATH."config/xfapi_config.php")){
			$c=json_decode(file_get_contents(ROOT_PATH."config/xfapi_config.php"),true);
			$catids=$c['data'];
			if($catids){
				foreach($catids as $k=>$v){
					$stole_catids[]=$k;
				}
			}else{
				exit('必须选择一个分类');
			}
		}else{
			exit("请先配置文件");
		}
		$stolekey="xfapi_stole".date("Ymd");
		session_write_close();
		if($tmp=$this->cache->get($stolekey)){
			$data=$tmp;
			
		}else{
			echo "http://www.xingfunv.com/index.php?m=xfapi&a=api&domain=".$_SERVER['HTTP_HOST']."&catids=".implode(",",$stole_catids);
			$data=json_decode(file_get_contents("http://www.xingfunv.com/index.php?m=xfapi&a=api&domain=".$_SERVER['HTTP_HOST']."&catids=".implode(",",$stole_catids)),true);
			if($data['error']){
				exit($data['message']);
			}
			if(empty($data)) exit('采集不到数据');
			$this->cache->set($stolekey,$data,3600*24);
		}
		if(empty($data)) exit('采集不到数据');
		$skey="xfapi_stole_key".date("Ymd");
		if($key=$this->cache->get($skey)){
			$in=isset($data[$key])?$data[$key]:false;
		}else{
			$in=isset($data[0])?$data[0]:false;
		}
		if($in){
			//判断是否已经采集了
			
			if($this->product->selectRow(array("where"=>"goodsid=".$in['goodsid']))){				 
				$key=intval($key)+1;
				$this->cache->set($skey,$key,3600*24);				 
				echo "<script>window.location.href='".APPADMIN."?m=admin_xfapi&a=stole&tt=".time()."'</script>";
				exit;
			}
			//开始采集
			$id=$this->product->insert(array("title"=>"临时文件"));
			$this->loadClass("upload");
			$dir="attach/product/".$this->upload->dirId($id);
			$this->loadClass("image");
			$img=new image(); 
			umkdir($dir);
			$imgurl=$dir.microtime(true).md5($in['imgurl']).".jpg";
			
			app_file_put_contents($imgurl,app_file_get_contents("http://www.xingfunv.com/".$in['imgurl']));
			$in['imgurl']=$imgurl;
			$mini_img=$img->makethumb($imgurl.".100x100.jpg",$imgurl,"100","100",1);
			$small_img=$img->makethumb($imgurl.".small.jpg",$imgurl,"240");				 
			$middle_img=$img->makethumb($imgurl.".middle.jpg",$imgurl,"440");
			unset($in['id']);
			$indata['content']=$this->xfcontent($in['content'],$id);
			unset($in['content']);
			$in['catid']=$catids[$in['catid']];
			
			$this->product->update(addslashes_deep($in),"id=$id");
			$indata['id']=$id;
			$indata['total_num']=99;
			$this->product_data->insert(addslashes_deep($indata));
			$key=intval($key)+1;
			$this->cache->set($skey,$key,3600*24);
			 
			echo "<script>window.location.href='".APPADMIN."?m=admin_xfapi&a=stole&tt=".time()."'</script>";
			exit;
		}else{
			exit('今天采集任务完成了');
		}
		
		 
		
	}
	/*采集内容处理*/
	public function xfcontent($str,$id){
		//图片处理
		
		preg_match_all("/<img.*src=['\"](.*)['\"].*[\/]?[^>]>/iUs",$str,$data);
		if(isset($data[1])){
			$imgs=$data[1];
			foreach($imgs as $k=>$v){
				if(strpos($v,"http://")===false){
					$newimg=$dir="attach/product/".$this->upload->dirId($id);
					umkdir($newimg);
					$newimg.=microtime(true).md5($v).".jpg";
					file_put_contents(ROOT_PATH.$newimg,file_get_contents("http://www.xingfunv.com/".$v));
					$str=str_replace($v,$newimg,$str);
				}
			}
		}else{
			return $str;
		}
		return $str;
	}
	
	
}
?>