<?php
class groupbuyControl extends skymvc{
	public $order_type=5;
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("user","login","product","category","order","order_address","order_product","gold_log","user_address","district"));
		$this->login->checkLogin();
	}
	
	public function onDefault(){
		
	}

	public function onConfirm(){
		$id=get('id','i');
		$user=$this->login->getUser();
		$data=$this->product->selectRow(array("where"=>"id=$id"));
		
		if(empty($data)){
			$this->gomsg("该商品已经团购完了");
		}
		if($data['total_num']<=$data['buy_num']){
			$this->gomsg("该商品已经团购完了");
		}
		if($data['start_time']>time() or $data['end_time']<time()){
			$this->gomsg("该商品团购活动已经结束");	
		}
		if($data['lower_price']>$user['money']){
			$this->gomsg("您的余额不足，团购不成功！");
		}
		
		$cat=$this->category->selectRow(array("where"=>"id=".$data['catid']));
		if($cat['type_id']!=$this->order_type){
			$this->gomsg("数据出错");	
		}
		
		//判断是否已经团购过了
		if($this->order->selectRow(array("where"=>"userid=".$user['userid']." AND type_id=".PRODUCT_TYPE_ID." AND object_id=".$id." "))){
			 $this->gomsg("你已经团购过了，不能再团购了");
		}
		//收货地址
		$address=$this->user_address->select(array("where"=>"userid=".$user['userid'],"order"=>"isdefault desc"));
		if($address){
			foreach($address as $v){
				$d_ids[]=$v['province_id'];
				$d_ids[]=$v['city_id'];
				$d_ids[]=$v['town_id'];
			}
			$dist_list=$this->district->dist_list(array("where"=>" id in(".implode(",",$d_ids).") ","start"=>0,"limit"=>1000000)); 
		}
		$this->smarty->assign(array(
			"data"=>$data,
			"address"=>$address,
			"dist_list"=>$dist_list,
			"back_url"=>$_SERVER['HTTP_REFERER'],
		));
		$this->smarty->display("groupbuy/confirm.html");
	}
	
	public function onCheck(){
		$id=get('id','i');
		$user=$this->login->getUser();
		$data=$this->product->selectRow(array("where"=>"id=$id"));
		if(empty($data)){
			exit(json_encode(array("error"=>1,"message"=>"该商品已经团购完了")));
		}
		if($data['total_num']<=$data['buy_num']){
			exit(json_encode(array("error"=>1,"message"=>"该商品已经团购完了")));
		}
		
		if($data['start_time']>time() or $data['end_time']<time()){
			exit(json_encode(array("error"=>1,"message"=>"该商品团购活动已经结束")));	
		}
		if($data['lower_price']>$user['money']){
			exit(json_encode(array("error"=>1,"message"=>"您的余额不足，团购不成功！")));
		}
		$cat=$this->category->selectRow(array("where"=>"id=".$data['catid']));
		if($cat['type_id']!=$this->order_type){
			 
			exit(json_encode(array("error"=>1,"message"=>"数据出错！")));
		}
		
		//判断是否已经团购过了
		if($this->order->selectRow(array("where"=>"userid=".$user['userid']." AND type_id=".PRODUCT_TYPE_ID." AND object_id=".$id." "))){
			 exit(json_encode(array("error"=>1,"message"=>"你已经团购过了，不能再团购了")));
		}
		exit(json_encode(array("error"=>0,"message"=>"正在跳转中","url"=>"/index.php?m=groupbuy&a=confirm&id=".$id)));
	}
	
	public function onOrder(){
		$id=get_post('id','i');
		$back_url=str_replace("&amp;","&",post('back_url','h'));
		$user=$this->login->getUser();
		$data=$this->product->selectRow(array("where"=>"id=$id"));
		if(empty($data)){
			$this->gomsg("该商品已经团购完了",$back_url);
		}
		$amount=min(1,get_post('amount','i'));
		if($data['total_num']<=$data['buy_num']){
			$this->gomsg("该商品已经团购完了",$back_url);
		}
		if($data['total_num']<=$data['buy_num']+$amount){
			$this->gomsg("该商品库存不足",$back_url);
		}
		if($data['start_time']>time() or $data['end_time']<time()){
			$this->gomsg("该商品团购活动已经结束",$back_url);	
		}
		if($data['lower_price']>$user['money']){
			$this->gomsg("您的余额不足，团购不成功！",$back_url);
		}
		
		$cat=$this->category->selectRow(array("where"=>"id=".$data['catid']));
		if($cat['type_id']!=$this->order_type){
			$this->gomsg("数据出错");	
		}
		//判断是否已经团购过了
		if($this->order->selectRow(array("where"=>"userid=".$user['userid']." AND type_id=".PRODUCT_TYPE_ID." AND object_id=".$id." "))){
			 $this->gomsg("你已经团购过了，不能再团购了",$back_ur);
		}
		$user_address_id=post('user_address_id','i');
		$addr=$this->user_address->selectRow(array("where"=>"id=".$user_address_id));
		if(empty($addr)){
			$this->gomsg("请选择收货地址",$back_url);
		}
		
		//处理订单
		$order_id=$this->order->insert(array(
			"orderno"=>"g".$user['userid'].time(),
			"dateline"=>time(),
			"ispay"=>2,
			"userid"=>$user['userid'],
			"type_id"=>$this->order_type,
			"send_id"=>post('send_id','i'),
			"comment"=>post('comment','h'),
			"money"=>$data['lower_price']*$amount,
			"user_address_id"=>$user_address_id,
			"object_id"=>$id
		));
		//处理订单的产品
		if($order_id){
			$this->order_product->insert(array(
				"order_id"=>$order_id,
				"userid"=>$user['userid'],
				"object_id"=>$id,
				"type_id"=>PRODUCT_TYPE_ID,
				"price"=>$data['lower_price'],
				"amount"=>$amount,
				"dateline"=>time(),
				"attr"=>json_encode(post('serialize'))
			));
		}else{
			$this->gomsg("订单处理失败",$back_url);
		}
		
		//处理订单收货地址
		$d_ids=array($addr['province_id'],$addr['city_id'],$addr['town_id']);
		$dist_list=$this->district->dist_list(array("where"=>" id in(".implode(",",$d_ids).") ")); 
		$this->order_address->insert(array(
			"order_id"=>$order_id,
			"userid"=>$user['userid'],
			"truename"=>$addr['truename'],
			"telephone"=>$addr['telephone'],
			"p_c_t"=>$dist_list[$addr['province_id']].$dist_list[$addr['city_id']].$dist_list[$addr['town_id']],
			"address"=>$addr['address'],
			"dateline"=>time()
		));
		
		//添加产品购买数
		$this->product->changenum("buy_num",$amount,"id=$id");
		//添加金钱消费记录
		$this->loadControl("jfapi");
		$this->jfapiControl->addMoney(array(
				"money"=>"-".$data['lower_price']*$amount,
				"type_id"=>5,
				"ispay"=>1,
				"content"=>"您购买了".$data['title'].",消耗了".$data['lower_price']*$amount."元，之前有[oldmoney]元，目前还剩[newmoney]元",
			));		
		$this->gomsg("恭喜你，参与团购成功",$back_url);
		
	}
	
	
	
}

?>