<?php
class hotareaControl extends skymvc{
	
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("hotarea","product","shop"));	
	}
	
	public function onDefault(){
		$where=" siteid = ".SITEID."  AND status=1 ";
		$url="/index.php?m=hotarea";
		$start=get('per_page','i');
		$limit=10;
		$option=array(
			"where"=>$where,
			"start"=>$start,
			"limit"=>$limit,
			"order"=>"id DESC",
		);
		$rscount=true;
		$data=$this->hotarea->select($option,$rscount);
		$pagelist=$this->pagelist($rscount,$limit,$url);
		$this->smarty->assign(array(
			"data"=>$data,
			"pagelist"=>$pagelist,
			"rscount"=>$rscount
		));
		$this->smarty->display("hotarea/index.html");
	}
	
	public function onList(){
		$where=" siteid = ".SITEID." AND status=1 ";
		$url="/index.php?m=hotarea";
		$start=get('per_page','i');
		$limit=10;
		$option=array(
			"where"=>$where,
			"start"=>$start,
			"limit"=>$limit,
			"order"=>"id DESC",
		);
		$rscount=true;
		$data=$this->hotarea->select($option,$rscount);
		$pagelist=$this->pagelist($rscount,$limit,$url);
		$this->smarty->assign(array(
			"data"=>$data,
			"pagelist"=>$pagelist,
			"rscount"=>$rscount
		));
		$this->smarty->display("hotarea/list.html");
	}
	
	public function onShow(){
		$id=get('id','i');
		$data=$this->hotarea->selectRow(array("where"=>"id=$id"));
		$this->smarty->assign(array(
			"data"=>$data,
			"list"=>$this->product($data),
		));
		$this->smarty->display("hotarea/show.html");
	}
	
	public function product($data){
		$bounds=str_replace(array("(",")"),"",$data['bounds']);
		$lat=$data['lat'];
		$lng=$data['lng'];
		$m=explode(",",$bounds);
		$where=" isgps=1 AND (lat>'$m[0]' AND lat<'$m[2]' AND lng>'$m[1]' AND lng<'$m[3]')";
		$catid=get('catid','i');
		if($catid){
			$this->loadConfig("c_category_children");
			$cids=$this->config_item(array("category_children",$catid));
			if(empty($cids)){
				$where.=" AND 1=2 ";
			}else{
				$where.=" AND catid in("._implode($cids).") ";
			}
			$url.="&catid=".$catid;
		}
		$title=get('title','h');
		if($title){
			$where.=" AND title like '%".$title."%' ";
			$url.="&title=".urlencode($title);
		}
		$option=array(
				"where"=>$where,
				"limit"=>2000,
				"fields"=>"id,(ABS(lat-".$lat.") + ABS(lng-".$lng.")) as mi",
		);
		$rscount=true;
		$arr=$this->product->select($option,$rscount);
		if($arr)
		{
			foreach($arr as $r)
			{
				$miarr[]=$r;
				$ids[]=$r['id'];
			}
		}
		
		$limit=20;
		$page=max(1,intval($_GET['page']));
		$start=($page-1)*$pagesize;
		if($ids){
			$max=count($ids);
			$big=$start+$limit;
			$big=$big<$max?$big:$max;
			for($i=$start;$i<$big;$i++){
				$tids[]=$ids[$i];
			}
			$tids && $list=$this->product->select(array("where"=>" id in("._implode($tids).")"));
		}
		return $list;
	}
	
	public function onProduct(){
		$id=get('id','i');
		$data=$this->hotarea->selectRow(array("where"=>"id=$id"));
		$url="/index.php?m=hotarea&a=product&id=$id";
		$bounds=str_replace(array("(",")"),"",$data['bounds']);
		$lat=$data['lat'];
		$lng=$data['lng'];
		$m=explode(",",$bounds);
		$where=" isgps=1 AND (lat>'$m[0]' AND lat<'$m[2]' AND lng>'$m[1]' AND lng<'$m[3]')";
		$catid=get('catid','i');
		if($catid){
			$this->loadConfig("c_category_children");
			$cids=$this->config_item(array("category_children",$catid));
			if(empty($cids)){
				$where.=" AND 1=2 ";
			}else{
				$where.=" AND catid in("._implode($cids).") ";
			}
			$url.="&catid=".$catid;
		}
		$title=get('title','h');
		if($title){
			$where.=" AND title like '%".$title."%' ";
			$url.="&title=".urlencode($title);
		}
		$option=array(
				"where"=>$where,
				"limit"=>2000,
				"fields"=>"id,(ABS(lat-".$lat.") + ABS(lng-".$lng.")) as mi",
		);
		$rscount=true;
		$arr=$this->product->select($option,$rscount);
		if($arr)
		{
			foreach($arr as $r)
			{
				$miarr[]=$r;
				$ids[]=$r['id'];
			}
		}
		
		$limit=20;
		$page=max(1,intval($_GET['page']));
		$start=($page-1)*$pagesize;
		if($ids){
			$max=count($ids);
			$big=$start+$limit;
			$big=$big<$max?$big:$max;
			for($i=$start;$i<$big;$i++){
				$tids[]=$ids[$i];
			}
			$tids && $list=$this->product->select(array("where"=>" id in("._implode($tids).")"));
		}
		$this->smarty->assign(array(
			"data"=>$data,
			"list"=>$list
		));
		$this->smarty->display("hotarea/product.html");
	}
	
	
	public function onShop(){
		$id=get('id','i');
		$data=$this->hotarea->selectRow(array("where"=>"id=$id"));
		$url="/index.php?m=hotarea&a=product&id=$id";
		$bounds=str_replace(array("(",")"),"",$data['bounds']);
		$lat=$data['lat'];
		$lng=$data['lng'];
		$m=explode(",",$bounds);
		$where="  status=2 AND (lat>'$m[0]' AND lat<'$m[2]' AND lng>'$m[1]' AND lng<'$m[3]')";
		$catid=get('catid','i');
		if($catid){
			$this->loadConfig("c_category_children");
			$cids=$this->config_item(array("category_children",$catid));
			if(empty($cids)){
				$where.=" AND 1=2 ";
			}else{
				$where.=" AND catid in("._implode($cids).") ";
			}
			$url.="&catid=".$catid;
		}
		$title=get('title','h');
		if($title){
			$where.=" AND shopname like '%".$title."%' ";
			$url.="&title=".urlencode($title);
		}
		$option=array(
				"where"=>$where,
				"limit"=>2000,
				"fields"=>"shopid,(ABS(lat-".$lat.") + ABS(lng-".$lng.")) as mi",
		);
		$rscount=true;
		$arr=$this->shop->select($option,$rscount);
		if($arr)
		{
			foreach($arr as $r)
			{
				$miarr[]=$r;
				$ids[]=$r['shopid'];
			}
		}
		$limit=20;
		$page=max(1,intval($_GET['page']));
		$start=($page-1)*$pagesize;
		if($ids){
			$max=count($ids);
			$big=$start+$limit;
			$big=$big<$max?$big:$max;
			for($i=$start;$i<$big;$i++){
				$tids[]=$ids[$i];
			}
			$tids && $list=$this->shop->select(array("where"=>" shopid in("._implode($tids).")"));
		}
		$this->smarty->assign(array(
			"data"=>$data,
			"list"=>$list
		));
		$this->smarty->display("hotarea/shop.html");
	}
	
	
}
?>