<?php
class listControl extends skymvc{
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("product","category","comment","product_data","user","feeds"));
		$this->loadConfig("c_category_children");
		
	}
	
	public function onDefault(){
		$tpl="product/list.html";
		$tmp_tpl="";
		$w=" status<99 ";
		$url="/index.php?m=list&a=default";
		$catid=get_post('catid','i');
		$cat=$this->category->selectRow(array("where"=>"id=$catid"));
		if($catid && empty($cat)){
			$this->gomsg("分类不存在","/index.php");
		}
		$pagesize=48;
		$category_children=$this->config_item('category_children');	
		if($catid){
			$cids=$category_children[$catid];
			if(!empty($cids)){
				$w.=" AND catid in(".implode(",",$cids).") ";
			}else{
				$w.=" AND 1=2 ";
			}
			$url.="&catid=".$catid;
			//处理分类
			
			$cat_top=$cat;
			if($cat['pid']){
				$parent=$this->category->selectRow(array("where"=>"id=".$cat['pid']));
				$this->smarty->assign("parent",$parent);
				if($cat['pid']){
					$parent=$this->category->selectRow(array("where"=>array("id"=>$cat['pid'])));
					if($parent['pid']){
						$cat_2nd=$parent;
						$cat_top=$this->category->selectRow(array("where"=>array("id"=>$parent['pid'])));
						$cat_3nd=$cat;
						if($cat_top['listtpl']) $tpl=$cat_top['listtpl'];	
					}else{
						$cat_top=$parent;
						$cat_2nd=$cat;
					}
					if($parent['listtpl']) $tpl=$parent['listtpl'];					 
				}
				
			}
			if($cat['listtpl']) $tpl=$cat['listtpl'];
		}
		$sprice=get('sprice','i');
		if($sprice){
			switch($sprice){
				case 1://0-50
						$w.=" AND price<50";
					break;
				case 2://51-100
						$w.=" AND (price>50 AND price<=100) ";			
					break;
				case 3://101-200
						$w.=" AND (price>100 AND price<=200) ";
					break;
				case 4://201-500
						$w.=" AND (price>200 AND price<=500) ";
					break;
				case 5://500以上
						$w.=" AND price>500 ";
					break;
			}
			$url.="&sprice=".$sprice;
		}
		if($tagname=get_post('tagname')){
			$w.=" AND title like '%".$tagname."%' ";
			$url.="&tagname=".urlencode($tagname);
		}
		$this->smarty->assign("baseurl",$url);
		
		if(is_robot()){
			$w.=" AND status<10 ";
			$ord=" id DESC";	
		}else{
			$w.=" AND status<10 AND status>0 ";
			if(get('order')=='hot'){
				$ord=" grade DESC";
				$url.="&order=hot";
			}else{
				$ord=" id DESC";
				$url.="&order=new";
			}
		}
		
						 
		
		$start=get('per_page','i');
		
		$rscount=true;
		$pagesize=ISWAP?$pagesize/2:$pagesize;
		$list=$this->product->select(array(
			"where"=>$w,
			"start"=>$start,
			"limit"=>$pagesize,
			"order"=>$ord
			
		),$rscount);
		if($list){
			$t_ids=array();
			foreach($list as $k=>$v){
				$t_ids[]=$v['catid'];
			}
			if($t_ids){
				$t_c=$this->category->cat_list(" id in("._implode($t_ids).")");
			}
			foreach($list as $k=>$v){
				$v['cname']=$t_c[$v['catid']];
				$list[$k]=$v;
			}
		}
		$pagelist=$this->pagelist($rscount,$pagesize,$url);
		 
		$seo_tag=$tagname?$tagname."-":"";
		$seo_tag_keyword=$tagname?$tagname.",":"";
		$seo=array(
			"title"=>$seo_tag.strip_tags($cat['title']),
			"keywords"=>$seo_tag.$cat['keywords'],
			"description"=>$seo_tag.$cat['description']
		);
		if(get('ajax')){
			exit(json_encode($list));
		}
		$this->smarty->assign(
			array(
			"baseurl"=>$url,
			"seo"=>$seo,
			"list"=>$list,
			"pagelist"=>$pagelist,
			"cat"=>$cat,
			"cat_top"=>$cat_top,
			"cat_2nd"=>$cat_2nd,
			"cat_3nd"=>$cat_3nd,
			"rscount"=>$rscount,
			"pagesize"=>$pagesize,
			)
		);
		$this->smarty->assign("price_list",array(
			1=>"0-50",
			2=>"51-100",
			3=>"101-200",
			4=>"200-500",
			5=>"500元以上"
		));
		$this->smarty->display($tpl);
	}
	
}
?>