<?php
class orderControl extends skymvc{
	public $user;
	public $userid;
	public $order_type=1;
	public $oc_where;
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("user","login","product","order","order_address","order_product","gold_log","order_log","notice","user_address","district","order_cart","shop"));
		$this->loadConfig("table");
		$this->login->checkLogin();
		$this->userid=$this->login->userid;
		$this->user=$this->login->getUser();
		
		$this->oc_where=$this->login->userid?" (userid=".$this->login->userid." or oc_ssid='".OC_SSID."')  ":"oc_ssid='".OC_SSID."' ";
	}
	public function onDefault(){
		
	}
	
	public function onConfirm(){
		$this->loadControl("order_cartapi");
		$user=$this->user;
		$orderCart=$this->order_cartapiControl->cart();
		if(empty($orderCart['list'])) $this->gomsg("请先去选购产品","/index.php");
		//收货地址
		$address=$this->user_address->select(array("where"=>"userid=".$user['userid'],"order"=>"isdefault desc"));
		if($address){
			foreach($address as $v){
				$d_ids[]=$v['province_id'];
				$d_ids[]=$v['city_id'];
				$d_ids[]=$v['town_id'];
			}
			$dist_list=$this->district->dist_list(array("where"=>" id in(".implode(",",$d_ids).") ","start"=>0,"limit"=>1000000)); 
		}
		$this->smarty->assign(array(
			"address"=>$address,
			"dist_list"=>$dist_list,
			"back_url"=>$_SERVER['HTTP_REFERER'],
			"orderCart"=>$orderCart
		));
		$this->smarty->display("order/confirm.html");
		
	}
	
	public function onBuyProduct(){
		$data['object_id']=get_post('object_id','i');
		if(!$data['object_id']) $this->gomsg("商品不存在");;
		$t_d=$this->product->selectRow(array("where"=>" status>0 AND status<98 AND id=".$data['object_id']));
		if(empty($t_d)) $this->gomsg("商品已下线");;
		//判断商品数量
		$amount=$data['amount']=max(1,get_post('amount','i'));
		if(($t_d['total_num']-$t_d['buy_num'])<$data['amount']){
			 
			$this->gomsg("商品库存不足");
		}
		$data['type_id']=max(1,get('type_id'));
		$data['dateline']=time();
		$data['userid']=$this->login->userid;
		
		$data['siteid']=SITEID;
		$data['shopid']=$t_d['shopid'];
		$data['oc_ssid']=OC_SSID;
		$data['attr']=json_encode(get('attr'));
		$row=$this->order_cart->selectRow(array("where"=>$this->oc_where." AND type_id=".$data['type_id']." AND object_id=".$data['object_id']."   ")); 
		if($row && $row['attr']==$data['attr']){
			$cart_id=$row['id'];	
			$this->order_cart->update(array("amount"=>$data['amount']),"id=".$row['id']);
			$isupdate=1;
		}else{
			$isupdate=0;
			$cart_id=$this->order_cart->insert($data);
		}
		$_POST['cart_id']=array($cart_id);
		$this->onOrder();
	}
	
	public function onOrder(){
		$user=$this->user;
		$user_address_id=post('user_address_id','i');
		$addr=$this->user_address->selectRow(array("where"=>"id=".$user_address_id));
		if(empty($addr)){
			$this->gomsg("请选择收货地址");
		}
		//处理商品
		$ids=post('cart_id','i');
		if($ids){
			$cart_list=$this->order_cart->select(array("where"=> $this->oc_where ." AND id in("._implode($ids).") "));
			if(empty($cart_list)) $this->gomsg("请选择要购买的商品");
			$total_money=0;
			$shops=array();
			foreach($cart_list as $k=>$v){
				$t_d=$this->product->selectRow(array("where"=>" id=".$v['object_id']." AND status>0 AND status<98 " ));
				if(empty($t_d) or ($t_d['total_num']-$t_d['buy_num']<$v['amount'])){
					$this->gomsg("产品<a href='".R("/index.php?m=show&id=".$t_d['id'])."'>".$t_d['title']."</a>库存不中，当前还剩".($t_d['total_num']-$t_d['buy_num'])."件，请删除该商品");
				}
				$v['price']=($t_d['lower_price']>0?$t_d['lower_price']:$t_d['price']);
				$total_money +=$v['price']*$v['amount'];
				$cart_list[$k]=$v;	
				$shops[$v['shopid']]['total_money'] +=	$total_money;
				$shops[$v['shopid']]['cart_list'][]=$v;	
			}
			
			
			
		}else{
			$this->gomsg("请选择要购买的商品");
		}
		
		//End 处理商品
		$isfinish=0;
		$ispay=1;
		$this->loadControl("jfapi");
		if($total_money<=$user['money']){
			//添加金钱消费记录		
			$this->jfapiControl->addMoney(array(
				"money"=>"-".$total_money,
				"type_id"=>5,
				"ispay"=>1,
				"content"=>"您购买了商品,消耗了".$total_money."元，之前有[oldmoney]元，目前还剩[newmoney]元",
			));
			$ispay=2;
			$isfinish=1;		
		}
		
		if(post('unpay','i')){
			$isfinish=1;
			$unpay=post('unpay','i');
		}
		foreach($shops as $k=>$shop){
			//处理订单
			$order_id=$this->order->insert(array(
				"orderno"=>"o_".$user['userid'].time().$k,
				"dateline"=>time(),
				"ispay"=>$ispay,
				"userid"=>$user['userid'],
				"type_id"=>$this->order_type,
				"send_id"=>post('send_id','i'),
				"comment"=>post('comment','h'),
				"money"=>$shop['total_money'],
				"user_address_id"=>$user_address_id,
				"object_id"=>0,
				"unpay"=>$unpay,
				"shopid"=>$k,
			));
			//处理订单的产品
			if($order_id){
				foreach($shop['cart_list'] as $k=>$v){
					$this->order_product->insert(array(
						"order_id"=>$order_id,
						"userid"=>$user['userid'],
						"object_id"=>$v['object_id'],
						"type_id"=>$v['type_id'],
						"price"=>$v['price'],
						"amount"=>$v['amount'],
						"dateline"=>time(),
						"attr"=>$v['attr']
					));
				}
			}else{
				$this->gomsg("订单处理失败",$back_url);
			}
			
			//处理订单收货地址
			$d_ids=array($addr['province_id'],$addr['city_id'],$addr['town_id']);
			$dist_list=$this->district->dist_list(array("where"=>" id in(".implode(",",$d_ids).") ")); 
			$this->order_address->insert(array(
				"order_id"=>$order_id,
				"userid"=>$user['userid'],
				"truename"=>$addr['truename'],
				"telephone"=>$addr['telephone'],
				"p_c_t"=>$dist_list[$addr['province_id']].$dist_list[$addr['city_id']].$dist_list[$addr['town_id']],
				"address"=>$addr['address'],
				"dateline"=>time()
			));
		}
		//清除购物车
		
		$this->order_cart->delete($this->oc_where." AND id in("._implode($ids).")");
		if($isfinish){
			$this->gomsg($this->lang['order_success'],"/index.php?m=order&a=show&order_id=".$order_id);
		}else{
			$this->gourl("/index.php?m=order&a=pay&order_id=".$order_id);
		}
	}
	
	public function onPay(){
		$order_id=get('order_id','i');
		 $this->gourl("/index.php?m=recharge&a=default&order_id=".$order_id);
	}
	
	public function onMy(){
		$where=" status<99 AND userid=".$this->userid;
		$url=APPINDEX."?m=order&a=my";
		$start=get('per_page','i');
		$limit=20;
		$option=array(
			"where"=>$where,
			"order"=>"order_id DESC",
			"start"=>$start,
			"limit"=>$limit
		);
		$rscount=true;
		$data=$this->order->select($option,$rscount);
		if($data){
			foreach($data as $k=>$v){
				$v['address']=$this->order_address->selectRow(array("where"=>"order_id=".$v['order_id'],"order"=>"id DESC"));
				if($v['shopid']){
					$sp=$this->shop->selectRow(array("where"=>" shopid=".$v['shopid']));
					$v['shopname']=$sp['shopname'];	
				}
				$v['product']=$this->orderproduct($v['order_id']);
				 
				$data[$k]=$v;
			}
		}
		$pagelist=$this->pagelist($rscount,$limit,$url);
		$order_status_list=$this->config_item('order_status_list');
		$order_type_list=$this->config_item('order_type_list');
		$order_ispay=$this->config_item('order_ispay');
		$this->smarty->assign(array(
			"data"=>$data,
			"rscount"=>$rscount,
			"pagelist"=>$pagelist,
			"order_status_list"=>$order_status_list,
			"order_type_list"=>$order_type_list,
			"order_ispay"=>$order_ispay,
			
		));
		$this->smarty->display("order/my.html");
	}
	

	
	public function onshow(){
		$order_id=get('order_id','i');
		$data=$this->order->selectRow(array("where"=>"order_id=".$order_id));
		if(empty($data)) $this->gomsg("参数出错");
		$addr=$this->order_address->selectRow(array("where"=>"order_id=".$order_id,"order"=>"id DESC"));
		$order_status_list=$this->config_item('order_status_list');
		$order_type_list=$this->config_item('order_type_list');
		$order_ispay=$this->config_item('order_ispay');
		//获取商品
		$order_product=$this->order_product->select(array("where"=>"order_id=".$data['order_id']));
		foreach($order_product as $k=>$v){
			$p=$this->product->selectRow(array("where"=>"id=".$v['object_id']));
			$p['order_price']=$v['price'];
			$order_product[$k]=$p;
		}
		$this->smarty->assign(array(
			"data"=>$data,
			"addr"=>$addr,
			"order_status_list"=>$order_status_list,
			"order_type_list"=>$order_type_list,
			"order_ispay"=>$order_ispay,
			"order_product"=>$order_product,
		));
		$this->smarty->display("order/show.html");
	}
	
	public function orderproduct($order_id){
		
		$order_product=$this->order_product->select(array("where"=>"order_id=".intval($order_id)));
		foreach($order_product as $k=>$v){
			$p=$this->product->selectRow(array("where"=>"id=".$v['object_id']));
			$p['order_price']=$v['price'];
			$p['amount']=$v['amount'];
			$order_product[$k]=$p;
		}
		return $order_product;	
	}
	
	public function onReceive(){
		$order_id=get('order_id','i');
		$data=$this->order->selectRow(array("where"=>" order_id=".$order_id." AND userid=".$this->userid." "));
		if(empty($data)){
			$this->gomsg($this->lang['data_no_exists'],"/index.php");
		}
		$this->order->update(array("isreceived"=>2)," order_id=".$order_id." ");
		$this->gomsg($this->lang['save_success']);
	}
	
	
}
?>