<?php
class order_cartControl extends skymvc{
	public $oc_where;
	public $userid;
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("login","order_cart","product"));
		$this->oc_where=$this->login->userid?" (userid=".$this->login->userid." or oc_ssid='".OC_SSID."')  ":"oc_ssid='".OC_SSID."' ";
		$this->userid=$this->login->userid;
	}
	
	public function onDefault(){
		$this->loadControl("order_cartapi");
		$data=$this->order_cartapiControl->cart();
		$this->smarty->assign(array(
			"list"=>$data['list'],
			"total_money"=>$data['total_money']
		));
		$this->smarty->display("order_cart/index.html");
	}
	
	public function onGetCartNum(){
		$num=$this->order_cart->selectOne(array("where"=>$this->oc_where,"fields"=>" count(*) as ct"));
		echo json_encode(array("status"=>"success","num"=>$num));
	}
	public function onGetCart(){
		if(get('callback')){
			echo get('callback').'({"extras":[],"groups":[[{"name":"\u5168\u90e8\u7d20\u83dc+2\u79cd\u8364\u83dc+8\u4e24\u7c73\u7ebf","id":2248611,"quantity":1,"price":20,"garnishes":[]},{"name":"\u5168\u90e8\u7d20\u83dc+5\u79cd\u8364\u83dc+2\u65a4\u7c73\u7ebf","id":2248614,"quantity":1,"price":50,"garnishes":[]},{"name":"\u57fa\u56f4\u867e","id":2418112,"quantity":1,"price":0,"garnishes":[]},{"name":"\u6842\u82b1\u80a0","id":2248607,"quantity":1,"price":0,"garnishes":[]},{"name":"\u706b\u817f\uff08\u5c0f\u4efd\uff09","id":2248623,"quantity":1,"price":5,"garnishes":[]}]],"restaurantId":17630,"restaurantName":"\u6f58\u6c0f\u5927\u7406\u5bfa\u8fc7\u6865\u7c73\u7ebf","restaurantNameForUrl":"sz-psdlsgqmx","deliverAmount":13,"quantity":5,"total":75,"phoneOrder":false});';
		}
		$this->smarty->display("order_cart/cart.html");
	}
	
	public function onAdd(){
		$data['object_id']=get_post('object_id','i');
		if(!$data['object_id']) exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"商品不存在")));
		$t_d=$this->product->selectRow(array("where"=>" status>0 AND status<98 AND id=".$data['object_id']));
		/*根据星期判断是否可以购物*/
		if(SHOWWEEK){
			if(!$t_d['week'.getweek()]){
				exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"今天没卖该商品哦")));
			}
		}
		if(empty($t_d)) exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"商品已下线")));
		//判断商品数量
		$amount=$data['amount']=max(1,get_post('amount','i'));
		if(($t_d['total_num']-$t_d['buy_num'])<$data['amount']){
			exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"商品库存不足")));
		}
		$data['type_id']=max(1,get('type_id'));
		$data['dateline']=time();
		$data['userid']=$this->login->userid;
		
		$data['siteid']=SITEID;
		$data['shopid']=$t_d['shopid'];
		$data['oc_ssid']=OC_SSID;
		$data['attr']=json_encode(get('attr'));
		$row=$this->order_cart->selectRow(array("where"=>$this->oc_where." AND type_id=".$data['type_id']." AND object_id=".$data['object_id']."   ")); 
		if($row && $row['attr']==$data['attr']){
			if(($t_d['total_num']-$t_d['buy_num'])<(get_post('amount','i')+$row['amount'])){
				exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"商品库存不足")));
			}
			$amount=get_post('amount','i')+$row['amount'];
			$cart_id=$row['id'];	
			$this->order_cart->changenum("amount",$data['amount'],"id=".$row['id']);
			$isupdate=1;
		}else{
			$isupdate=0;
			$cart_id=$this->order_cart->insert($data);
		}
		
		$this->loadControl("order_cartapi");
		$data=$this->order_cartapiControl->cart();
		
		exit(json_encode(array("error"=>0,"message"=>"加入成功","isupdate"=>$isupdate,"id"=>$cart_id,"title"=>$t_d['title'],"amount"=>$amount,"price"=>($t_d['lower_price']>0?$t_d['lower_price']:$t_d['price']),"status"=>"success","num"=>$data['num'],"total_money"=>$data['total_money'])));
	}
	/**
	*直接购买
	*/
	public function onBuy(){
		$this->loadModel(array("user_address","district"));
		$this->loadControl("order_cartapi");
		$this->login->checklogin();
		$user=$this->login->getuser();
		$object_id=get('object_id','i');
		$data=$this->product->selectRow(array("where"=>" id=".$object_id));
		if(empty($data)) $this->gomsg("请先去选购产品","/index.php");
		//收货地址
		$address=$this->user_address->select(array("where"=>"userid=".$user['userid'],"order"=>"isdefault desc"));
		if($address){
			foreach($address as $v){
				$d_ids[]=$v['province_id'];
				$d_ids[]=$v['city_id'];
				$d_ids[]=$v['town_id'];
			}
			$dist_list=$this->district->dist_list(array("where"=>" id in(".implode(",",$d_ids).") ","start"=>0,"limit"=>1000000)); 
		}
		$this->smarty->assign(array(
			"address"=>$address,
			"dist_list"=>$dist_list,
			"back_url"=>$_SERVER['HTTP_REFERER'],
			"data"=>$data
		));
		$this->smarty->display("order_cart/buy.html");
	}
	
	public function onDelete(){
		$id=get_post('id','i');
		$data=$this->order_cart->selectRow(array("where"=>$this->oc_where." AND id=".$id." "));
		if(empty($data)){
			exit(json_encode(array("error"=>1,"message"=>"购物车不存在该商品")));
		}
		$this->order_cart->delete("id=$id  ");
		$this->loadControl("order_cartapi");
		$cart=$this->order_cartapiControl->cart();
		exit(json_encode(array("error"=>0,"message"=>"删除成功","total_money"=>$cart['total_money'])));
	}
	
	public function onClear(){
		$this->order_cart->delete($this->oc_where);
		exit(json_encode(array("error"=>0,"message"=>"删除成功")));
	}
	
	public function onNum_plus(){
		$id=get_post('id','i');
		$num=max(1,get_post('num'));
		$data=$this->order_cart->selectRow(array("where"=>$this->oc_where." AND id=".$id." "));
		if(empty($data)){
			exit(json_encode(array("error"=>1,"message"=>"购物车不存在该商品")));
		}
		$t_d=$this->product->selectRow(array("where"=>" status>0 AND status<98 AND id=".$data['object_id']));
		if(empty($t_d)) exit(json_encode(array("error"=>1,"message"=>"商品已下线")));
		//判断商品数量
		if(($t_d['total_num']-$t_d['buy_num'])< ($data['amount']+$num) ){
			exit(json_encode(array("error"=>1,"message"=>"商品库存不足")));
		}
		
		$res=$this->order_cart->changenum("amount",$num,"   id=".$id." " );
		$this->loadControl("order_cartapi");
		$cart=$this->order_cartapiControl->cart();
		if($res){
			exit(json_encode(array("error"=>0,"message"=>"增加数量成功","total_money"=>$cart['total_money'])));
		}else{
			exit(json_encode(array("error"=>1,"message"=>"增加数量失败")));
		}
	}
	
	public function onnum_minus(){
		$id=get_post('id','i');
		$num=max(1,get_post('num'));
		$data=$this->order_cart->selectRow(array("where"=>$this->oc_where." AND id=".$id." "));
		if(empty($data)){
			exit(json_encode(array("error"=>1,"message"=>"购物车不存在该商品")));
		}
		if($data['amount']-$num<=0){
			exit(json_encode(array("error"=>1,"message"=>"商品数量至少1件")));
		}
		$res=$this->order_cart->changenum("amount","-".$num, "   id=".$id." " );
		$this->loadControl("order_cartapi");
		$cart=$this->order_cartapiControl->cart();
		if($res){
			exit(json_encode(array("error"=>0,"message"=>"削减数量成功","total_money"=>$cart['total_money'])));
		}else{
			exit(json_encode(array("error"=>1,"message"=>"削减数量失败")));
		}
	}
	
}
?>