<?php
class rechargeControl extends skymvc{
	public $userid;
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("recharge","user","login","product","order","order_address","order_product"));
		$this->login->checkLogin();
		$this->userid=$this->login->userid;	
	}
	
	public function onDefault(){
		$order_id=get('order_id','i');
		if($order_id){
			$data=$this->order->selectRow(array("where"=>"order_id=".$order_id));
			if(empty($data)) $this->gomsg("参数出错");
			$addr=$this->order_address->selectRow(array("where"=>"order_id=".$order_id,"order"=>"id DESC"));
			$order_status_list=$this->config_item('order_status_list');
			$order_type_list=$this->config_item('order_type_list');
			$order_ispay=$this->config_item('order_ispay');
			//获取商品
			$order_product=$this->order_product->select(array("where"=>"order_id=".$data['order_id']));
			foreach($order_product as $k=>$v){
				$p=$this->product->selectRow(array("where"=>"id=".$v['object_id']));
				$p['order_price']=$v['price'];
				$order_product[$k]=$p;
			}
			$this->smarty->assign(array(
				"data"=>$data,
				"addr"=>$addr,
				"order_status_list"=>$order_status_list,
				"order_type_list"=>$order_type_list,
				"order_ispay"=>$order_ispay,
				"order_product"=>$order_product,
			));
		}
		switch(get('pay_type')){
			case 'alipay':
					$this->smarty->display("recharge/alipay.html");
					break;
			case 'tenpay':
					$this->smarty->display("recharge/index.html");
				break;
			default :
					$this->smarty->display("recharge/alipay.html");
				break;
		}
		
	}
	
	public function onRecharge(){
		$order_id=get_post('order_id','i');
		$data=$this->order->selectRow(array("where"=>"order_id=".$order_id));
		if(empty($data)) $this->gomsg("参数出错");
		$pay_type=post('pay_type','h');
		$orderno=$data?$data['orderno']:$this->userid."_".time();//根据实际情况一个用户1s不可能重复下订单
		$order_product=post('product_name')?post('product_name'):'网站充值';
		$order_price=$data?$data['money']:post('order_price',"r",2);
		$order_info=post('order_info','h');
		$bank_type=post('bank_type');
		/*****插入充值表******/
		$this->recharge->insert(array(
			"userid"=>$this->userid,
			"money"=>$order_price,
			"pay_type"=>$pay_type,
			"orderno"=>$orderno,
			"orderinfo"=>$order_product."<br>".$order_info, 
			"type_id"=>1,
			"dateline"=>time(),
			"status"=>2,	
		));
		
		/*插入充值表结束*/
		
		$url="http://".$_SERVER['HTTP_HOST']."/api/".$pay_type."/".$pay_type.".php";
		$url.="?orderno=$orderno";
		$url.="&bank_type=".$bank_type;
		$url.="&order_product=".$order_product;
		$url.="&order_price=".$order_price;
		$url.="&order_info=".$order_info;
		header("Location: ".$url);
		exit;
	}
	
}

?>