<?php
class registerControl extends skymvc{
	
	public function __construct(){
		parent::__construct();
		$this->loadModel(array("login","user","invite"));
	}
	
	public function onDefault(){
		$this->onReg();
	}
	
	public function onReg(){
		if(get('ajax')){
			$this->smarty->display("register/ajax_reg.html");
		}else{
			$this->smarty->display("register/reg.html");
		}
	}
	
	public function onRegSave(){
		$data['email']=$email=post('email','h');
		$password=post('password','h');
		$password2=post('password2','h');
		if($password!=$password2){
			$this->gomsg("两次输入的密码不一致");		
		}
		if(!is_email($email)){
			$this->gomsg("请正确输入邮箱");
		}
		if($this->user->select(array("where"=>"email='".$email."' "))){
			$this->gomsg("邮箱已经存在了");
		}
		
		$data['nickname']=post('nickname','h');
		if(empty($data['nickname'])){
			$this->gomsg("请输入昵称");
		}
		if($this->user->select(array("where"=>"nickname='".$data['nickname']."' "))){
			$this->gomsg("昵称已经存在");
		}
		$data['gender']=min(1,get('gender'));
		$data['salt']=rand(1000,9999);
		$data['password']=umd5($password.$data['salt']);
		if(isset($_COOKIE['invite_uid'])){
			$data['invite_userid']=intval($_COOKIE['invite_uid']);
		}
		$userid=$this->user->insert($data);
		$this->loadControl("inviteapi");
		$this->inviteapiControl->invite_reg($userid);
		$this->gomsg("注册成功",R("/index.php?m=login&a=login"));
	}
	
	public function onOpenReg(){
		$this->login->checkLogin();	
		$user=$this->login->getuser();
		if($user['email']){
			 $this->gomsg("你已经绑定过了","/index.php");
		}
		$this->smarty->display("register/openreg.html");
	}
	
	public function onOpenRegSave(){
		$this->login->checkLogin();
		$user=$this->login->getuser();
		if($user['email']){
			 $this->gomsg("你已经绑定过了","/index.php");
		}
		$data['email']=$email=post('email','h');
		$password=post('password','h');
		$password2=post('password2','h');
		if($password!=$password2){
			$this->gomsg("两次输入的密码不一致");		
		}
		if($this->user->select(array("where"=>"email='".$email."' "))){
			$this->gomsg("邮箱已经存在了");
		}
		$data['gender']=min(1,get('gender'));
		$data['salt']=rand(1000,9999);
		$data['password']=umd5($password.$data['salt']);
		$this->user->update($data,"userid=".$user['userid']);
		$this->gomsg("账号绑定成功","/index.php");
	}
	
	public function onCheck(){
		if(get_post('nickname')){
			$nickname=get('nickname');
			if($this->user->select(array("where"=>"nickname='".get_post('nickname')."' "))){
				exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"昵称已经存在")));
			}
		}
		
		if(get_post('email')){
			if($this->user->select(array("where"=>"email='".get_post('email')."' "))){
				exit(json_encode(array("error"=>1,"status"=>"failed","message"=>"邮箱已经存在")));
			}
		}
		
		exit(json_encode(array("error"=>0,"status"=>"success","msg"=>"OK")));
	}
	
}

?>