<?php
class userControl extends skymvc{
	public $userid;
	function __construct(){
		parent::__construct();
		$this->loadModel(array("user","login"));
		if(!$this->userid=$this->login->getUserId()){
			$this->gomsg("请先登录");
		}
	}
	public function onDefault(){
		$this->loadModel(array("follow"));
		$option=array();
		$data=$this->user->select($option);
		if($data){
			foreach($data as $k=>$v){
				if($v['userid']==$this->userid){
					unset($data[$k]);continue;
				}
				$f=$this->follow->setTable("follow",$this->userid)->selectRow(array("where"=>"userid=".$this->userid." AND t_userid=".$v['userid']." AND status in(1,2) "));
				if($f){
					$v['isfollow']=1;
				}else{
					$v['isfollow']=0;
				}
				$data[$k]=$v;
			}
		}
		$this->smarty->assign(array(
			"data"=>$data		
		));
		$this->smarty->display("user/index.html");
		
	}
 
	
	public function oninfo(){
		$userid=$this->userid;
		$data=$this->user->selectRow(array("where"=>" userid=$userid"));
		
		$this->smarty->assign(array(
			"data"=>$data,
		));
		$this->smarty->display("user/info.html");
	}
	
	public function onsave(){
		$userid=$this->userid;
		$data["nickname"]=get_post("nickname","h");
		$u=$this->user->selectRow(array("where"=>"nickname='".$data['nickname']."' "));
		if($u){
			if($u['userid']!=$userid){
				$this->gomsg("昵称已经存在了，请再取个吧");
			}
		}
		$data["user_head"]=get_post("user_head","h");
		//gps信息
		if(post('latlng')){
			$latlng=explode(",",post('latlng'));
			$data['lat']=$latlng[0];
			$data['lng']=$latlng[1];
		}
		if($userid){
			$this->user->update($data,array('userid'=>$userid));
		} 
		$this->gomsg("保存成功");
	}
	
	public function onAuth(){
		$userid=$this->userid;
		$data=$this->user->selectRow(array("where"=>" userid=$userid"));
		$this->loadConfig("user");
		$this->smarty->assign(array(
			"data"=>$data,
			"user_auth_list"=>$this->config_item('user_auth_list'),
		));
		$this->smarty->display("user/auth.html");
		
	}
	
	public function onAuthSave(){
		$userid=$this->userid;
		$data["user_card"]=get_post("user_card","h");
		$data["truename"]=get_post("truename","h");		
		$data["telephone"]=get_post("telephone","h");
		$data["true_user_head"]=get_post("true_user_head","h");
		$data['is_auth']=3;
		if($userid){
			$this->user->update($data,array('userid'=>$userid));
		}
	
		$this->gomsg("保存成功，请等待审核"); 
	}
	
	public function onPassword(){
		$user=$this->login->getUser();
		if(empty($user)){
			$this->gomsg("请先绑定账号","/index.php?m=register&a=openreg");
		}
		$this->smarty->display("user/password.html");
	}
	
	public function onPasswordSave(){
		$oldpassword=post('oldpassword','h');
		$user=$this->user->selectRow(array("where"=>"userid=".$this->userid));
		if($user['password']!=umd5($oldpassword.$user['salt'])){
			$this->gomsg("旧密码出错");
		}
		if(post('password')!=post('password2')){
			$this->gomsg("两次输入的密码不一致");
		}
		$data['salt']=rand(1000,9999);
		$data['password']=umd5(post('password','h').$data['salt']);
		$this->user->update($data,"userid=".$user['userid']);
		$this->gomsg("密码修改成功");
	}
	
	public function onSafe(){
		$this->smarty->display("user/safe.html");
	}
	
	public function onBindMobile(){
		switch(get_post('op')){
			case 'send':
					$this->loadmodel("email");
					if($this->email->sendSms(post('telephone'),"而此时","xxasd")){
						$this->gomsg("请查收短信",R("/index.php?m=user&a=safe"));
					}else{
						$this->gomsg("短信发送失败");
					}
				break;
			case 'auth':
			
				break;
			default:
				
				$this->smarty->display("user/bindmobile.html");
				break;
		}
	}
	
	public function onBindEmail(){
		switch(get_post('op')){
			case 'send':
					$this->loadmodel("email");
					if($this->email->sendEmail(post('email'),"而此时","xxasd")){
						$this->gomsg("请接收邮件",R("/index.php?m=user&a=safe"));
					}else{
						$this->gomsg("邮件发送失败");
					}
				break;
			case 'auth':
			
				break;
			default:
				
				$this->smarty->display("user/bindemail.html");
				break;
		}
		
	}
	

}

?>