<?php
class categoryModel extends model{
	public $base;
	function __construct(&$base){
		parent::__construct($base);
		$this->base=$base;
		$this->table="category";
	}
	
	public function wei_list(){
		return $this->id_children(6);
	}
	
	public function do_list(){
		return $this->id_children(7);
	}
	
	public function id_children($pid){
		$pid=intval($pid);
		$c=$this->select(array("where"=>"  pid=".$pid." AND status=1 ","fields"=>"cname,id","limit"=>100));	
		if($c){
			foreach($c as $v){
				$data[$v['id']]=$v['cname'];
			}
		}
		return $data;
	}
	
	public function cat_list($where=""){
		$c=$this->select(array("where"=>$where,"fields"=>"cname,id","limit"=>100));	
		if($c){
			foreach($c as $v){
				$data[$v['id']]=$v['cname'];
			}
		}
		return $data;
	}
	
	public function cat_nav($pid=0){
		$cache_key="category_cat_nav";
		if($d=$this->base->cache->get($cache_key)) return $d;
		$data=$this->select(array("where"=>array("pid"=>intval($pid),"status"=>1,"is_tag"=>1),"order"=>"orderindex asc"));
		if(!empty($data)){
			foreach($data as $k=>$v){
				$data[$k]['child']=$this->select(array("where"=>array("pid"=>$v['id'],"status"=>1,"is_tag"=>1),"order"=>"orderindex asc"));
				
			}
		}
		$this->base->cache->set($cache_key,$data,60);
		return $data;
	}
	
	public function tag_nav($catid){
		$cache_key="category_tag_nav_$catid";
		if($d=$this->base->cache->get($cache_key)) return $d;
		$catid=intval($catid);
		$data=$this->selectRow(array("where"=>"id=$catid"));
		if(empty($data)) return false;
		if($data['pid']) $data=$this->selectRow(array("where"=>"id=".$data['pid']));
		if($data['pid']) $data=$this->selectRow(array("where"=>"id=".$data['pid']));
		$child=$this->select(array("where"=>array("pid"=>$data['id'],"status"=>1),"order"=>"orderindex asc"));
		if($child){
			foreach($child as $kk=>$vv){
				$vv['child']=$this->select(array("where"=>array("pid"=>$vv['id'],"status"=>1),"order"=>"orderindex asc"));
				$vv['tags']=explode("\n",str_replace("\r\n","\n",str_replace(" ","",trim($vv['tags']))));
				$child[$kk]=$vv;	
			}
		}
		$data['child']=$child;
		$this->base->cache->set($cache_key,$data,60);
		return $data;
		
	}
	
	public function id_byids($ids){
		if(empty($ids)) return false;
		$data=$this->select(array("where"=>" id in("._implode($ids).")"));
		if($data){
			foreach($data as $k=>$v){
				$t_c[$v['id']]=$v;
			}
			return $t_c;
		}
	}
	
	public function id_family($id=0){
		$id=intval($id);
		$ids[]=$id;
		$ids1=$this->selectCols(array("where"=>" pid=".$id." ","fields"=>"id"));
		if($ids1){
			$ids=array_merge($ids,$ids1);
			$ids2=$this->selectCols(array("where"=>" pid in("._implode($ids1).") ","fields"=>"id"));
			if($ids2){
				$ids=array_merge($ids,$ids2);
				$ids3=$this->selectCols(array("where"=>" pid in("._implode($ids2).") ","fields"=>"id"));
				if($ids3){
					$ids=array_merge($ids,$ids3);
				}
			}
		}
		return $ids;
		
	}
	
}
?>