<?php

/**
 *      [Discuz!] (C)2001-2099 Comsenz Inc.
 *      This is NOT a freeware, use is subject to license terms
 *
 *      $Id: wechat.lib.class.php 36284 2016-12-12 00:47:50Z nemohou $
 */
if (!defined('IN_DISCUZ')) {
	exit('Access Denied');
}

class WeChatServer {

	private $_token;

	private $_hooks;
	private $_classes;

	public function __construct($token, $hooks = array()) {
		$this->_token = $token;
		$this->_hooks = $hooks;
		$this->accessDataPush();
	}

	private function _activeHook($type) {
		if (!isset($this->_hooks[$type])) {
			return null;
		}
		$hook = & $this->_hooks[$type];
		global $_G;
		if (!in_array($hook['plugin'], $_G['setting']['plugins']['available'])) {
			return null;
		}
		if (!preg_match("/^[\w\_]+$/i", $hook['plugin']) || !preg_match('/^[\w\_\.]+\.php$/i', $hook['include'])) {
			return null;
		}
		include_once DISCUZ_ROOT . 'source/plugin/' . $hook['plugin'] . '/' . $hook['include'];
		if (!class_exists($hook['class'], false)) {
			return null;
		}
		if (!isset($this->classes[$hook['class']])) {
			$this->classes[$hook['class']] = new $hook['class'];
		}
		if (!method_exists($this->classes[$hook['class']], $hook['method'])) {
			return null;
		}
		$param = func_get_args();
		array_shift($param);
		return call_user_func(array($this->classes[$hook['class']], $hook['method']), $param);
	}

	private function _checkSignature() {
		$signature = $_GET["signature"];
		$timestamp = $_GET["timestamp"];
		$nonce = $_GET["nonce"];

		$token = $this->_token;
		$tmpArr = array($token, $timestamp, $nonce);
		sort($tmpArr, SORT_STRING);
		$tmpStr = implode($tmpArr);
		$tmpStr = sha1($tmpStr);

		return $tmpStr == $signature;
	}

	private function _handlePostObj($postObj) {
		$MsgType = strtolower((string) $postObj->MsgType);
		$result = array(
		    'from' => self::$_from_id = (string) htmlspecialchars($postObj->FromUserName),
		    'to' => self::$_my_id = (string) htmlspecialchars($postObj->ToUserName),
		    'time' => (int) $postObj->CreateTime,
		    'type' => (string) $MsgType
		);

		if (property_exists($postObj, 'MsgId')) {
			$result['id'] = $postObj->MsgId;
		}

		switch ($result['type']) {
			case 'text':
				$result['content'] = (string) $postObj->Content; // Content Ϣ
				break;

			case 'location':
				$result['X'] = (float) $postObj->Location_X; // Location_X λγ
				$result['Y'] = (float) $postObj->Location_Y; // Location_Y λþ
				$result['S'] = (float) $postObj->Scale;      // Scale ͼŴС
				$result['I'] = (string) $postObj->Label;     // Label λϢ
				break;

			case 'image':
				$result['url'] = (string) $postObj->PicUrl;  // PicUrl ͼƬӣ߿HTTP GETȡ
				$result['mid'] = (string) $postObj->MediaId; // MediaId ͼƬϢýidԵöýļؽӿȡݡ
				break;

			case 'video':
				$result['mid'] = (string) $postObj->MediaId;      // MediaId ͼƬϢýidԵöýļؽӿȡݡ
				$result['thumbmid'] = (string) $postObj->ThumbMediaId; // ThumbMediaId ƵϢͼýidԵöýļؽӿȡݡ
				break;

			case 'link':
				$result['title'] = (string) $postObj->Title;
				$result['desc'] = (string) $postObj->Description;
				$result['url'] = (string) $postObj->Url;
				break;

			case 'voice':
				$result['mid'] = (string) $postObj->MediaId;
				$result['format'] = (string) $postObj->Format;
				if (property_exists($postObj, Recognition)) {
					$result['txt'] = (string) $postObj->Recognition;
				}
				break;

			case 'event':
				$result['event'] = strtolower((string) $postObj->Event);
				switch ($result['event']) {

					case 'subscribe':
					case 'scan':
						if (property_exists($postObj, EventKey)) {
							$result['key'] = str_replace(
								'qrscene_', '', (string) $postObj->EventKey
							);
							$result['ticket'] = (string) $postObj->Ticket;
						}
						break;

					case 'location':
						$result['la'] = (string) $postObj->Latitude;
						$result['lo'] = (string) $postObj->Longitude;
						$result['p'] = (string) $postObj->Precision;
						break;

					case 'click':
						$result['key'] = (string) $postObj->EventKey;
						break;
					case 'masssendjobfinish':
						$result['msg_id'] = (string) $postObj->MsgID;
						$result['status'] = (string) $postObj->Status;
						$result['totalcount'] = (string) $postObj->TotalCount;
						$result['filtercount'] = (string) $postObj->FilterCount;
						$result['sentcount'] = (string) $postObj->SentCount;
						$result['errorcount'] = (string) $postObj->ErrorCount;
				}
		}

		return $result;
	}

	private function accessDataPush() {
		if (!$this->_checkSignature()) {
			if (!headers_sent()) {
				header('HTTP/1.1 404 Not Found');
				header('Status: 404 Not Found');
			}
			$this->_activeHook('404');
			return;
		}

		$postdata = file_get_contents("php://input");
		if ($postdata) {
			if (!$this->_checkSignature()) {
				return;
			}
			$postObj = simplexml_load_string($postdata, 'SimpleXMLElement', LIBXML_NOCDATA);
			$postObj = $this->_handlePostObj($postObj);

			$this->_activeHook('receiveAllStart', $postObj);

			if (isset($postObj['event'])) {
				$hookName = 'receiveEvent::' . $postObj['event'];
			} else {
				$hookName = 'receiveMsg::' . $postObj['type'];
			}
			$this->_activeHook($hookName, $postObj);

			$this->_activeHook('receiveAllEnd', $postObj);
		} elseif (isset($_GET['echostr'])) {

			$this->_activeHook('accessCheckSuccess');
			if (!headers_sent()) {
				header('Content-Type: text/plain');
			}
			echo preg_replace('/[^a-z0-9]/i', '', $_GET['echostr']);
		}
	}

	private static $_from_id;
	private static $_my_id;

	private static function _format2xml($nodes) {
		$xml = '<xml>'
			. '<ToUserName><![CDATA[%s]]></ToUserName>'
			. '<FromUserName><![CDATA[%s]]></FromUserName>'
			. '<CreateTime>%s</CreateTime>'
			. '%s'
			. '</xml>';
		$return = sprintf(
			$xml, self::$_from_id, self::$_my_id, time(), $nodes
		);
		return diconv($return, CHARSET, 'UTF-8');
	}

	public static function getXml4Txt($txt) {
		$xml = '<MsgType><![CDATA[text]]></MsgType>'
			. '<Content><![CDATA[%s]]></Content>';
		return self::_format2xml(
				sprintf(
					$xml, $txt
				)
		);
	}

	public static function getXml4ImgByMid($mid) {
		$xml = '<MsgType><![CDATA[image]]></MsgType>'
			. '<Image>'
			. '<MediaId><![CDATA[%s]]></MediaId>'
			. '</Image>';
		return self::_format2xml(
				sprintf(
					$xml, $mid
				)
		);
	}

	public static function getXml4VoiceByMid($mid) {
		$xml = '<MsgType><![CDATA[voice]]></MsgType>'
			. '<Voice>'
			. '<MediaId><![CDATA[%s]]></MediaId>'
			. '</Voice>';
		return self::_format2xml(
				sprintf(
					$xml, $mid
				)
		);
	}

	public static function getXml4VideoByMid($mid, $title, $desc = '') {
		$desc = '' !== $desc ? $desc : $title;
		$xml = '<MsgType><![CDATA[video]]></MsgType>'
			. '<Video>'
			. '<MediaId><![CDATA[%s]]></MediaId>'
			. '<Title><![CDATA[%s]]></Title>'
			. '<Description><![CDATA[%s]]></Description>'
			. '</Video>';

		return self::_format2xml(
				sprintf(
					$xml, $mid, $title, $desc
				)
		);
	}

	public static function getXml4MusicByUrl($url, $thumbmid, $title, $desc = '', $hqurl = '') {
		$xml = '<MsgType><![CDATA[music]]></MsgType>'
			. '<Music>'
			. '<Title><![CDATA[%s]]></Title>'
			. '<Description><![CDATA[%s]]></Description>'
			. '<MusicUrl><![CDATA[%s]]></MusicUrl>'
			. '<HQMusicUrl><![CDATA[%s]]></HQMusicUrl>'
			. '<ThumbMediaId><![CDATA[%s]]></ThumbMediaId>'
			. '</Music>';

		return self::_format2xml(
				sprintf(
					$xml, $title, '' === $desc ? $title : $desc, $url, $hqurl ? $hqurl : $url, $thumbmid
				)
		);
	}

	public static function getXml4RichMsgByArray($list) {
		$max = 10;
		$i = 0;
		$ii = count($list);
		$list_xml = '';
		while ($i < $ii && $i < $max) {
			$item = $list[$i++];
			$list_xml .=
				sprintf(
				'<item>'
				. '<Title><![CDATA[%s]]></Title> '
				. '<Description><![CDATA[%s]]></Description>'
				. '<PicUrl><![CDATA[%s]]></PicUrl>'
				. '<Url><![CDATA[%s]]></Url>'
				. '</item>', $item['title'], $item['desc'], $item['pic'], $item['url']
			);
		}

		$xml = '<MsgType><![CDATA[news]]></MsgType>'
			. '<ArticleCount>%s</ArticleCount>'
			. '<Articles>%s</Articles>';

		return self::_format2xml(
				sprintf(
					$xml, $i, $list_xml
				)
		);
	}

}

class WeChatClient {

	public static $_URL_API_ROOT = 'https://api.weixin.qq.com';
	public static $_URL_FILE_API_ROOT = 'http://file.api.weixin.qq.com';
	public static $_URL_QR_ROOT = 'https://mp.weixin.qq.com';
	public static $_QRCODE_TICKET_DEFAULT_ID = 1;
	public static $ERRCODE_MAP = array(
	    '-1' => '&#x7CFB;&#x7EDF;&#x7E41;&#x5FD9;',
	    '0' => '&#x8BF7;&#x6C42;&#x6210;&#x529F;',
	    '40001' => '&#x83B7;&#x53D6;access_token&#x65F6;AppSecret&#x9519;&#x8BEF;&#xFF0C;&#x6216;&#x8005;access_token&#x65E0;&#x6548;',
	    '40002' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x51ED;&#x8BC1;&#x7C7B;&#x578B;',
	    '40003' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;OpenID',
	    '40004' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5A92;&#x4F53;&#x6587;&#x4EF6;&#x7C7B;&#x578B;',
	    '40005' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6587;&#x4EF6;&#x7C7B;&#x578B;',
	    '40006' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6587;&#x4EF6;&#x5927;&#x5C0F;',
	    '40007' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5A92;&#x4F53;&#x6587;&#x4EF6;id',
	    '40008' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6D88;&#x606F;&#x7C7B;&#x578B;',
	    '40009' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x56FE;&#x7247;&#x6587;&#x4EF6;&#x5927;&#x5C0F;',
	    '40010' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x8BED;&#x97F3;&#x6587;&#x4EF6;&#x5927;&#x5C0F;',
	    '40011' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x89C6;&#x9891;&#x6587;&#x4EF6;&#x5927;&#x5C0F;',
	    '40012' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x7F29;&#x7565;&#x56FE;&#x6587;&#x4EF6;&#x5927;&#x5C0F;',
	    '40013' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;APPID',
	    '40014' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;access_token',
	    '40015' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x83DC;&#x5355;&#x7C7B;&#x578B;',
	    '40016' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6309;&#x94AE;&#x4E2A;&#x6570;',
	    '40017' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6309;&#x94AE;&#x4E2A;&#x6570;',
	    '40018' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6309;&#x94AE;&#x540D;&#x5B57;&#x957F;&#x5EA6;',
	    '40019' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6309;&#x94AE;KEY&#x957F;&#x5EA6;',
	    '40020' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x6309;&#x94AE;URL&#x957F;&#x5EA6;',
	    '40021' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x83DC;&#x5355;&#x7248;&#x672C;&#x53F7;',
	    '40022' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x7EA7;&#x6570;',
	    '40023' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x6309;&#x94AE;&#x4E2A;&#x6570;',
	    '40024' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x6309;&#x94AE;&#x7C7B;&#x578B;',
	    '40025' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x6309;&#x94AE;&#x540D;&#x5B57;&#x957F;&#x5EA6;',
	    '40026' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x6309;&#x94AE;KEY&#x957F;&#x5EA6;',
	    '40027' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5B50;&#x83DC;&#x5355;&#x6309;&#x94AE;URL&#x957F;&#x5EA6;',
	    '40028' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x81EA;&#x5B9A;&#x4E49;&#x83DC;&#x5355;&#x4F7F;&#x7528;&#x7528;&#x6237;',
	    '40029' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;oauth_code',
	    '40030' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;refresh_token',
	    '40031' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;openid&#x5217;&#x8868;',
	    '40032' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;openid&#x5217;&#x8868;&#x957F;&#x5EA6;',
	    '40033' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x8BF7;&#x6C42;&#x5B57;&#x7B26;&#xFF0C;&#x4E0D;&#x80FD;&#x5305;&#x542B;\uxxxx&#x683C;&#x5F0F;&#x7684;&#x5B57;&#x7B26;',
	    '40035' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x53C2;&#x6570;',
	    '40038' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x8BF7;&#x6C42;&#x683C;&#x5F0F;',
	    '40039' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;URL&#x957F;&#x5EA6;',
	    '40050' => '&#x4E0D;&#x5408;&#x6CD5;&#x7684;&#x5206;&#x7EC4;id',
	    '40051' => '&#x5206;&#x7EC4;&#x540D;&#x5B57;&#x4E0D;&#x5408;&#x6CD5;',
	    '41001' => '&#x7F3A;&#x5C11;access_token&#x53C2;&#x6570;',
	    '41002' => '&#x7F3A;&#x5C11;appid&#x53C2;&#x6570;',
	    '41003' => '&#x7F3A;&#x5C11;refresh_token&#x53C2;&#x6570;',
	    '41004' => '&#x7F3A;&#x5C11;secret&#x53C2;&#x6570;',
	    '41005' => '&#x7F3A;&#x5C11;&#x591A;&#x5A92;&#x4F53;&#x6587;&#x4EF6;&#x6570;&#x636E;',
	    '41006' => '&#x7F3A;&#x5C11;media_id&#x53C2;&#x6570;',
	    '41007' => '&#x7F3A;&#x5C11;&#x5B50;&#x83DC;&#x5355;&#x6570;&#x636E;',
	    '41008' => '&#x7F3A;&#x5C11;oauth code',
	    '41009' => '&#x7F3A;&#x5C11;openid',
	    '42001' => 'access_token&#x8D85;&#x65F6;',
	    '42002' => 'refresh_token&#x8D85;&#x65F6;',
	    '42003' => 'oauth_code&#x8D85;&#x65F6;',
	    '43001' => '&#x9700;&#x8981;GET&#x8BF7;&#x6C42;',
	    '43002' => '&#x9700;&#x8981;POST&#x8BF7;&#x6C42;',
	    '43003' => '&#x9700;&#x8981;HTTPS&#x8BF7;&#x6C42;',
	    '43004' => '&#x9700;&#x8981;&#x63A5;&#x6536;&#x8005;&#x5173;&#x6CE8;',
	    '43005' => '&#x9700;&#x8981;&#x597D;&#x53CB;&#x5173;&#x7CFB;',
	    '44001' => '&#x591A;&#x5A92;&#x4F53;&#x6587;&#x4EF6;&#x4E3A;&#x7A7A;',
	    '44002' => 'POST&#x7684;&#x6570;&#x636E;&#x5305;&#x4E3A;&#x7A7A;',
	    '44003' => '&#x56FE;&#x6587;&#x6D88;&#x606F;&#x5185;&#x5BB9;&#x4E3A;&#x7A7A;',
	    '44004' => '&#x6587;&#x672C;&#x6D88;&#x606F;&#x5185;&#x5BB9;&#x4E3A;&#x7A7A;',
	    '45001' => '&#x591A;&#x5A92;&#x4F53;&#x6587;&#x4EF6;&#x5927;&#x5C0F;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45002' => '&#x6D88;&#x606F;&#x5185;&#x5BB9;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45003' => '&#x6807;&#x9898;&#x5B57;&#x6BB5;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45004' => '&#x63CF;&#x8FF0;&#x5B57;&#x6BB5;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45005' => '&#x94FE;&#x63A5;&#x5B57;&#x6BB5;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45006' => '&#x56FE;&#x7247;&#x94FE;&#x63A5;&#x5B57;&#x6BB5;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45007' => '&#x8BED;&#x97F3;&#x64AD;&#x653E;&#x65F6;&#x95F4;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45008' => '&#x56FE;&#x6587;&#x6D88;&#x606F;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45009' => '&#x63A5;&#x53E3;&#x8C03;&#x7528;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45010' => '&#x521B;&#x5EFA;&#x83DC;&#x5355;&#x4E2A;&#x6570;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45015' => '&#x56DE;&#x590D;&#x65F6;&#x95F4;&#x8D85;&#x8FC7;&#x9650;&#x5236;',
	    '45016' => '&#x7CFB;&#x7EDF;&#x5206;&#x7EC4;&#xFF0C;&#x4E0D;&#x5141;&#x8BB8;&#x4FEE;&#x6539;',
	    '45017' => '&#x5206;&#x7EC4;&#x540D;&#x5B57;&#x8FC7;&#x957F;',
	    '45018' => '&#x5206;&#x7EC4;&#x6570;&#x91CF;&#x8D85;&#x8FC7;&#x4E0A;&#x9650;',
	    '46001' => '&#x4E0D;&#x5B58;&#x5728;&#x5A92;&#x4F53;&#x6570;&#x636E;',
	    '46002' => '&#x4E0D;&#x5B58;&#x5728;&#x7684;&#x83DC;&#x5355;&#x7248;&#x672C;',
	    '46003' => '&#x4E0D;&#x5B58;&#x5728;&#x7684;&#x83DC;&#x5355;&#x6570;&#x636E;',
	    '46004' => '&#x4E0D;&#x5B58;&#x5728;&#x7684;&#x7528;&#x6237;',
	    '47001' => '&#x89E3;&#x6790;JSON/XML&#x5185;&#x5BB9;&#x9519;&#x8BEF;',
	    '48001' => 'api&#x529F;&#x80FD;&#x672A;&#x6388;&#x6743;',
	    '50001' => '&#x7528;&#x6237;&#x672A;&#x6388;&#x6743;&#x8BE5;api',
	);
	public static $_USERINFO_LANG = 'en';
	private $_appid;
	private $_appsecret;
	private static $_accessTokenCache = array();
	private static $ERROR_LOGS = array();
	private static $ERROR_NO = 0;

	public function __construct($appid, $appsecret = '') {
		if ($appsecret) {
			$this->_appid = $appid;
			$this->_appsecret = $appsecret;
		} else {
			$info = WeChatHook::getAppInfo($appid);
			$this->_appid = $info['appId'];
			$this->_appsecret = $info['appSecret'];
		}
	}

	public static function error() {
		return self::$ERRCODE_MAP[self::$ERROR_NO] ? self::$ERRCODE_MAP[self::$ERROR_NO] : self::$ERROR_NO;
	}

	public static function checkIsSuc($res) {
		$result = true;
		if (is_string($res)) {
			$res = json_decode($res, true);
		}
		if (isset($res['errcode']) && ( 0 !== (int) $res['errcode'])) {
			array_push(self::$ERROR_LOGS, $res);
			$result = false;
			self::$ERROR_NO = $res['errcode'];
		}
		return $result;
	}

	public static function get($url) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		# curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

		if (!curl_exec($ch)) {
			error_log(curl_error($ch));
			$data = '';
		} else {
			$data = curl_multi_getcontent($ch);
		}
		curl_close($ch);
		return $data;
	}

	private static function post($url, $data) {
		if (!function_exists('curl_init')) {
			return '';
		}
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		# curl_setopt( $ch, CURLOPT_HEADER, 1);

		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);

		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		$data = curl_exec($ch);
		if (!$data) {
			error_log(curl_error($ch));
		}
		curl_close($ch);
		return $data;
	}

	public function getAccessToken($tokenOnly = 1, $nocache = 0) {
		global $_G;
		$myTokenInfo = null;
		$appid = $this->_appid;
		$appsecret = $this->_appsecret;
		$cachename = 'wechatat_' . $appid;
		loadcache($cachename);

		if ($nocache || empty(self::$_accessTokenCache[$appid])) {
			self::$_accessTokenCache[$appid] = $_G['cache'][$cachename];
		}

		if (!empty(self::$_accessTokenCache[$appid])) {
			$myTokenInfo = self::$_accessTokenCache[$appid];
			if (time() < $myTokenInfo['expiration']) {
				return $tokenOnly ? $myTokenInfo['token'] : $myTokenInfo;
			}
		}

		$url = self::$_URL_API_ROOT . "/cgi-bin/token?grant_type=client_credential&appid=$appid&secret=$appsecret";

		$json = self::get($url);
		$res = json_decode($json, true);

		if (self::checkIsSuc($res)) {
			self::$_accessTokenCache[$appid] = $myTokenInfo = array(
			    'token' => $res['access_token'],
			    'expiration' => time() + (int) $res['expires_in']
			);
			savecache($cachename, $myTokenInfo);
		}
		return $tokenOnly ? $myTokenInfo['token'] : $myTokenInfo;
	}

	public function setAccessToken($tokenInfo) {
		if ($tokenInfo) {
			$appid = $this->_appid;
			self::$_accessTokenCache[$appid] = array(
			    'token' => $tokenInfo['token'],
			    'expire' => $tokenInfo['expire']
			);
		}
	}

	public function upload($type, $file_path, $mediaidOnly = 1) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_FILE_API_ROOT . "/cgi-bin/media/upload?access_token=$access_token&type=$type";

		$res = self::post($url, array('media' => "@$file_path"));
		$res = json_decode($res, true);

		if (self::checkIsSuc($res)) {
			return $mediaidOnly ? $res['media_id'] : $res;
		}
		return null;
	}

	public function download($mid) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_FILE_API_ROOT . "/cgi-bin/media/get?access_token=$access_token&media_id=$mid";

		return self::get($url);
	}

	public function getMenu() {

		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/menu/get?access_token=$access_token";

		$json = self::get($url);

		$res = json_decode($json, true);
		if (self::checkIsSuc($res)) {
			return $res;
		}
		return null;
	}

	public function deleteMenu() {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/menu/delete?access_token=$access_token";

		$res = self::get($url);
		return self::checkIsSuc($res);
	}

	public function setMenu($myMenu) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/menu/create?access_token=$access_token";

		if (defined('JSON_UNESCAPED_UNICODE')) {
			$json = is_string($myMenu) ? $myMenu : json_encode($myMenu, JSON_UNESCAPED_UNICODE);
		} else {
			$json = is_string($myMenu) ? $myMenu : json_encode($myMenu);
		}

		$json = urldecode($json);
		$res = self::post($url, $json);

		return self::checkIsSuc($res);
	}

	private function _send($to, $type, $data) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/message/custom/send?access_token=$access_token";

		$json = json_encode(
			array(
			    'touser' => $to,
			    'msgtype' => $type,
			    $type => $data
			)
		);

		$res = self::post($url, $json);

		return self::checkIsSuc($res);
	}

	public function sendTextMsg($to, $msg) {
		return $this->_send($to, 'text', array('content' => $msg));
	}

	public function sendImgMsg($to, $mid) {
		return $this->_send($to, 'image', array('media_id' => $mid));
	}

	public function sendVoice($to, $mid) {
		return $this->_send($to, 'voice', array('media_id' => $mid));
	}

	public function sendVideo($to, $mid, $title, $desc) {
		return $this->_send($to, 'video', array(
			    'media_id' => $mid,
			    'title' => $title,
			    'description' => $desc
		));
	}

	public function sendMusic($to, $url, $thumb_mid, $title, $desc = '', $hq_url = '') {
		return $this->_send($to, 'music', array(
			    'media_id' => $mid,
			    'title' => $title,
			    'description' => $desc || $title,
			    'musicurl' => $url,
			    'thumb_media_id' => $thumb_mid,
			    'hqmusicurl' => $hq_url || $url
		));
	}

	static private function _filterForRichMsg($articles) {
		$i = 0;
		$ii = len($articles);
		$list = array('title', 'desc', 'url', 'thumb_url');
		$result = array();
		while ($i < $ii) {
			$currentArticle = $articles[$i++];
			try {
				array_push($result, array(
				    'title' => $currentArticle['title'],
				    'description' => $currentArticle['desc'],
				    'url' => $currentArticle['url'],
				    'picurl' => $currentArticle['thumb_url']
				));
			} catch (Exception $e) {

			}
		}
		return $result;
	}

	public function uploadNews($articles) {
		$i = 0;
		$ii = count($articles);
		$result = array();
		while ($i < $ii) {
			$currentArticle = $articles[$i++];
			try {
				array_push($result, array(
				    'thumb_media_id' => $currentArticle['thumb_media_id'],
				    'title' => $this->convertToUtf($currentArticle['title']),
				    'content' => $this->convertToUtf($currentArticle['content']),
				    'author' => $this->convertToUtf($currentArticle['author']),
				    'content_source_url' => $this->convertToUtf($currentArticle['url']),
				    'digest' => $this->convertToUtf($currentArticle['desc']),
				    'show_cover_pic' => 1
				));
			} catch (Exception $e) {

			}
		}

		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/media/uploadnews?access_token=$access_token";
		if (defined('JSON_UNESCAPED_UNICODE')) {
			$json = json_encode(array('articles' => $result), JSON_UNESCAPED_UNICODE);
		} else {
			$json = json_encode(array('articles' => $result));
		}

		$json = urldecode($json);

		$res = self::post($url, $json);
		if (self::checkIsSuc($res)) {
			return json_decode($res, true);
		} else {
			return false;
		}
	}

	public function sendMassMsg($msg) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/message/mass/sendall?access_token=$access_token";
		$post = array();
		$post['filter'] = array('group_id' => $msg['group_id']);
		if ($msg['type'] == 'media') {
			$post['mpnews'] = array('media_id' => $msg['media_id']);
			$post['msgtype'] = 'mpnews';
		} else {
			$post['text'] = array('content' => $this->convertToUtf($msg['text']));
			$post['msgtype'] = 'text';
		}

		if (defined('JSON_UNESCAPED_UNICODE')) {
			$json = json_encode($post, JSON_UNESCAPED_UNICODE);
		} else {
			$json = json_encode($post);
		}

		$json = urldecode($json);

		$res = self::post($url, $json);
		if (self::checkIsSuc($res)) {
			return json_decode($res, true);
		} else {
			return false;
		}
	}

	function convertToUtf($str) {
		return urlencode(diconv($str, CHARSET, 'UTF-8'));
	}

	public function sendRichMsg($to, $articles) {

		return $this->_send($to, 'news', array(
			    'articles' => self::_filterForRichMsg($articles)
		));
	}

	public function createGroup($name) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/groups/create?access_token=$access_token";

		$res = self::post($url, json_encode(array(
			    'group' => array('name' => $name)
		)));

		$res = json_decode($res, true);
		return self::checkIsSuc($res) ? $res['group']['id'] : null;
	}

	public function renameGroup($gid, $name) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/groups/update?access_token=$access_token";

		$res = self::post($url, json_encode(array(
			    'group' => array(
				'id' => $gid,
				'name' => $name
			    )
		)));

		$res = json_decode($res, true);
		return self::checkIsSuc($res);
	}

	public function moveUserById($uid, $gid) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/groups/members/update?access_token=$access_token";

		$res = self::post(
				$url, json_encode(
					array(
					    'openid' => $mid,
					    'to_groupid' => $gid
					)
				)
		);

		$res = json_decode($res, true);
		return self::checkIsSuc($res);
	}

	public function getAllGroups() {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/groups/get?access_token=$access_token";

		$res = json_decode(self::get($url), true);

		if (self::checkIsSuc($res)) {
			return $res['groups'];
		} else {
			return null;
		}
	}

	public function getGroupidByUserid($uid) {
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/groups/getid?access_token=$access_token";

		$res = self::post($url, json_encode(array(
			    'openid' => $mid
		)));

		$res = json_decode($res, true);
		return self::checkIsSuc($res) ? $res['groupid'] : null;
	}

	public function getUserInfoById($uid, $lang = '') {
		if (!$lang) {
			$lang = self::$_USERINFO_LANG;
		}
		$access_token = $this->getAccessToken();
		$url = self::$_URL_API_ROOT . "/cgi-bin/user/info?access_token=$access_token&openid=$uid&lang=$lang";

		$res = json_decode(self::get($url), true);

		return self::checkIsSuc($res) ? $res : null;
	}

	public function getFollowersList($next_id = '') {
		$access_token = $this->getAccessToken();
		$extend = '';
		if ($next_id) {
			$extend = "&next_openid=$next_id";
		}
		$url = self::$_URL_API_ROOT . "/cgi-bin/user/get?access_token=${access_token}$extend";

		$res = json_decode(
			self::get($url), true
		);

		return self::checkIsSuc($res) ? array(
		    'total' => $res['total'],
		    'list' => $res['data']['openid'],
		    'next_id' => isset($res['next_openid']) ? $res['next_openid'] : null
			) : null;
	}

	public function getOAuthConnectUri($redirect_uri, $state = '', $scope = 'snsapi_base') {
		$redirect_uri = urlencode($redirect_uri);
		$url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid={$this->_appid}&redirect_uri={$redirect_uri}&response_type=code&scope={$scope}&state={$state}#wechat_redirect";
		return $url;
	}

	public function getAccessTokenByCode($code) {
		$url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={$this->_appid}&secret={$this->_appsecret}&code=$code&grant_type=authorization_code";
		$res = json_decode(self::get($url), true);
		return $res;
	}

	public function refreshAccessTocken($refresh_token) {
		$url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid={$this->_appid}&grant_type=refresh_token&refresh_token=$refresh_token";
		$res = json_decode(self::get($url), true);
		return $res;
	}

	public function getUserInfoByAuth($access_token, $openid, $lang = 'zh_CN') {
		$url = "https://api.weixin.qq.com/sns/userinfo?access_token=$access_token&openid=$openid&lang=$lang";
		$res = json_decode(self::get($url), true);
		return $res;
	}

	public static function getQrcodeImgByTicket($ticket) {
		return self::get($this->getQrcodeImgUrlByTicket($ticket));
	}

	public static function getQrcodeImgUrlByTicket($ticket) {
		$ticket = urlencode($ticket);
		return self::$_URL_QR_ROOT . "/cgi-bin/showqrcode?ticket=$ticket";
	}

	public function getQrcodeTicket($options = array()) {
		$access_token = $this->getAccessToken();

		$scene_id = isset($options['scene_id']) ? (int) $options['scene_id'] : 0;
		$expire = isset($options['expire']) ? (int) $options['expire'] : 0;
		$ticketOnly = isset($options['ticketOnly']) ? $options['ticketOnly'] : 1;

		$url = self::$_URL_API_ROOT . "/cgi-bin/qrcode/create?access_token=$access_token";
		$data = array(
		    'action_name' => 'QR_LIMIT_SCENE',
		    'action_info' => array(
			'scene' => array(
			    'scene_id' => $scene_id
			)
		    )
		);
		if ($expire) {
			$data['expire_seconds'] = $expire;
			$data['action_name'] = 'QR_SCENE';
		}

		if ($data['action_name'] == 'QR_LIMIT_SCENE' && $scene_id > 100000) {
			$data['action_info']['scene']['scene_id'] = self::$_QRCODE_TICKET_DEFAULT_ID;
		}

		$data = json_encode($data);

		$res = self::post($url, $data);
		$res = json_decode($res, true);

		if (self::checkIsSuc($res)) {
			return $ticketOnly ? $res['ticket'] : array(
			    'ticket' => $res['ticket'],
			    'expire' => $res['expire_seconds']
			);
		}
		return null;
	}

}

class WeChatEmoji {

	public static function clear($str) {
		$config = self::getList();
		$str = str_replace($config, '', $str);
		return diconv($str, 'UTF-8', CHARSET);
	}

	public static function getList() {
		return array(
		    "\xee\x98\xbe", "\xee\x98\xbf", "\xee\x99\x80", "\xee\x99\x81", "\xee\x99\x82", "\xee\x99\x83", "\xee\x99\x84", "\xee\x99\x85", "\xee\x9a\xb3", "[\xe5\xa4\x95\xe7\x84\xbc\xe3\x81\x91]", "[\xe8\x99\xb9]", "[\xe9\x9b\xaa\xe7\xb5\x90\xe6\x99\xb6]", "\xee\x98\xbe\xee\x98\xbf", "\xee\x9c\xbf", "[\xe7\x81\xab\xe5\xb1\xb1]", "[\xe5\x9c\xb0\xe7\x90\x83]", "\xee\x9a\x9c", "\xee\x9a\x9d", "\xee\x9a\x9e", "\xee\x9a\x9f", "\xee\x9a\xa0", "[\xe2\x98\x86]", "\xe2\x98\x86\xe5\xbd\xa1", "\xee\x9a\xba", "\xee\x9c\x9f", "\xee\x9c\x9c", "\xee\x99\x86", "\xee\x99\x87", "\xee\x99\x88", "\xee\x99\x89", "\xee\x99\x8a", "\xee\x99\x8b", "\xee\x99\x8c", "\xee\x99\x8d", "\xee\x99\x8e", "\xee\x99\x8f", "\xee\x99\x90", "\xee\x99\x91", "[\xe8\x9b\x87\xe4\xbd\xbf\xe5\xba\xa7]", "\xee\x9d\x81", "\xee\x9d\x83", "\xee\x9d\x86", "\xee\x9d\x87", "\xee\x9d\x88", "[\xe3\x83\x90\xe3\x83\xa9]", "[\xe9\xa2\xa8\xe3\x81\xab\xe8\x88\x9e\xe3\x81\x86\xe8\x91\x89]", "[\xe3\x83\x8f\xe3\x82\xa4\xe3\x83\x93\xe3\x82\xb9\xe3\x82\xab\xe3\x82\xb9]", "[\xe3\x81\xb2\xe3\x81\xbe\xe3\x82\x8f\xe3\x82\x8a]", "[\xe3\x83\xa4\xe3\x82\xb7]", "[\xe3\x82\xb5\xe3\x83\x9c\xe3\x83\x86\xe3\x83\xb3]", "[\xe7\xa8\xb2\xe7\xa9\x82]", "[\xe3\x81\xa8\xe3\x81\x86\xe3\x82\x82\xe3\x82\x8d\xe3\x81\x93\xe3\x81\x97]", "[\xe3\x82\xad\xe3\x83\x8e\xe3\x82\xb3]", "[\xe6\xa0\x97]", "[\xe8\x8a\xb1]", "\xee\x9d\x82", "\xee\x9d\x84", "\xee\x9d\x85", "[\xe3\x81\xbf\xe3\x81\x8b\xe3\x82\x93]", "[\xe3\x82\xa4\xe3\x83\x81\xe3\x82\xb4]", "[\xe3\x82\xb9\xe3\x82\xa4\xe3\x82\xab]", "[\xe3\x83\x88\xe3\x83\x9e\xe3\x83\x88]", "[\xe3\x83\x8a\xe3\x82\xb9]", "[\xe3\x83\xa1\xe3\x83\xad\xe3\x83\xb3]", "[\xe3\x83\x91\xe3\x82\xa4\xe3\x83\x8a\xe3\x83\x83\xe3\x83\x97\xe3\x83\xab]", "[\xe3\x83\x96\xe3\x83\x89\xe3\x82\xa6]", "[\xe3\x83\xa2\xe3\x83\xa2]", "\xee\x9a\x91", "\xee\x9a\x92", "[\xe9\xbc\xbb]", "\xee\x9b\xb9", "\xee\x9c\xa8", "\xee\x9c\x90", "[\xe3\x83\x9e\xe3\x83\x8b\xe3\x82\xad\xe3\x83\xa5\xe3\x82\xa2]", "[\xe3\x82\xa8\xe3\x82\xb9\xe3\x83\x86]", "\xee\x99\xb5", "[\xe5\xba\x8a\xe5\xb1\x8b]", "\xee\x9a\xb1", "\xee\x9b\xb0", "[\xe5\xae\xb6\xe6\x97\x8f]", "[\xe3\x82\xab\xe3\x83\x83\xe3\x83\x97\xe3\x83\xab]", "[\xe8\xad\xa6\xe5\xae\x98]", "[\xe3\x83\x90\xe3\x83\x8b\xe3\x83\xbc]", "[\xe8\x8a\xb1\xe5\xab\x81]", "[\xe7\x99\xbd\xe4\xba\xba]", "[\xe4\xb8\xad\xe5\x9b\xbd\xe4\xba\xba]", "[\xe3\x82\xa4\xe3\x83\xb3\xe3\x83\x89\xe4\xba\xba]", "[\xe3\x81\x8a\xe3\x81\x98\xe3\x81\x84\xe3\x81\x95\xe3\x82\x93]", "[\xe3\x81\x8a\xe3\x81\xb0\xe3\x81\x82\xe3\x81\x95\xe3\x82\x93]", "[\xe8\xb5\xa4\xe3\x81\xa1\xe3\x82\x83\xe3\x82\x93]", "[\xe5\xb7\xa5\xe4\xba\x8b\xe7\x8f\xbe\xe5\xa0\xb4\xe3\x81\xae\xe4\xba\xba]", "[\xe3\x81\x8a\xe5\xa7\xab\xe6\xa7\x98]", "[\xe3\x81\xaa\xe3\x81\xbe\xe3\x81\xaf\xe3\x81\x92]", "[\xe5\xa4\xa9\xe7\x8b\x97]", "[\xe3\x81\x8a\xe5\x8c\x96\xe3\x81\x91]", "[\xe5\xa4\xa9\xe4\xbd\xbf]", "[UFO]", "[\xe5\xae\x87\xe5\xae\x99\xe4\xba\xba]", "[\xe3\x82\xa2\xe3\x82\xaf\xe3\x83\x9e]", "[\xe3\x83\x89\xe3\x82\xaf\xe3\x83\xad]", "[\xe6\xa1\x88\xe5\x86\x85]", "[\xe8\xa1\x9b\xe5\x85\xb5]", "[\xe3\x83\x80\xe3\x83\xb3\xe3\x82\xb9]", "\xee\x9d\x8e", "[\xe3\x83\x98\xe3\x83\x93]", "\xee\x9d\x94", "[\xe3\x83\x8b\xe3\x83\xaf\xe3\x83\x88\xe3\x83\xaa]", "[\xe3\x82\xa4\xe3\x83\x8e\xe3\x82\xb7\xe3\x82\xb7]", "[\xe3\x83\xa9\xe3\x82\xaf\xe3\x83\x80]", "[\xe3\x82\xbe\xe3\x82\xa6]", "[\xe3\x82\xb3\xe3\x82\xa2\xe3\x83\xa9]", "[\xe3\x82\xb5\xe3\x83\xab]", "[\xe3\x83\x92\xe3\x83\x84\xe3\x82\xb8]", "[\xe3\x82\xbf\xe3\x82\xb3]", "[\xe5\xb7\xbb\xe8\xb2\x9d]", "[\xe3\x82\xb2\xe3\x82\xb8\xe3\x82\xb2\xe3\x82\xb8]", "[\xe3\x82\xa2\xe3\x83\xaa]", "[\xe3\x83\x9f\xe3\x83\x84\xe3\x83\x90\xe3\x83\x81]", "[\xe3\x81\xa6\xe3\x82\x93\xe3\x81\xa8\xe3\x81\x86\xe8\x99\xab]", "\xee\x9d\x91", "[\xe3\x82\xab\xe3\x83\xa1]", "\xee\x9d\x8f", "\xee\x9d\x90", "\xee\x9a\xa1", "[\xe3\x82\xa4\xe3\x83\xab\xe3\x82\xab]", "[\xe3\x83\x8d\xe3\x82\xba\xe3\x83\x9f]", "[\xe3\x83\x88\xe3\x83\xa9]", "\xee\x9a\xa2", "[\xe3\x82\xaf\xe3\x82\xb8\xe3\x83\xa9]", "\xee\x9d\x95", "[\xe3\x82\xaf\xe3\x83\x9e]", "[\xe3\x83\x8f\xe3\x83\xa0\xe3\x82\xb9\xe3\x82\xbf\xe3\x83\xbc]", "[\xe7\x89\x9b]", "[\xe3\x82\xa6\xe3\x82\xb5\xe3\x82\xae]", "[\xe3\x82\xab\xe3\x82\xa8\xe3\x83\xab]", "\xee\x9a\x98", "[\xe8\xbe\xb0]", "[\xe3\x83\x91\xe3\x83\xb3\xe3\x83\x80]", "\xee\x9b\xb1", "\xee\x9b\xb3", "\xee\x9b\xb4", "\xee\x9b\xb2", "\xee\x9c\xa3", "\xee\x9c\xa5", "\xee\x9c\xa6", "\xee\x9d\x93", "\xee\x9d\x92", "[\xe9\xa2\xa8\xe9\x82\xaa\xe3\x81\xb2\xe3\x81\x8d]", "\xee\x9c\xaa", "\xee\x9c\xa2", "\xee\x9c\xae", "\xee\x9c\xad", "\xee\x9d\x97", "\xee\x9c\xab", "\xee\x9c\xa4", "\xee\x9c\xa1", "\xee\x9c\xa0", "\xee\x9c\x81", "\xee\x9c\xac", "\xee\x9c\xa9", "\xee\x9c\xaf", "\xee\x9c\x8b", "m(_ _)m", "(/_\xef\xbc\xbc)", "(\xe3\x83\xbb\xc3\x97\xe3\x83\xbb)", "|(\xe3\x83\xbb\xc3\x97\xe3\x83\xbb)|", "(^-^)/", "\xef\xbc\xbc(^o^)\xef\xbc\x8f", "(>\xe4\xba\xba<)", "\xee\x99\xa3", "\xee\x99\xa4", "\xee\x99\xa5", "\xee\x99\xa6", "\xee\x99\xa7", "\xee\x99\xa8", "\xee\x99\xa9", "\xee\x99\xa9\xee\x9b\xaf", "\xee\x99\xaa", "\xee\x9c\xbe", "[\xe6\x95\x99\xe4\xbc\x9a]", "[\xe5\x99\xb4\xe6\xb0\xb4]", "[\xe3\x83\x87\xe3\x83\x91\xe3\x83\xbc\xe3\x83\x88]", "[\xe5\x9f\x8e]", "[\xe5\xb7\xa5\xe5\xa0\xb4]", "\xee\x99\xa1", "\xee\x9d\x8b", "\xee\x9d\x80", "[\xe6\x9d\xb1\xe4\xba\xac\xe3\x82\xbf\xe3\x83\xaf\xe3\x83\xbc]", "[\xe8\x87\xaa\xe7\x94\xb1\xe3\x81\xae\xe5\xa5\xb3\xe7\xa5\x9e]", "[\xe6\x97\xa5\xe6\x9c\xac\xe5\x9c\xb0\xe5\x9b\xb3]", "[\xe3\x83\xa2\xe3\x82\xa2\xe3\x82\xa4]", "\xee\x9a\x99", "\xee\x99\xb4", "[\xe3\x83\x96\xe3\x83\xbc\xe3\x83\x84]", "\xee\x9a\x9a", "\xee\x9c\x8e", "\xee\x9c\x91", "\xee\x9c\x9a", "[\xe3\x83\x8d\xe3\x82\xaf\xe3\x82\xbf\xe3\x82\xa4]", "[\xe5\xb8\xbd\xe5\xad\x90]", "[\xe3\x83\x89\xe3\x83\xac\xe3\x82\xb9]", "[\xe7\x9d\x80\xe7\x89\xa9]", "[\xe3\x83\x93\xe3\x82\xad\xe3\x83\x8b]", "\xee\x9c\x8f", "\xee\x9a\x82", "\xee\x9a\xad", "\xee\x9c\x95", "[$\xef\xbf\xa5]", "[\xe6\xa0\xaa\xe4\xbe\xa1]", "[\xe3\x82\xab\xe3\x83\xbc\xe3\x83\x89]", "\xee\x9b\x96", "[\xe9\xa3\x9b\xe3\x82\x93\xe3\x81\xa7\xe3\x81\x84\xe3\x81\x8f\xe3\x81\x8a\xe9\x87\x91]", "[\xe4\xb8\xad\xe5\x9b\xbd]", "[\xe3\x83\x89\xe3\x82\xa4\xe3\x83\x84]", "[\xe3\x82\xb9\xe3\x83\x9a\xe3\x82\xa4\xe3\x83\xb3]", "[\xe3\x83\x95\xe3\x83\xa9\xe3\x83\xb3\xe3\x82\xb9]", "[\xe3\x82\xa4\xe3\x82\xae\xe3\x83\xaa\xe3\x82\xb9]", "[\xe3\x82\xa4\xe3\x82\xbf\xe3\x83\xaa\xe3\x82\xa2]", "[\xe6\x97\xa5\xe3\x81\xae\xe4\xb8\xb8]", "[\xe9\x9f\x93\xe5\x9b\xbd]", "[\xe3\x83\xad\xe3\x82\xb7\xe3\x82\xa2]", "[USA]", "[\xe7\x82\x8e]", "\xee\x9b\xbb", "\xee\x9c\x98", "[\xe3\x83\x8f\xe3\x83\xb3\xe3\x83\x9e\xe3\x83\xbc]", "[\xe3\x83\x8d\xe3\x82\xb8]", "[\xe5\x8c\x85\xe4\xb8\x81]", "[\xe3\x83\x94\xe3\x82\xb9\xe3\x83\x88\xe3\x83\xab]", "[\xe5\x8d\xa0\xe3\x81\x84]", "[\xe8\x8b\xa5\xe8\x91\x89\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "[\xe6\xb3\xa8\xe5\xb0\x84]", "[\xe8\x96\xac]", "[A]", "[B]", "[AB]", "[O]", "\xee\x9a\x84", "\xee\x9a\x85", "\xee\x9a\x86", "\xee\x9a\xa4", "[\xe3\x82\xb5\xe3\x83\xb3\xe3\x82\xbf]", "[\xe7\xa5\x9d\xe6\x97\xa5]", "[\xe8\x8a\xb1\xe7\x81\xab]", "[\xe9\xa2\xa8\xe8\x88\xb9]", "[\xe3\x82\xaf\xe3\x83\xa9\xe3\x83\x83\xe3\x82\xab\xe3\x83\xbc]", "[\xe9\x96\x80\xe6\x9d\xbe]", "[\xe3\x81\xb2\xe3\x81\xaa\xe7\xa5\xad\xe3\x82\x8a]", "[\xe5\x8d\x92\xe6\xa5\xad\xe5\xbc\x8f]", "[\xe3\x83\xa9\xe3\x83\xb3\xe3\x83\x89\xe3\x82\xbb\xe3\x83\xab]", "[\xe3\x81\x93\xe3\x81\x84\xe3\x81\xae\xe3\x81\xbc\xe3\x82\x8a]", "[\xe7\xb7\x9a\xe9\xa6\x99\xe8\x8a\xb1\xe7\x81\xab]", "[\xe9\xa2\xa8\xe9\x88\xb4]", "[\xe3\x83\x8f\xe3\x83\xad\xe3\x82\xa6\xe3\x82\xa3\xe3\x83\xb3]", "[\xe3\x82\xaa\xe3\x83\xa1\xe3\x83\x87\xe3\x83\x88\xe3\x82\xa6]", "[\xe4\xb8\x83\xe5\xa4\x95]", "[\xe3\x81\x8a\xe6\x9c\x88\xe8\xa6\x8b]", "\xee\x99\x9a", "\xee\x9a\x87", "\xee\x9a\x88", "\xee\x9b\x8e", "\xee\x9a\x89", "\xee\x9b\x90", "\xee\x9b\x93", "\xee\x9b\x8f", "[\xe6\x96\xb0\xe8\x81\x9e]", "[\xe3\x82\xb9\xe3\x83\x94\xe3\x83\xbc\xe3\x82\xab]", "[\xe3\x83\xa1\xe3\x82\xac\xe3\x83\x9b\xe3\x83\xb3]", "[\xe3\x82\xa2\xe3\x83\xb3\xe3\x83\x86\xe3\x83\x8a]", "[\xe9\x80\x81\xe4\xbf\xa1BOX]", "[\xe5\x8f\x97\xe4\xbf\xa1BOX]", "[ABCD]", "[abcd]", "[1234]", "[\xe8\xa8\x98\xe5\x8f\xb7]", "[ABC]", "\xee\x9a\xae", "\xee\x9a\xb2", "\xee\x9c\x96", "\xee\x9c\x99", "\xee\x9c\xb0", "[MD]", "[\xe3\x83\x95\xe3\x83\xad\xe3\x83\x83\xe3\x83\x94\xe3\x83\xbc]", "\xee\x9a\x8c", "[\xe7\x94\xbb\xe3\x81\xb3\xe3\x82\x87\xe3\x81\x86]", "[\xe3\x82\xab\xe3\x83\xac\xe3\x83\xb3\xe3\x83\x80\xe3\x83\xbc]", "[\xe3\x83\x95\xe3\x82\xa9\xe3\x83\xab\xe3\x83\x80]", "\xee\x9a\x83", "[\xe5\x90\x8d\xe6\x9c\xad]", "\xee\x9c\x8a", "[\xe3\x82\xb0\xe3\x83\xa9\xe3\x83\x95]", "[\xe5\xae\x9a\xe8\xa6\x8f]", "[\xe4\xb8\x89\xe8\xa7\x92\xe5\xae\x9a\xe8\xa6\x8f]", "\xee\x99\x92", "\xee\x99\x93", "\xee\x99\x94", "\xee\x99\x95", "\xee\x99\x96", "\xee\x99\x97", "\xee\x99\x98", "\xee\x99\x99", "\xee\x9c\x92", "\xee\x9c\xb3", "[\xe3\x83\x88\xe3\x83\xad\xe3\x83\x95\xe3\x82\xa3\xe3\x83\xbc]", "[\xe3\x83\x95\xe3\x83\x83\xe3\x83\x88\xe3\x83\x9c\xe3\x83\xbc\xe3\x83\xab]", "[\xe6\xb0\xb4\xe6\xb3\xb3]", "\xee\x99\x9b", "\xee\x99\x9c", "\xee\x99\x9d", "\xee\x99\x9e", "\xee\x99\x9f", "\xee\x99\xa0", "[\xe3\x83\x90\xe3\x82\xb9\xe5\x81\x9c]", "\xee\x99\xa2", "\xee\x9a\xa3", "[\xe9\xa7\x85]", "[\xe3\x83\xad\xe3\x82\xb1\xe3\x83\x83\xe3\x83\x88]", "[\xe3\x83\x88\xe3\x83\xa9\xe3\x83\x83\xe3\x82\xaf]", "[\xe6\xb6\x88\xe9\x98\xb2\xe8\xbb\x8a]", "[\xe6\x95\x91\xe6\x80\xa5\xe8\xbb\x8a]", "[\xe3\x83\x91\xe3\x83\x88\xe3\x82\xab\xe3\x83\xbc]", "\xee\x99\xab", "\xee\x99\xac", "\xee\x99\xad", "[\xe5\xb7\xa5\xe4\xba\x8b\xe4\xb8\xad]", "\xee\x9b\xb7", "[\xe3\x82\xad\xe3\x83\xa3\xe3\x83\xb3\xe3\x83\x97]", "\xee\x99\xb9", "[\xe8\xa6\xb3\xe8\xa6\xa7\xe8\xbb\x8a]", "[\xe3\x82\xb8\xe3\x82\xa7\xe3\x83\x83\xe3\x83\x88\xe3\x82\xb3\xe3\x83\xbc\xe3\x82\xb9\xe3\x82\xbf\xe3\x83\xbc]", "\xee\x99\xb6", "\xee\x99\xb7", "\xee\x99\xba", "\xee\x99\xbb", "\xee\x99\xbc", "\xee\x99\xbd", "\xee\x99\xbe", "\xee\x9a\xac", "[\xe6\xbc\x94\xe5\x8a\x87]", "\xee\x9a\x8b", "[\xe9\xba\xbb\xe9\x9b\x80]", "[\xe7\x9a\x84\xe4\xb8\xad]", "[777]", "[\xe3\x83\x93\xe3\x83\xaa\xe3\x83\xa4\xe3\x83\xbc\xe3\x83\x89]", "[\xe3\x82\xb5\xe3\x82\xa4\xe3\x82\xb3\xe3\x83\xad]", "[\xe3\x83\x9c\xe3\x83\xbc\xe3\x83\xaa\xe3\x83\xb3\xe3\x82\xb0]", "[\xe8\x8a\xb1\xe6\x9c\xad]", "[\xe3\x82\xb8\xe3\x83\xa7\xe3\x83\xbc\xe3\x82\xab\xe3\x83\xbc]", "\xee\x9b\xb6", "\xee\x9b\xbf", "[\xe3\x82\xb5\xe3\x83\x83\xe3\x82\xaf\xe3\x82\xb9]", "[\xe3\x82\xae\xe3\x82\xbf\xe3\x83\xbc]", "[\xe3\x83\x94\xe3\x82\xa2\xe3\x83\x8e]", "[\xe3\x83\x88\xe3\x83\xa9\xe3\x83\xb3\xe3\x83\x9a\xe3\x83\x83\xe3\x83\x88]", "[\xe3\x83\x90\xe3\x82\xa4\xe3\x82\xaa\xe3\x83\xaa\xe3\x83\xb3]", "[\xe6\xad\x8c\xe8\xa8\x98\xe5\x8f\xb7]", "\xee\x9a\x81", "\xee\x9a\x8a", "[\xe3\x83\xa9\xe3\x82\xb8\xe3\x82\xaa]", "[\xe3\x83\x93\xe3\x83\x87\xe3\x82\xaa]", "\xee\x9c\x97", "\xee\x9c\x9b", "[\xe8\x8a\xb1\xe6\x9d\x9f]", "\xee\x9b\xad", "[\xe7\xb5\x90\xe5\xa9\x9a\xe5\xbc\x8f]", "[18\xe7\xa6\x81]", "\xee\x9c\xb1", "\xee\x9c\xb6", "\xee\x9c\xb2", "[\xef\xbd\x89]", "\xee\x9b\xa0", "\xee\x9b\xa2", "\xee\x9b\xa3", "\xee\x9b\xa4", "\xee\x9b\xa5", "\xee\x9b\xa6", "\xee\x9b\xa7", "\xee\x9b\xa8", "\xee\x9b\xa9", "\xee\x9b\xaa", "\xee\x9b\xab", "[10]", "[\xe3\x83\x90\xe3\x83\xaa3]", "[\xe3\x83\x9e\xe3\x83\x8a\xe3\x83\xbc\xe3\x83\xa2\xe3\x83\xbc\xe3\x83\x89]", "[\xe3\x82\xb1\xe3\x83\xbc\xe3\x82\xbf\xe3\x82\xa4OFF]", "\xee\x99\xb3", "\xee\x9d\x89", "\xee\x9d\x8a", "\xee\x9d\x8c", "\xee\x9d\x8d", "[\xe3\x83\x95\xe3\x83\xa9\xe3\x82\xa4\xe3\x83\x91\xe3\x83\xb3]", "[\xe3\x82\xbd\xe3\x83\x95\xe3\x83\x88\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\xa0]", "[\xe3\x83\x9d\xe3\x83\x86\xe3\x83\x88]", "[\xe3\x81\xa0\xe3\x82\x93\xe3\x81\x94]", "[\xe3\x81\x9b\xe3\x82\x93\xe3\x81\xb9\xe3\x81\x84]", "[\xe3\x83\x91\xe3\x82\xb9\xe3\x82\xbf]", "[\xe3\x82\xab\xe3\x83\xac\xe3\x83\xbc]", "[\xe3\x81\x8a\xe3\x81\xa7\xe3\x82\x93]", "[\xe3\x81\x99\xe3\x81\x97]", "[\xe5\xbc\x81\xe5\xbd\x93]", "[\xe9\x8d\x8b]", "[\xe3\x82\xab\xe3\x82\xad\xe6\xb0\xb7]", "[\xe8\x82\x89]", "[\xe3\x82\x84\xe3\x81\x8d\xe3\x81\x84\xe3\x82\x82]", "[\xe3\x83\x94\xe3\x82\xb6]", "[\xe3\x83\x81\xe3\x82\xad\xe3\x83\xb3]", "[\xe3\x82\xa2\xe3\x82\xa4\xe3\x82\xb9\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\xa0]", "[\xe3\x83\x89\xe3\x83\xbc\xe3\x83\x8a\xe3\x83\x84]", "[\xe3\x82\xaf\xe3\x83\x83\xe3\x82\xad\xe3\x83\xbc]", "[\xe3\x83\x81\xe3\x83\xa7\xe3\x82\xb3]", "[\xe3\x82\xad\xe3\x83\xa3\xe3\x83\xb3\xe3\x83\x87\xe3\x82\xa3]", "[\xe3\x83\x97\xe3\x83\xaa\xe3\x83\xb3]", "[\xe3\x83\x8f\xe3\x83\x81\xe3\x83\x9f\xe3\x83\x84]", "[\xe3\x82\xa8\xe3\x83\x93\xe3\x83\x95\xe3\x83\xa9\xe3\x82\xa4]", "\xee\x99\xaf", "\xee\x99\xb0", "\xee\x99\xb1", "\xee\x99\xb2", "\xee\x9c\x9e", "\xee\x9d\x96", "\xee\x99\xb8", "\xee\x9a\x96", "\xee\x9a\x97", "\xee\x9a\xa5", "\xee\x9b\xb5", "\xee\x9c\x80", "\xee\x9c\xbc", "\xee\x9c\xbd", "[\xe2\x86\x91]", "[\xe2\x86\x93]", "[\xe2\x86\x92]", "[\xe2\x86\x90]", "[>]", "[<]", "[>>]", "[<<]", "\xe2\x96\xb2", "\xe2\x96\xbc", "[\xc3\x97]", "\xee\x9c\x82", "\xee\x9c\x83", "\xee\x9c\x84", "[\xef\xbc\x9f]", "\xee\x9c\x89", "\xee\x9b\x9f", "\xee\x9b\xac", "\xee\x9b\xae", "\xee\x9b\xaf", "\xee\x9b\xb8", "\xee\x9a\x8d", "\xee\x9a\x8e", "\xee\x9a\x8f", "\xee\x9a\x90", "\xee\x99\xbf", "\xee\x9a\x80", "\xee\x9a\x9b", "\xee\x9b\x9e", "\xee\x9c\xb7", "\xee\x9c\xb5", "\xee\x9c\x9d", "[\xe2\x99\x82]", "[\xe2\x99\x80]", "\xee\x99\xae", "\xee\x9c\x94", "\xee\x9c\xb8", "[\xe3\x83\x81\xe3\x82\xa7\xe3\x83\x83\xe3\x82\xaf\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "\xee\x9b\x9b", "[COOL]", "\xee\x9b\x97", "\xee\x9b\x98", "\xee\x9b\x9d", "[SOS]", "[UP!]", "[VS]", "[\xe3\x82\xb3\xe3\x82\xb3]", "[\xe3\x82\xb5\xe3\x83\xbc\xe3\x83\x93\xe3\x82\xb9]", "\xee\x9c\xb9", "\xee\x9c\xba", "\xee\x9c\xbb", "[\xe6\x9c\x89]", "[\xe7\x84\xa1]", "[\xe6\x9c\x88]", "[\xe7\x94\xb3]", "[\xe5\x89\xb2]", "[\xe6\x8c\x87]", "[\xe5\x96\xb6]", "\xee\x9c\xb4", "[\xe7\xa5\x9d]", "[\xe5\xbe\x97]", "[\xe5\x8f\xaf]", "[\xef\xbc\x8b]", "[\xef\xbc\x8d]", "[\xc3\xb7]", "\xee\x9b\xbc", "\xee\x9b\xbe", "\xee\x9c\x85", "\xee\x9c\x86", "\xee\x9c\x87", "\xee\x9c\x88", "[\xe3\x82\xa6\xe3\x83\xb3\xe3\x83\x81]", "[\xe5\x8a\x9b\xe3\x81\x93\xe3\x81\xb6]", "[\xe3\x82\xaf\xe3\x83\xa9\xe3\x82\xaf\xe3\x83\xa9]", "[\xe3\x83\x95\xe3\x82\xad\xe3\x83\x80\xe3\x82\xb7]", "\xee\x9b\xba", "\xe2\x96\xa0", "\xe2\x97\x86", "[\xe8\x8a\xb1\xe4\xb8\xb8]", "[100\xe7\x82\xb9]", "\xee\x9b\x9a", "\xe2\x94\x94\xe2\x86\x92", "[\xe9\x9b\xbb\xe6\xb1\xa0]", "[\xe3\x82\xb3\xe3\x83\xb3\xe3\x82\xbb\xe3\x83\xb3\xe3\x83\x88]", "\xee\x9b\x9c", "\xee\x9b\x99", "\xee\x9c\x93", "[\xe3\x83\xa9\xe3\x82\xb8\xe3\x82\xaa\xe3\x83\x9c\xe3\x82\xbf\xe3\x83\xb3]", "[\xe3\x83\x96\xe3\x83\x83\xe3\x82\xaf\xe3\x83\x9e\xe3\x83\xbc\xe3\x82\xaf]", "[\xe3\x83\xaa\xe3\x83\xb3\xe3\x82\xaf]", "[\xe2\x86\x90BACK]", "\xee\x9a\xb9", "\xee\x9a\xb8", "\xee\x9a\xb7", "[TOP]", "\xee\x9a\x93", "\xee\x9a\x95", "\xee\x9a\x94", "\xee\x9b\xbd", "\xee\x9c\xa7", "[\xe4\xba\xba\xe5\xb7\xae\xe3\x81\x97\xe6\x8c\x87]", "[\xe6\x8b\x8d\xe6\x89\x8b]", "\xee\x92\x88", "\xee\x92\x8d", "\xee\x92\x8c", "\xee\x92\x85", "\xee\x92\x87", "\xee\x91\xa9", "\xee\x96\x98", "\xee\xab\xa8", "\xee\xab\xb1", "\xee\xab\xb4", "\xee\x97\x9a", "\xee\xab\xb2", "\xee\x92\x8a", "\xee\x92\x8e", "\xee\x92\xbf", "\xee\xad\xbc", "\xee\xad\x93", "\xee\xad\x9f", "\xee\x96\xb3", "\xee\x96\xa8", "\xee\x96\xa9", "\xee\x96\xaa", "\xee\x92\x86", "\xe2\x97\x8b", "\xee\x92\x89", "\xee\x92\x8b", "\xee\x91\xa8", "\xee\x96\x94", "\xee\x95\xba", "\xee\x95\xbb", "\xee\x91\xbc", "\xee\x92\x8f", "\xee\x92\x90", "\xee\x92\x91", "\xee\x92\x92", "\xee\x92\x93", "\xee\x92\x94", "\xee\x92\x95", "\xee\x92\x96", "\xee\x92\x97", "\xee\x92\x98", "\xee\x92\x99", "\xee\x92\x9a", "\xee\x92\x9b", "\xee\x94\x93", "\xee\x93\xa4", "\xee\xad\xbd", "\xee\x93\x8e", "\xee\x93\x8a", "\xee\x96\xba", "\xee\x97\x8d", "\xee\xaa\x94", "\xee\x93\xa3", "\xee\x93\xa2", "\xee\xaa\x96", "\xee\xac\xb6", "\xee\xac\xb7", "\xee\xac\xb8", "\xee\xad\x89", "\xee\xae\x82", "\xee\x93\x92", "\xee\xac\xb5", "\xee\xaa\xb9", "\xee\xaa\xba", "\xee\x93\x94", "\xee\x93\x8d", "\xee\xaa\xbb", "\xee\xaa\xbc", "\xee\xac\xb2", "\xee\xac\xb3", "\xee\xac\xb4", "\xee\xac\xb9", "\xee\xad\x9a", "\xee\x96\xa4", "\xee\x96\xa5", "\xee\xab\x90", "\xee\xab\x91", "\xee\xad\x87", "\xee\x94\x89", "\xee\xaa\xa0", "\xee\x94\x8b", "\xee\xaa\xa1", "\xee\xaa\xa2", "\xe3\x80\x93", "\xee\x93\xbc", "\xee\x93\xba", "\xee\x94\x81", "\xee\x97\x9d", "\xee\xab\x9b", "\xee\xab\xa9", "\xee\xac\x93", "\xee\xac\x94", "\xee\xac\x95", "\xee\xac\x96", "\xee\xac\x97", "\xee\xac\x98", "\xee\xac\x99", "\xee\xac\x9a", "\xee\xad\x84", "\xee\xad\x85", "\xee\x93\x8b", "\xee\x96\xbf", "\xee\x94\x8e", "\xee\x93\xac", "\xee\x93\xaf", "\xee\x93\xb8", "\xee\xac\x9c", "\xee\xad\xbe", "\xee\xac\xa2", "\xee\x93\x98", "\xee\xac\xa3", "\xee\xac\xa4", "\xee\xac\xa5", "\xee\xac\x9f", "\xee\xac\xa0", "\xee\x93\x99", "\xee\x97\x87", "\xee\xab\xac", "\xee\xac\x9e", "\xee\x93\x9d", "\xee\xad\x97", "\xee\xad\x98", "\xee\xac\x9d", "\xee\x93\x93", "\xee\x97\x94", "\xee\x93\xa0", "\xee\xad\xb6", "\xee\x97\x9b", "\xee\x93\x9c", "\xee\x93\x9f", "\xee\xac\x9b", "\xee\x97\x82", "\xee\x97\x80", "\xee\x93\x9b", "\xee\x91\xb0", "\xee\x93\xa1", "\xee\x93\x9e", "\xee\x97\x81", "\xee\xac\xa1", "\xee\x93\x97", "\xee\x93\x9a", "\xee\x93\xae", "\xee\xac\xbf", "\xee\xad\x86", "\xee\xad\x88", "\xee\x91\xb2", "\xee\xad\xa7", "\xee\xab\x8a", "\xee\xab\x80", "\xee\x96\xae", "\xee\xab\x8b", "\xee\xab\x89", "\xee\x97\x84", "\xee\xab\x81", "\xee\x93\xa7", "\xee\xab\x8d", "\xee\xab\x8f", "\xee\xab\x8e", "\xee\xab\x87", "\xee\xab\x88", "\xee\x91\xb1", "\xee\x91\xb1\xee\x96\xb1", "\xee\xab\x85", "\xee\xae\x80", "\xee\xad\xa4", "\xee\x93\xbb", "\xee\xad\xa9", "\xee\x91\xb3", "\xee\xab\x86", "\xee\xab\x82", "\xee\xad\x9d", "\xee\xab\x83", "\xee\x97\x85", "\xee\xab\x84", "\xee\xaa\xbf", "\xee\x97\x86", "\xee\x91\xb4", "\xee\x97\x83", "\xee\xad\xa1", "\xee\xad\xbf", "\xee\xad\xa3", "\xee\xad\xa0", "\xee\xad\xa5", "\xee\xad\xa8", "\xee\xad\x9e", "\xee\xad\xaa", "\xee\xad\xa6", "\xee\xab\x97", "\xee\xab\x98", "\xee\xab\x99", "\xee\xad\x90", "\xee\xad\x91", "\xee\xad\x92", "\xee\xae\x85", "\xee\xae\x86", "\xee\xae\x87", "\xee\xae\x88", "\xee\xab\x92", "\xee\x92\xab", "\xee\xac\x89", "\xee\x92\xad", "\xee\x97\x9e", "\xee\x97\x9f", "\xee\x92\xaa", "\xee\x92\xa3", "\xee\xaa\x81", "\xee\xab\xb3", "\xee\x92\xa4", "\xee\xaa\x80", "\xee\x96\xbb", "\xee\x97\x8f", "\xee\xab\xb6", "\xee\xab\xb7", "\xee\xab\xb8", "\xee\xab\xb9", "\xee\x92\xa9", "\xee\x92\xbd", "\xee\x96\xbd", "\xee\x93\x80", "\xee\x95\xb2", "\xee\xad\xac", "\xee\x96\xb7", "\xee\xac\xab", "\xee\x94\x9a", "\xee\xaa\x9f", "\xee\xac\xaa", "\xee\x93\xbe", "\xee\x96\xb6", "\xee\xad\xb7", "\xee\x97\x89", "\xee\xaa\x93", "\xee\xaa\x9e", "\xee\xad\xab", "\xee\xaa\xa3", "\xee\xaa\xa4", "\xee\x94\x8d", "\xee\x94\x84", "\xee\x92\x9c", "[\xe3\x81\xb5\xe3\x81\x8f\xe3\x82\x8d]", "\xee\x93\x87", "\xee\x97\x9c", "\xee\x95\xb9", "\xee\x95\xbc", "\xee\x95\xbd", "\xee\x96\x85", "\xee\xad\x9b", "\xee\xac\x91", "\xee\xac\x8e", "\xee\x97\x95", "\xee\xab\xba", "\xee\xac\x90", "\xee\xac\x8f", "\xee\x93\x8c", "\xee\xac\x92", "\xee\x97\x96", "\xee\x95\xb3", "\xee\x91\xbb", "\xee\x96\x83", "\xee\x96\x87", "\xee\x97\x8b", "\xee\x96\x81", "\xee\x95\xbf", "\xee\x94\x8a", "\xee\xaa\x8f", "\xee\x92\x80", "\xee\x94\x90", "\xee\xaa\x9a", "\xee\xac\xa6", "\xee\xac\xa7", "\xee\xac\xa9", "\xee\xac\xa8", "\xee\x96\x9f", "\xee\x93\x8f", "\xee\x96\xa0", "\xee\x93\x89", "\xee\xab\xb0", "\xee\x97\x99", "\xee\x97\x8c", "\xee\xaa\x9b", "\xee\xaa\x9c", "\xee\xab\xa3", "\xee\xab\xa4", "\xee\xab\xa5", "\xee\xab\xa6", "\xee\xab\xa7", "\xee\xab\xab", "\xee\xab\xad", "\xee\xab\xae", "\xee\x91\xaf", "\xee\xac\xbd", "\xee\xab\xaf", "\xee\x96\x9b", "\xee\x96\x96", "\xee\x94\x9e", "\xee\x96\x88", "\xee\xac\x88", "\xee\xaa\x92", "\xee\x94\xa0", "\xee\x94\xa1", "\xee\x96\x91", "\xee\xad\xa2", "\xee\x94\x9b", "\xee\xac\x8a", "\xee\x96\x8b", "\xee\x94\x91", "\xee\x92\xa8", "\xee\x96\x92", "\xee\x96\x93", "\xee\x94\x9f", "\xee\xad\xb1", "\xee\xab\xbd", "\xee\xab\xbe", "\xee\xab\xbf", "\xee\xac\x80", "\xee\xad\x95", "\xee\xac\x83", "[\xe3\x81\x84\xe3\x81\x99]", "\xee\x96\xb8", "\xee\x92\xa1", "\xee\x92\xa0", "\xee\x97\x8e", "\xee\x96\x82", "\xee\x95\xa2", "\xee\x94\x8c", "\xee\x94\x96", "\xee\x95\xa0", "\xee\x95\xa1", "\xee\x95\xa9", "\xee\x95\xa3", "\xee\x96\x8f", "\xee\x96\x90", "\xee\x95\xab", "\xee\x92\x9f", "\xee\x92\x9d", "\xee\x95\xa8", "\xee\x95\xa5", "\xee\x95\xa6", "\xee\x95\xa7", "\xee\x95\xaf", "\xee\x94\x9d", "\xee\x95\x9f", "\xee\x95\xa4", "\xee\x95\xaa", "\xee\x95\xb4", "\xee\x95\xb5", "\xee\x95\xb6", "\xee\x95\xac", "\xee\x95\xad", "\xee\x95\xae", "\xee\x95\xb0", "\xee\x92\xa2", "\xee\xac\x8b", "\xee\x92\xba", "\xee\x96\x99", "\xee\x92\xb7", "\xee\x92\xb6", "\xee\xaa\xac", "\xee\x96\x9a", "\xee\x92\xb9", "\xee\x92\xb8", "\xee\x91\xab", "\xee\xad\x81", "\xee\x97\x93", "\xee\x92\xbb", "\xee\xab\x9e", "\xee\x92\xb5", "\xee\x96\xbc", "\xee\x92\xb0", "\xee\x92\xb1", "\xee\x92\xaf", "\xee\x92\xa7", "\xee\xaa\x82", "\xee\x92\xb3", "\xee\x92\xb4", "\xee\xad\xad", "\xee\x97\x88", "\xee\x92\xb2", "\xee\xab\x9f", "\xee\xab\xa0", "\xee\xab\xa1", "\xee\x95\xb1", "\xee\x92\xa6", "\xee\x91\xaa", "\xee\x97\x97", "\xee\xad\xb3", "\xee\x92\xbc", "\xee\x97\x90", "\xee\x91\xad", "\xee\xab\xa2", "\xee\xad\x82", "\xee\x94\x83", "\xee\x94\x97", "\xee\x94\x88", "\xee\x96\x9c", "\xee\xab\xb5", "\xee\x96\x9e", "\xee\x92\x9e", "\xee\x92\xbe", "\xee\x96\x9d", "\xee\x93\x86", "\xee\x97\x91", "\xee\x93\x85", "\xee\x91\xae", "\xee\xab\x9d", "\xee\x93\x88", "\xee\xad\x83", "\xee\xad\xae", "\xee\xad\xaf", "\xee\x96\xbe", "\xee\x94\x85", "\xee\x94\x86", "\xee\xad\x80", "\xee\xab\x9c", "\xee\x94\x87", "\xee\xab\x8c", "\xee\x94\x95", "\xee\x95\xbe", "\xee\x94\x82", "\xee\x96\xb9", "\xee\x96\x80", "\xee\x93\xab", "\xee\xad\xb8", "\xee\x94\x94", "\xee\x97\x8a", "\xee\xaa\x95", "\xee\xab\x9a", "\xee\xaa\x83", "\xee\x95\x98", "\xee\x95\x99", "\xee\x95\x8e", "\xee\x94\xb3", "\xee\xae\x84", "\xee\x94\xa2", "\xee\x94\xa3", "\xee\x94\xa4", "\xee\x94\xa5", "\xee\x94\xa6", "\xee\x94\xa7", "\xee\x94\xa8", "\xee\x94\xa9", "\xee\x94\xaa", "\xee\x96\xac", "\xee\x94\xab", "\xee\xaa\x84", "\xee\xaa\x90", "\xee\xaa\x91", "\xee\x93\x96", "\xee\x93\x95", "\xee\x93\x90", "\xee\x96\xb4", "\xee\xaa\xaf", "\xee\x93\x91", "\xee\xaa\xb0", "\xee\xaa\xb1", "\xee\xaa\xb2", "\xee\xaa\xb3", "\xee\xaa\xb4", "\xee\xaa\xb5", "\xee\xaa\xb6", "\xee\xaa\xb7", "\xee\xaa\xb8", "\xee\xaa\xbd", "\xee\xaa\xbe", "\xee\xab\xaa", "\xee\x93\x84", "\xee\x93\xad", "\xee\xac\xba", "\xee\xac\xbb", "\xee\xac\xbc", "\xee\xad\x8a", "\xee\xad\x8b", "\xee\xad\x8c", "\xee\xad\x8d", "\xee\xad\x8e", "\xee\xad\x8f", "\xee\xad\x96", "\xee\xad\x99", "\xee\xad\xb0", "\xee\x92\xac", "\xee\x96\x97", "\xee\x93\x82", "\xee\x93\x83", "\xee\xaa\xae", "\xee\xaa\x97", "\xee\x93\x81", "\xee\xaa\x98", "\xee\xac\xbe", "\xee\x95\x95", "\xee\x95\x8d", "\xee\x95\x8c", "\xee\x95\x96", "\xee\xac\xad", "\xee\xac\xae", "\xee\xad\xba", "\xee\xad\xbb", "\xee\x94\xbf", "\xee\x95\x80", "\xee\x95\x92", "\xee\x95\x93", "\xee\x94\xae", "\xee\x94\xad", "\xee\x94\xb0", "\xee\x94\xaf", "\xee\x95\x85", "\xee\x95\x84", "\xee\x95\x9a", "\xee\x95\x9b", "\xee\x95\x83", "\xee\x95\x82", "\xee\xaa\xad", "\xee\x95\x90", "\xee\x95\x91", "\xee\x92\x82", "\xee\xac\xaf", "\xee\xac\xb0", "\xee\x92\x83", "\xee\xac\xb1", "[\xe3\x83\x95\xe3\x83\xaa\xe3\x83\xbc\xe3\x83\x80\xe3\x82\xa4\xe3\x83\xa4\xe3\x83\xab]", "\xee\x96\x95", "\xee\xad\xb5", "\xee\x91\xb7", "\xee\x91\xb8", "\xee\xaa\xa6", "\xee\x93\xaa", "\xee\xaa\xa7", "\xee\xaa\xa8", "\xee\xaa\xa9", "\xee\xaa\xaa", "\xee\xad\x94", "\xee\x96\xaf", "\xee\xaa\xa5", "\xee\x96\xa1", "\xee\x96\xa2", "\xee\x96\xa3", "\xee\x91\xbd", "\xee\x91\xbe", "\xee\x91\xbf", "\xee\xac\xac", "\xee\x92\x81", "\xee\x92\x84", "\xee\xad\xb9", "\xee\x92\xae", "\xee\xad\xb2", "\xee\x97\x98", "\xee\x92\xa5", "[\xe3\x83\x89\xe3\x82\xa2]", "\xee\x95\x81", "\xee\x95\x97", "\xee\x96\xab", "\xee\xaa\x85", "\xee\x95\xb8", "\xee\xaa\x88", "\xee\x96\xb5", "[NG]", "\xee\x96\xad", "\xee\x93\xa8", "\xee\x94\x8f", "\xee\x97\x92", "\xee\xaa\x87", "[\xe7\xa6\x81]", "\xee\xaa\x8a", "[\xe5\x90\x88]", "\xee\xaa\x89", "\xee\xaa\x86", "\xee\xaa\x8b", "\xee\xaa\x8c", "\xee\x93\xb1", "\xee\xaa\x99", "\xee\x93\xb7", "\xee\xac\x81", "\xee\x94\xbc", "\xee\x94\xbd", "\xee\x95\x8f", "\xee\x95\x94", "\xee\x91\xb6", "\xee\x93\xa5", "\xee\x91\xba", "\xee\x91\xb5", "\xee\x96\xb0", "\xee\x96\xb1", "\xee\x93\xa6", "\xee\x93\xb4", "\xee\x93\xb5", "\xee\x93\xa9", "\xee\xad\x9c", "\xee\x93\xbd", "\xee\xaa\xab", "\xee\x91\xb9", "\xee\x94\xbe", "\xee\x94\xba", "\xee\x94\xbb", "\xee\x95\x8a", "\xee\x95\x8b", "\xee\x95\x88", "\xee\x95\x89", "\xee\x94\xb1", "\xee\x94\xb2", "\xee\x94\xb4", "\xee\x94\xb5", "\xee\x94\xb8", "\xee\x94\xb9", "\xee\x95\x86", "\xee\x95\x87", "\xee\x94\xb6", "\xee\x94\xb7", "\xee\x91\xac", "\xee\x93\xb0", "\xee\x93\xb2", "\xee\x95\x9d", "\xee\x95\x9c", "\xee\xac\x8d", "\xee\x96\x84", "\xee\x96\x89", "\xee\x94\x98", "\xee\xac\x85", "\xee\x94\x9c", "\xee\xac\x8c", "\xee\xab\xbc", "\xee\x94\x99", "\xee\x94\x92", "\xee\xac\x82", "\xee\xac\x84", "\xee\xac\x87", "\xee\x96\x8a", "\xee\xac\x86", "[end]", "[ON]", "[SOON]", "\xee\x95\x9e", "\xee\xae\x83", "\xee\x96\xa7", "\xee\x96\xa6", "\xee\x93\xb3", "\xee\x93\xb9", "\xee\x93\xb6", "\xee\xaa\x8d", "\xee\xaa\x8e", "\xee\x93\xbf", "\xee\x94\x80", "\xee\xab\x96", "\xee\xab\x93", "\xee\xab\x94", "\xee\xab\x95", "\xee\x81\x8a", "\xee\x81\x89", "\xee\x81\x8b", "\xee\x81\x88", "\xee\x84\xbd", "\xee\x91\x83", "[\xe9\x9c\xa7]", "\xee\x90\xbc", "\xee\x91\x8b", "\xee\x81\x8d", "\xee\x91\x89", "\xee\x85\x86", "\xee\x91\x8a", "\xee\x91\x8c", "\xee\x81\x8a\xee\x81\x89", "\xee\x90\xbe", "\xe2\x97\x8f", "\xee\x81\x8c", "\xee\x8c\xb5", "\xee\x80\xa4", "\xee\x80\xa5", "\xee\x80\xa6", "\xee\x80\xa7", "\xee\x80\xa8", "\xee\x80\xa9", "\xee\x80\xaa", "\xee\x80\xab", "\xee\x80\xac", "\xee\x80\xad", "\xee\x80\xae", "\xee\x80\xaf", "[\xe8\x85\x95\xe6\x99\x82\xe8\xa8\x88]", "[\xe7\xa0\x82\xe6\x99\x82\xe8\xa8\x88]", "\xee\x88\xbf", "\xee\x89\x80", "\xee\x89\x81", "\xee\x89\x82", "\xee\x89\x83", "\xee\x89\x84", "\xee\x89\x85", "\xee\x89\x86", "\xee\x89\x87", "\xee\x89\x88", "\xee\x89\x89", "\xee\x89\x8a", "\xee\x89\x8b", "\xee\x84\x90", "\xee\x8c\x84", "\xee\x84\x98", "\xee\x80\xb0", "\xee\x80\xb2", "\xee\x84\x99", "\xee\x91\x87", "\xee\x8c\x83", "\xee\x8c\x85", "\xee\x8c\x87", "\xee\x8c\x88", "\xee\x91\x84", "[\xe3\x81\x95\xe3\x81\x8f\xe3\x82\x89\xe3\x82\x93\xe3\x81\xbc]", "[\xe3\x83\x90\xe3\x83\x8a\xe3\x83\x8a]", "\xee\x8d\x85", "\xee\x8d\x86", "\xee\x8d\x87", "\xee\x8d\x88", "\xee\x8d\x89", "\xee\x8d\x8a", "\xee\x90\x99", "\xee\x90\x9b", "\xee\x90\x9a", "\xee\x90\x9c", "\xee\x90\x89", "\xee\x8c\x9c", "\xee\x8c\x9d", "\xee\x8c\x9e", "\xee\x8c\x9f", "\xee\x8c\xa0", "\xee\x80\x81", "\xee\x80\x82", "\xee\x80\x84", "\xee\x80\x85", "\xee\x90\xa8", "\xee\x85\x92", "\xee\x90\xa9", "\xee\x84\x9b", "\xee\x81\x8e", "\xee\x84\x8c", "\xee\x84\xab", "\xee\x84\x9a", "\xee\x84\x9c", "\xee\x89\x93", "[\xe3\x82\xab\xe3\x82\xbf\xe3\x83\x84\xe3\x83\xa0\xe3\x83\xaa]", "\xee\x84\xb4", "\xee\x84\x8a", "\xee\x91\x81", "\xee\x80\x99", "\xee\x81\x95", "\xee\x81\x92", "\xee\x81\x93", "\xee\x81\x90", "\xee\x81\x8f", "\xee\x81\x94", "\xee\x80\x9a", "\xee\x84\x89", "\xee\x84\x8b", "\xee\x81\x91", "\xee\x94\xac", "\xee\x81\x99", "\xee\x90\x83", "\xee\x90\x90", "\xee\x81\x98", "\xee\x90\x86", "\xee\x90\x8f", "\xee\x90\x8e", "\xee\x84\x86", "\xee\x90\x84", "\xee\x84\x85", "\xee\x81\x96", "\xee\x90\x98", "\xee\x90\x97", "\xee\x90\x8c", "\xee\x90\x8d", "\xee\x81\x97", "\xee\x90\x95\xee\x8c\xb1", "\xee\x90\x8a", "\xee\x90\x92", "\xee\x90\x94", "\xee\x90\x95", "\xee\x90\x93", "\xee\x90\x91", "\xee\x90\x8b", "\xee\x90\x96", "\xee\x90\x87", "\xee\x84\x87", "\xee\x90\x88", "\xee\x90\x82", "\xee\x84\x88", "\xee\x90\x81", "\xee\x90\x85", "\xee\x90\xa3", "\xee\x90\xa4", "\xee\x90\xa6", "\xee\x80\x92", "\xee\x90\xa7", "\xee\x90\x9d", "\xee\x80\xb6", "\xee\x80\xb8", "\xee\x85\x93", "\xee\x85\x95", "\xee\x85\x8d", "\xee\x85\x94", "\xee\x85\x98", "\xee\x85\x96", "\xee\x85\x97", "\xee\x80\xb7", "\xee\x84\xa1", "\xee\x88\x82", "\xee\x8c\x8b", "\xee\x80\xbb", "\xee\x80\x87", "\xee\x84\xbe", "\xee\x8c\x9a", "\xee\x8c\x9b", "[\xe3\x83\xa1\xe3\x82\xac\xe3\x83\x8d]", "\xee\x80\x86", "[\xe3\x82\xb8\xe3\x83\xbc\xe3\x83\xb3\xe3\x82\xba]", "\xee\x84\x8e", "\xee\x8c\x82", "\xee\x8c\x98", "\xee\x8c\x99", "\xee\x8c\xa1", "\xee\x8c\xa2", "[\xe8\xb2\xa1\xe5\xb8\x83]", "\xee\x8c\xa3", "\xee\x84\xaf", "\xee\x85\x89", "\xee\x85\x8a", "\xef\xbf\xa5", "\xee\x84\x9d", "[\xe6\x87\x90\xe4\xb8\xad\xe9\x9b\xbb\xe7\x81\xaf]", "[\xe3\x83\xac\xe3\x83\xb3\xe3\x83\x81]", "\xee\x84\x96", "\xee\x84\x93", "\xee\x88\xbe", "\xee\x88\x89", "\xee\x80\xb1", "\xee\x84\xbb", "\xee\x8c\x8f", "\xee\x8c\x94", "\xee\x84\x92", "\xee\x8d\x8b", "\xee\x80\xb3", "\xee\x91\x88", "\xee\x85\x83", "\xee\x84\x97", "\xee\x8c\x90", "\xee\x8c\x92", "\xee\x90\xb6", "\xee\x90\xb8", "\xee\x90\xb9", "\xee\x90\xba", "\xee\x90\xbb", "\xee\x91\x80", "\xee\x91\x82", "\xee\x91\x85", "\xee\x91\x86", "[\xe3\x83\x9d\xe3\x82\xb1\xe3\x83\x99\xe3\x83\xab]", "\xee\x80\x89", "\xee\x80\x8a", "\xee\x84\x84", "\xee\x8c\x81", "\xee\x80\x8b", "\xee\x84\x83", "\xee\x84\x81", "\xee\x84\x82", "\xee\x85\x82", "\xee\x8c\x97", "\xee\x85\x8b", "[\xe3\x83\x9a\xe3\x83\xb3]", "\xee\x84\x9f", "\xee\x80\x8c", "[\xe3\x82\xaf\xe3\x83\xaa\xe3\x83\x83\xe3\x83\x97]", "\xee\x84\x9e", "\xee\x8c\x96", "\xee\x84\xa6", "\xee\x84\xa7", "\xee\x8c\x93", "\xee\x85\x88", "[\xe3\x82\xb9\xe3\x82\xaf\xe3\x83\xad\xe3\x83\xbc\xe3\x83\xab]", "\xee\x80\x96", "\xee\x80\x94", "\xee\x80\x95", "\xee\x80\x98", "\xee\x80\x93", "\xee\x90\xaa", "\xee\x84\xb2", "[\xe3\x82\xb9\xe3\x83\x8e\xe3\x83\x9c]", "\xee\x84\x95", "\xee\x80\x97", "\xee\x84\xb1", "\xee\x90\xab", "\xee\x90\xad", "\xee\x80\x9e", "\xee\x90\xb4", "\xee\x90\xb5", "\xee\x80\x9f", "\xee\x80\x9b", "\xee\x90\xae", "\xee\x85\x99", "\xee\x85\x90", "\xee\x80\x9d", "\xee\x80\x9c", "\xee\x80\xb9", "\xee\x84\x8d", "\xee\x84\xb5", "\xee\x85\x9a", "\xee\x90\xaf", "\xee\x90\xb0", "\xee\x90\xb1", "\xee\x90\xb2", "\xee\x80\xba", "\xee\x85\x8f", "\xee\x85\x8e", "\xee\x84\xb7", "\xee\x84\xa3", "\xee\x84\xa2", "\xee\x84\xa4", "\xee\x90\xb3", "\xee\x80\xbc", "\xee\x80\xbd", "\xee\x8c\x8a", "[\xe3\x82\xa4\xe3\x83\x99\xe3\x83\xb3\xe3\x83\x88]", "\xee\x84\xa5", "\xee\x8c\xa4", "[\xe3\x82\xb2\xe3\x83\xbc\xe3\x83\xa0]", "\xee\x84\xad", "\xee\x84\xb0", "\xee\x84\xb3", "\xee\x90\xac", "\xee\x80\xbe", "\xee\x8c\xa6", "\xee\x81\x80", "\xee\x81\x81", "\xee\x81\x82", "\xee\x84\xac", "\xee\x80\x88", "\xee\x84\xaa", "\xee\x84\xa8", "\xee\x84\xa9", "\xee\x80\x83", "\xee\x84\x83\xee\x8c\xa8", "\xee\x80\xb4", "\xee\x80\xb5", "\xee\x84\x91", "\xee\x8c\x86", "\xee\x90\xa5", "\xee\x90\xbd", "\xee\x88\x87", "\xee\x89\x8e", "\xee\x89\x8f", "\xee\x88\x90", "\xee\x88\x9c", "\xee\x88\x9d", "\xee\x88\x9e", "\xee\x88\x9f", "\xee\x88\xa0", "\xee\x88\xa1", "\xee\x88\xa2", "\xee\x88\xa3", "\xee\x88\xa4", "\xee\x88\xa5", "\xee\x88\x8b", "\xee\x89\x90", "\xee\x89\x91", "\xee\x84\xa0", "\xee\x8d\x82", "\xee\x81\x86", "\xee\x8d\x80", "\xee\x8c\xb9", "\xee\x85\x87", "\xee\x8c\xba", "\xee\x8c\xbb", "\xee\x8c\xbc", "\xee\x8c\xbd", "\xee\x8c\xbe", "\xee\x8c\xbf", "\xee\x8d\x81", "\xee\x8d\x83", "\xee\x8d\x84", "\xee\x8d\x8c", "\xee\x8d\x8d", "\xee\x90\xbf", "[\xe3\x81\xaa\xe3\x82\x8b\xe3\x81\xa8]", "\xee\x81\x83", "\xee\x81\x85", "\xee\x81\x84", "\xee\x81\x87", "\xee\x8c\xb8", "\xee\x8c\x8c", "\xee\x88\xb6", "\xee\x88\xb8", "\xee\x88\xb7", "\xee\x88\xb9", "\xe2\x87\x94", "\xe2\x86\x91\xe2\x86\x93", "\xee\x88\xb2", "\xee\x88\xb3", "\xee\x88\xb4", "\xee\x88\xb5", "\xee\x88\xba", "\xee\x88\xbb", "\xee\x88\xbc", "\xee\x88\xbd", "\xee\x8c\xb2", "\xee\x8c\xb3", "\xee\x80\xa1", "\xef\xbc\x81\xef\xbc\x9f", "\xef\xbc\x81\xef\xbc\x81", "\xee\x80\xa0", "\xee\x8c\xb6", "\xee\x8c\xb7", "\xef\xbd\x9e", "\xee\x88\x91", "\xee\x80\xa2", "\xee\x8c\xa7", "\xee\x80\xa3", "\xee\x8c\xa8", "\xee\x8c\xa9", "\xee\x8c\xaa", "\xee\x8c\xab", "\xee\x8c\xac", "\xee\x8c\xad", "\xee\x90\xb7", "\xee\x88\x84", "\xee\x88\x8c", "\xee\x88\x8e", "\xee\x88\x8d", "\xee\x88\x8f", "\xee\x8c\x8e", "\xee\x88\x88", "\xee\x88\x8a", "[\xe6\x97\x97]", "\xee\x89\x92", "\xee\x84\xb6", "\xee\x88\x81", "\xee\x84\xb8", "\xee\x84\xb9", "\xee\x84\xbf", "\xee\x85\x91", "\xee\x85\x80", "\xee\x8c\x89", "\xee\x84\xba", "[\xe7\xa6\x81\xe6\xad\xa2]", "[CL]", "\xee\x88\x94", "[FREE]", "\xee\x88\xa9", "\xee\x88\x92", "\xee\x89\x8d", "\xee\x88\x93", "\xee\x84\xae", "\xee\x88\x83", "\xee\x88\xa8", "\xee\x88\xab", "\xee\x88\xaa", "\xee\x88\x95", "\xee\x88\x96", "\xee\x88\x97", "\xee\x88\x98", "\xee\x88\xa7", "\xee\x88\xac", "\xee\x88\xad", "\xee\x8c\x95", "\xee\x8c\x8d", "\xee\x88\xa6", "\xee\x84\x8f", "\xee\x8c\xb4", "\xee\x8c\x91", "\xee\x84\xbc", "[\xe3\x83\x89\xe3\x83\xb3\xe3\x83\x83]", "\xee\x8c\xb1", "\xee\x8c\xb0", "\xee\x81\x9a", "\xee\x85\x8c", "\xee\x8c\xae", "\xee\x88\x85", "\xee\x88\x86", "\xee\x88\x99", "\xee\x88\x9a", "\xee\x88\x9b", "\xee\x8c\xaf", "\xe2\x86\x90\xe2\x94\x98", "\xee\x85\x81", "\xee\x84\x94", "\xee\x85\x84", "\xee\x85\x85", "\xee\x80\xbf", "\xee\x8c\xa5", "\xee\x89\x8c", "\xee\x80\x90", "\xee\x80\x91", "\xee\x80\x8d", "\xee\x80\x8e", "\xee\x80\x8f", "\xee\x88\xae", "\xee\x88\xaf", "\xee\x88\xb0", "\xee\x88\xb1", "\xee\x90\x9e", "\xee\x90\x9f", "\xee\x90\xa0", "\xee\x90\xa1", "\xee\x90\xa2", "\xf3\xbe\x80\x80", "\xf3\xbe\x80\x81", "\xf3\xbe\x80\x82", "\xf3\xbe\x80\x83", "\xf3\xbe\x80\x84", "\xf3\xbe\x80\x85", "\xf3\xbe\x80\x86", "\xf3\xbe\x80\x87", "\xf3\xbe\x80\x88", "\xf3\xbe\x80\x89", "\xf3\xbe\x80\x8a", "\xf3\xbe\x80\x8b", "\xf3\xbe\x80\x8c", "\xf3\xbe\x80\x8d", "\xf3\xbe\x80\x8e", "\xf3\xbe\x80\x8f", "\xf3\xbe\x80\x90", "\xf3\xbe\x80\xb8", "\xf3\xbe\x80\xba", "\xf3\xbe\x80\xbb", "\xf3\xbe\x80\xb9", "\xf3\xbe\x80\x91", "\xf3\xbe\x80\x92", "\xf3\xbe\x80\x93", "\xf3\xbe\x80\x94", "\xf3\xbe\x80\x95", "\xf3\xbe\x80\x96", "\xf3\xbe\xad\xa9", "\xf3\xbe\xad\xaa", "\xf3\xbe\x80\x9e", "\xf3\xbe\x80\x9f", "\xf3\xbe\x80\xa0", "\xf3\xbe\x80\xa1", "\xf3\xbe\x80\xa2", "\xf3\xbe\x80\xa3", "\xf3\xbe\x80\xa4", "\xf3\xbe\x80\xa5", "\xf3\xbe\x80\xa6", "\xf3\xbe\x80\xa7", "\xf3\xbe\x80\xa8", "\xf3\xbe\x80\xa9", "\xf3\xbe\x80\x9d", "\xf3\xbe\x80\x9c", "\xf3\xbe\x80\xaa", "\xf3\xbe\x80\x9b", "\xf3\xbe\x80\xab", "\xf3\xbe\x80\xac", "\xf3\xbe\x80\xad", "\xf3\xbe\x80\xae", "\xf3\xbe\x80\xaf", "\xf3\xbe\x80\xb0", "\xf3\xbe\x80\xb1", "\xf3\xbe\x80\xb2", "\xf3\xbe\x80\xb3", "\xf3\xbe\x80\xb4", "\xf3\xbe\x80\xb5", "\xf3\xbe\x80\xb6", "\xf3\xbe\x80\xb7", "\xf3\xbe\x80\xbc", "\xf3\xbe\x80\xbd", "\xf3\xbe\x80\xbe", "\xf3\xbe\x80\xbf", "\xf3\xbe\x81\x80", "\xf3\xbe\x81\x81", "\xf3\xbe\x81\x82", "\xf3\xbe\x81\x83", "\xf3\xbe\x81\x85", "\xf3\xbe\x81\x86", "\xf3\xbe\x81\x87", "\xf3\xbe\x81\x88", "\xf3\xbe\x81\x89", "\xf3\xbe\x81\x8a", "\xf3\xbe\x81\x8b", "\xf3\xbe\x81\x8c", "\xf3\xbe\x81\x8d", "\xf3\xbe\x81\x8e", "\xf3\xbe\x81\x8f", "\xf3\xbe\x81\x90", "\xf3\xbe\x81\x91", "\xf3\xbe\x81\x92", "\xf3\xbe\x81\x93", "\xf3\xbe\x81\x94", "\xf3\xbe\x81\x95", "\xf3\xbe\x81\x96", "\xf3\xbe\x81\x97", "\xf3\xbe\x81\x98", "\xf3\xbe\x81\x99", "\xf3\xbe\x81\x9a", "\xf3\xbe\x81\x9b", "\xf3\xbe\x86\x90", "\xf3\xbe\x86\x91", "\xf3\xbe\x86\x92", "\xf3\xbe\x86\x93", "\xf3\xbe\x86\x94", "\xf3\xbe\x86\x95", "\xf3\xbe\x86\x96", "\xf3\xbe\x86\x97", "\xf3\xbe\x86\x98", "\xf3\xbe\x86\x99", "\xf3\xbe\x86\x9a", "\xf3\xbe\x86\x9b", "\xf3\xbe\x86\x9c", "\xf3\xbe\x86\x9d", "\xf3\xbe\x86\x9e", "\xf3\xbe\x86\x9f", "\xf3\xbe\x86\xa0", "\xf3\xbe\x86\xa1", "\xf3\xbe\x86\xa2", "\xf3\xbe\x86\xa3", "\xf3\xbe\x86\xa4", "\xf3\xbe\x86\xa5", "\xf3\xbe\x86\xa6", "\xf3\xbe\x86\xa7", "\xf3\xbe\x86\xa8", "\xf3\xbe\x86\xa9", "\xf3\xbe\x86\xaa", "\xf3\xbe\x86\xab", "\xf3\xbe\x86\xac", "\xf3\xbe\x86\xad", "\xf3\xbe\x86\xae", "\xf3\xbe\x86\xaf", "\xf3\xbe\x86\xb0", "\xf3\xbe\x86\xb1", "\xf3\xbe\x86\xb2", "\xf3\xbe\x86\xb3", "\xf3\xbe\x86\xb4", "\xf3\xbe\x86\xb5", "\xf3\xbe\x86\xb6", "\xf3\xbe\x86\xb9", "\xf3\xbe\x87\x93", "\xf3\xbe\x9f\x9c", "\xf3\xbe\x87\x94", "\xf3\xbe\x87\x95", "\xf3\xbe\x87\x96", "\xf3\xbe\x87\x8c", "\xf3\xbe\x87\x8d", "\xf3\xbe\x87\x8e", "\xf3\xbe\x87\x8f", "\xf3\xbe\x87\x85", "\xf3\xbe\x87\x86", "\xf3\xbe\x87\x8b", "\xf3\xbe\x87\x9a", "\xf3\xbe\x87\xa1", "\xf3\xbe\x87\xa2", "\xf3\xbe\x87\x89", "\xf3\xbe\x87\x99", "\xf3\xbe\x87\x9c", "\xf3\xbe\x86\xba", "\xf3\xbe\x86\xbb", "\xf3\xbe\x87\x88", "\xf3\xbe\x87\x9d", "\xf3\xbe\x86\xbc", "\xf3\xbe\x87\x98", "\xf3\xbe\x86\xbd", "\xf3\xbe\x87\x87", "\xf3\xbe\x87\x82", "\xf3\xbe\x87\x80", "\xf3\xbe\x86\xb8", "\xf3\xbe\x87\x83", "\xf3\xbe\x86\xbe", "\xf3\xbe\x87\x84", "\xf3\xbe\x86\xb7", "\xf3\xbe\x86\xbf", "\xf3\xbe\x87\x81", "\xf3\xbe\x87\x8a", "\xf3\xbe\x87\x90", "\xf3\xbe\x87\x91", "\xf3\xbe\x87\x92", "\xf3\xbe\x87\x97", "\xf3\xbe\x87\x9b", "\xf3\xbe\x87\x9e", "\xf3\xbe\x87\x9f", "\xf3\xbe\x87\xa0", "\xf3\xbe\x8c\xa0", "\xf3\xbe\x8c\xa1", "\xf3\xbe\x8c\xa2", "\xf3\xbe\x8c\xa3", "\xf3\xbe\x8c\xa4", "\xf3\xbe\x8c\xa5", "\xf3\xbe\x8c\xa6", "\xf3\xbe\x8c\xa7", "\xf3\xbe\x8c\xa8", "\xf3\xbe\x8c\xa9", "\xf3\xbe\x8c\xaa", "\xf3\xbe\x8c\xab", "\xf3\xbe\x8c\xac", "\xf3\xbe\x8c\xad", "\xf3\xbe\x8c\xae", "\xf3\xbe\x8c\xaf", "\xf3\xbe\x8c\xb0", "\xf3\xbe\x8c\xb1", "\xf3\xbe\x8c\xb2", "\xf3\xbe\x8c\xb3", "\xf3\xbe\x8c\xb4", "\xf3\xbe\x8c\xb5", "\xf3\xbe\x8c\xb6", "\xf3\xbe\x8c\xb8", "\xf3\xbe\x8c\xb9", "\xf3\xbe\x8c\xba", "\xf3\xbe\x8c\xbb", "\xf3\xbe\x8c\xbc", "\xf3\xbe\x8c\xbd", "\xf3\xbe\x8c\xbe", "\xf3\xbe\x8c\xbf", "\xf3\xbe\x8d\x80", "\xf3\xbe\x8d\x81", "\xf3\xbe\x8d\x82", "\xf3\xbe\x8d\x83", "\xf3\xbe\x8d\x84", "\xf3\xbe\x8d\x85", "\xf3\xbe\x8d\x86", "\xf3\xbe\x8d\x87", "\xf3\xbe\x8d\x88", "\xf3\xbe\x8d\x89", "\xf3\xbe\x8d\x8a", "\xf3\xbe\x8d\x8b", "\xf3\xbe\x8d\x8c", "\xf3\xbe\x8d\x8d", "\xf3\xbe\x8d\x8e", "\xf3\xbe\x8d\x8f", "\xf3\xbe\x8d\x90", "\xf3\xbe\x8d\x91", "\xf3\xbe\x8d\x92", "\xf3\xbe\x8d\x93", "\xf3\xbe\x8d\x94", "\xf3\xbe\x8d\x95", "\xf3\xbe\x8d\x96", "\xf3\xbe\x8d\x97", "\xf3\xbe\x8d\x98", "\xf3\xbe\x8d\x99", "\xf3\xbe\x8d\x9a", "\xf3\xbe\x8d\x9b", "\xf3\xbe\x92\xb0", "\xf3\xbe\x92\xb1", "\xf3\xbe\x92\xb2", "\xf3\xbe\x92\xb3", "\xf3\xbe\x92\xb4", "\xf3\xbe\x92\xb5", "\xf3\xbe\x92\xb6", "\xf3\xbe\x92\xb7", "\xf3\xbe\x92\xb8", "\xf3\xbe\x92\xb9", "\xf3\xbe\x92\xba", "\xf3\xbe\x92\xbb", "\xf3\xbe\x92\xbc", "\xf3\xbe\x92\xbd", "\xf3\xbe\x92\xbe", "\xf3\xbe\x92\xbf", "\xf3\xbe\x93\x80", "\xf3\xbe\x93\x81", "\xf3\xbe\x93\x82", "\xf3\xbe\x93\x83", "\xf3\xbe\x93\x84", "\xf3\xbe\x93\x86", "\xf3\xbe\x93\x87", "\xf3\xbe\x93\x88", "\xf3\xbe\x93\x8c", "\xf3\xbe\x93\x8d", "\xf3\xbe\x93\x96", "\xf3\xbe\x93\x97", "\xf3\xbe\x93\x98", "\xf3\xbe\x95\x93", "\xf3\xbe\x93\x8e", "\xf3\xbe\x93\x8f", "\xf3\xbe\x93\x90", "\xf3\xbe\x93\x91", "\xf3\xbe\x93\x93", "\xf3\xbe\x93\x94", "\xf3\xbe\x93\x95", "\xf3\xbe\x93\x99", "\xf3\xbe\x93\x9a", "\xf3\xbe\x93\x9b", "\xf3\xbe\x93\x9c", "\xf3\xbe\x93\xb0", "\xf3\xbe\x93\xb1", "\xf3\xbe\x93\x9d", "\xf3\xbe\x93\x9e", "\xf3\xbe\x93\x9f", "\xf3\xbe\x93\xa0", "\xf3\xbe\x93\xa1", "\xf3\xbe\x93\xa2", "\xf3\xbe\x93\xa3", "\xf3\xbe\x93\xa4", "\xf3\xbe\x93\xad", "\xf3\xbe\x93\xa8", "\xf3\xbe\x93\xab", "\xf3\xbe\x93\xa7", "\xf3\xbe\x93\xaa", "\xf3\xbe\x93\xa9", "\xf3\xbe\x93\xa5", "\xf3\xbe\x93\xae", "\xf3\xbe\x93\xac", "\xf3\xbe\x93\xa6", "\xf3\xbe\x93\xb6", "\xf3\xbe\x93\xbb", "\xf3\xbe\x93\x89", "\xf3\xbe\x93\x8a", "\xf3\xbe\x93\x8b", "\xf3\xbe\x93\xba", "\xf3\xbe\x93\xb5", "\xf3\xbe\x93\xb7", "\xf3\xbe\x93\xb8", "\xf3\xbe\x81\x84", "\xf3\xbe\x93\x92", "\xf3\xbe\x94\x89", "\xf3\xbe\x94\x8a", "\xf3\xbe\x94\x8b", "\xf3\xbe\x94\x8c", "\xf3\xbe\x94\x8d", "\xf3\xbe\x94\x8e", "\xf3\xbe\x94\x8f", "\xf3\xbe\x94\x90", "\xf3\xbe\x94\x91", "\xf3\xbe\x94\x92", "\xf3\xbe\x94\x93", "\xf3\xbe\x94\x94", "\xf3\xbe\x94\x95", "\xf3\xbe\x94\x96", "\xf3\xbe\x94\x97", "\xf3\xbe\x94\x98", "\xf3\xbe\x94\x99", "\xf3\xbe\x94\x9a", "\xf3\xbe\x94\x9b", "\xf3\xbe\x94\x9c", "\xf3\xbe\x94\x9d", "\xf3\xbe\x94\x9e", "\xf3\xbe\x94\x9f", "\xf3\xbe\x94\xa0", "\xf3\xbe\x94\xa1", "\xf3\xbe\x80\x97", "\xf3\xbe\x94\xa2", "\xf3\xbe\x94\xa3", "\xf3\xbe\x94\xa4", "\xf3\xbe\x94\xa5", "\xf3\xbe\x94\xa6", "\xf3\xbe\x94\xa7", "\xf3\xbe\x94\xa8", "\xf3\xbe\x94\xa9", "\xf3\xbe\x94\xaa", "\xf3\xbe\x94\xab", "\xf3\xbe\x94\xac", "\xf3\xbe\x94\xad", "\xf3\xbe\x94\xae", "\xf3\xbe\xa0\xa2", "\xf3\xbe\x94\xaf", "\xf3\xbe\x94\xb0", "\xf3\xbe\x94\xb1", "\xf3\xbe\x94\xb3", "\xf3\xbe\x94\xb4", "\xf3\xbe\x94\xb5", "\xf3\xbe\xae\x92", "\xf3\xbe\xad\xbc", "\xf3\xbe\xad\xbd", "\xf3\xbe\xad\xbe", "\xf3\xbe\xad\xbf", "\xf3\xbe\xae\x80", "\xf3\xbe\x94\xb6", "\xf3\xbe\x94\xb7", "\xf3\xbe\x94\xb8", "\xf3\xbe\x94\xb9", "\xf3\xbe\x94\xba", "\xf3\xbe\x94\xbb", "\xf3\xbe\x94\xbc", "\xf3\xbe\x94\xbd", "\xf3\xbe\xa0\x9d", "\xf3\xbe\xa0\x9e", "\xf3\xbe\x94\xbe", "\xf3\xbe\x94\xbf", "\xf3\xbe\x95\x80", "\xf3\xbe\x95\x81", "\xf3\xbe\x95\x82", "\xf3\xbe\x95\x83", "\xf3\xbe\x95\x84", "\xf3\xbe\x95\x85", "\xf3\xbe\x95\x86", "\xf3\xbe\x95\x87", "\xf3\xbe\x94\x82", "\xf3\xbe\x93\xbf", "\xf3\xbe\x94\x80", "\xf3\xbe\x94\x81", "\xf3\xbe\x94\x83", "\xf3\xbe\x94\x84", "\xf3\xbe\x93\xbd", "\xf3\xbe\x95\x88", "\xf3\xbe\x95\x89", "\xf3\xbe\x95\x8a", "\xf3\xbe\x95\x8b", "\xf3\xbe\x95\x8c", "\xf3\xbe\x95\x8d", "\xf3\xbe\x95\x8e", "\xf3\xbe\x95\x8f", "\xf3\xbe\x95\x90", "\xf3\xbe\x95\x91", "\xf3\xbe\x95\x92", "\xf3\xbe\x9f\x90", "\xf3\xbe\x9f\x91", "\xf3\xbe\x9f\x92", "\xf3\xbe\x9f\x93", "\xf3\xbe\x9f\x94", "\xf3\xbe\x9f\x95", "\xf3\xbe\x9f\x96", "\xf3\xbe\x9f\x97", "\xf3\xbe\x9f\x98", "\xf3\xbe\x9f\x99", "\xf3\xbe\x9f\x9a", "\xf3\xbe\x9f\x9b", "\xf3\xbe\x9f\x9d", "\xf3\xbe\x9f\x9e", "\xf3\xbe\x9f\x9f", "\xf3\xbe\x9f\xa0", "\xf3\xbe\x9f\xa1", "\xf3\xbe\x9f\xa2", "\xf3\xbe\x9f\xa3", "\xf3\xbe\x9f\xa4", "\xf3\xbe\x9f\xa5", "\xf3\xbe\x9f\xa6", "\xf3\xbe\x9f\xa7", "\xf3\xbe\x9f\xa8", "\xf3\xbe\x9f\xa9", "\xf3\xbe\x9f\xaa", "\xf3\xbe\x9f\xac", "\xf3\xbe\x9f\xad", "\xf3\xbe\x9f\xae", "\xf3\xbe\x9f\xaf", "\xf3\xbe\x9f\xb1", "\xf3\xbe\x9f\xb2", "\xf3\xbe\x9f\xb3", "\xf3\xbe\x9f\xb4", "\xf3\xbe\x9f\xb5", "\xf3\xbe\x9f\xb6", "\xf3\xbe\x9f\xb7", "\xf3\xbe\x9f\xb8", "\xf3\xbe\x9f\xb9", "\xf3\xbe\x9f\xba", "\xf3\xbe\x9f\xbb", "\xf3\xbe\x9f\xbc", "\xf3\xbe\x9f\xbd", "\xf3\xbe\x9f\xbe", "\xf3\xbe\x9f\xbf", "\xf3\xbe\xa0\x80", "\xf3\xbe\xa0\x81", "\xf3\xbe\xa0\x82", "\xf3\xbe\xa0\x83", "\xf3\xbe\xa0\x84", "\xf3\xbe\xa0\x85", "\xf3\xbe\xa0\x86", "\xf3\xbe\xa0\x87", "\xf3\xbe\xa0\x88", "\xf3\xbe\xa0\x89", "\xf3\xbe\xa0\x8a", "\xf3\xbe\xa0\x8b", "\xf3\xbe\xa0\x8c", "\xf3\xbe\xa0\x8d", "\xf3\xbe\xa0\x8e", "\xf3\xbe\xa0\x8f", "\xf3\xbe\xa0\x90", "\xf3\xbe\xa0\x91", "\xf3\xbe\xa0\x92", "\xf3\xbe\xa0\x93", "\xf3\xbe\xa0\x94", "\xf3\xbe\xa0\x95", "\xf3\xbe\xa0\x96", "\xf3\xbe\xa0\x97", "\xf3\xbe\xa0\x98", "\xf3\xbe\xa0\x99", "\xf3\xbe\xa0\x9a", "\xf3\xbe\xa0\x9b", "\xf3\xbe\x93\xaf", "\xf3\xbe\x93\xb9", "\xf3\xbe\xa0\x9c", "\xf3\xbe\xa0\x9f", "\xf3\xbe\xa0\xa0", "\xf3\xbe\xa0\xa3", "\xf3\xbe\xa0\xa4", "\xf3\xbe\xa0\xa5", "\xf3\xbe\xa0\xa6", "\xf3\xbe\xa0\xa7", "\xf3\xbe\xa0\xa8", "\xf3\xbe\xa0\xa9", "\xf3\xbe\xa0\xaa", "\xf3\xbe\xac\xa5", "\xf3\xbe\xac\xa9", "\xf3\xbe\xac\xad", "\xf3\xbe\xac\xaa", "\xf3\xbe\xad\x87", "\xf3\xbe\xa0\xac", "\xf3\xbe\xa0\xae", "\xf3\xbe\xa0\xaf", "\xf3\xbe\xa0\xb0", "\xf3\xbe\xa0\xb1", "\xf3\xbe\xa0\xb2", "\xf3\xbe\xa0\xb3", "\xf3\xbe\xa0\xb4", "\xf3\xbe\xa0\xb5", "\xf3\xbe\xa0\xb6", "\xf3\xbe\xa0\xb7", "\xf3\xbe\xa0\xbb", "\xf3\xbe\xa0\xb8", "\xf3\xbe\xa0\xb9", "\xf3\xbe\xa0\xba", "\xf3\xbe\xa5\xa0", "\xf3\xbe\xa5\xa1", "\xf3\xbe\xa5\xa2", "\xf3\xbe\xa5\xa3", "\xf3\xbe\xa5\xa4", "\xf3\xbe\xa5\xa5", "\xf3\xbe\xa5\xa6", "\xf3\xbe\xa5\xa7", "\xf3\xbe\xa5\xa8", "\xf3\xbe\xa5\xa9", "\xf3\xbe\xa5\xaa", "\xf3\xbe\xa5\xab", "\xf3\xbe\xa5\xac", "\xf3\xbe\xa5\xad", "\xf3\xbe\xa5\xae", "\xf3\xbe\xa5\xaf", "\xf3\xbe\xa5\xb0", "\xf3\xbe\xa5\xb1", "\xf3\xbe\xa5\xb2", "\xf3\xbe\xa5\xb3", "\xf3\xbe\xa5\xb4", "\xf3\xbe\xa5\xb5", "\xf3\xbe\xa5\xb6", "\xf3\xbe\xa5\xb7", "\xf3\xbe\xa5\xb8", "\xf3\xbe\xa5\xb9", "\xf3\xbe\xa5\xba", "\xf3\xbe\xa5\xbb", "\xf3\xbe\xa5\xbc", "\xf3\xbe\xa5\xbd", "\xf3\xbe\xa5\xbe", "\xf3\xbe\xa5\xbf", "\xf3\xbe\xa6\x80", "\xf3\xbe\xa6\x81", "\xf3\xbe\xa6\x82", "\xf3\xbe\xa6\x83", "\xf3\xbe\xa6\x84", "\xf3\xbe\xa6\x85", "\xf3\xbe\xa6\x86", "\xf3\xbe\xa6\x87", "\xf3\xbe\xa6\x88", "\xf3\xbe\xab\xb0", "\xf3\xbe\xab\xb1", "\xf3\xbe\xab\xb2", "\xf3\xbe\xab\xb3", "\xf3\xbe\xab\xb4", "\xf3\xbe\xab\xb5", "\xf3\xbe\xab\xb6", "\xf3\xbe\xab\xb7", "\xf3\xbe\xab\xb8", "\xf3\xbe\xab\xb9", "\xf3\xbe\xab\xba", "\xf3\xbe\xab\xbb", "\xf3\xbe\xab\xbc", "\xf3\xbe\xab\xbd", "\xf3\xbe\xab\xbe", "\xf3\xbe\xab\xbf", "\xf3\xbe\xac\x83", "\xf3\xbe\xac\x82", "\xf3\xbe\xad\xb8", "\xf3\xbe\xad\xb9", "\xf3\xbe\xac\x81", "\xf3\xbe\xac\x80", "\xf3\xbe\xad\x84", "\xf3\xbe\xad\x85", "\xf3\xbe\xad\x86", "\xf3\xbe\xac\x84", "\xf3\xbe\xac\x85", "\xf3\xbe\xac\x86", "\xf3\xbe\xac\x89", "\xf3\xbe\xac\x8a", "\xf3\xbe\xac\x8b", "\xf3\xbe\xac\x87", "\xf3\xbe\xac\x88", "\xf3\xbe\xa0\xab", "\xf3\xbe\xac\x8c", "\xf3\xbe\xac\x8d", "\xf3\xbe\xac\x8e", "\xf3\xbe\xac\x8f", "\xf3\xbe\xac\x90", "\xf3\xbe\xac\x91", "\xf3\xbe\xac\x92", "\xf3\xbe\xac\x93", "\xf3\xbe\xac\x94", "\xf3\xbe\xac\x95", "\xf3\xbe\xac\x96", "\xf3\xbe\xac\x97", "\xf3\xbe\xac\x98", "\xf3\xbe\xac\x99", "\xf3\xbe\xac\x9a", "\xf3\xbe\xac\x9b", "\xf3\xbe\xac\x9c", "\xf3\xbe\xac\x9d", "\xf3\xbe\xac\x9e", "\xf3\xbe\xac\x9f", "\xf3\xbe\xac\xa0", "\xf3\xbe\xac\xa2", "\xf3\xbe\xac\xa3", "\xf3\xbe\xac\xa6", "\xf3\xbe\xac\xac", "\xf3\xbe\x9f\xab", "\xf3\xbe\x9f\xb0", "\xf3\xbe\xac\xb3", "\xf3\xbe\xac\xb4", "\xf3\xbe\x94\x85", "\xf3\xbe\x94\x86", "\xf3\xbe\x94\x87", "\xf3\xbe\x94\x88", "\xf3\xbe\xac\xb5", "\xf3\xbe\x93\xb3", "\xf3\xbe\xad\x88", "\xf3\xbe\xad\x89", "\xf3\xbe\xae\x84", "\xf3\xbe\xac\xb8", "\xf3\xbe\xac\xa1", "\xf3\xbe\xae\x81", "\xf3\xbe\xac\xb6", "\xf3\xbe\xac\xa8", "\xf3\xbe\xac\xa7", "\xf3\xbe\xad\x8f", "\xf3\xbe\xac\xb7", "\xf3\xbe\xac\xb2", "\xf3\xbe\xac\xa4", "\xf3\xbe\xac\xbf", "\xf3\xbe\xac\xae", "\xf3\xbe\xac\xaf", "\xf3\xbe\xac\xb0", "\xf3\xbe\xac\xb1", "\xf3\xbe\xac\xb9", "\xf3\xbe\xac\xba", "\xf3\xbe\xac\xbb", "\xf3\xbe\xac\xbc", "\xf3\xbe\xac\xbe", "\xf3\xbe\xad\x80", "\xf3\xbe\xad\x81", "\xf3\xbe\xac\xab", "\xf3\xbe\xad\x83", "\xf3\xbe\xac\xbd", "\xf3\xbe\xad\x90", "\xf3\xbe\xad\x91", "\xf3\xbe\xad\x92", "\xf3\xbe\xad\x93", "\xf3\xbe\xad\x94", "\xf3\xbe\xad\x95", "\xf3\xbe\xad\x96", "\xf3\xbe\xad\x97", "\xf3\xbe\xad\x98", "\xf3\xbe\xad\x99", "\xf3\xbe\xad\x9a", "\xf3\xbe\xad\x9b", "\xf3\xbe\xad\x9c", "\xf3\xbe\xad\x9d", "\xf3\xbe\x93\xb4", "\xf3\xbe\xad\x9e", "\xf3\xbe\xad\x9f", "\xf3\xbe\x94\xb2", "\xf3\xbe\xad\xa0", "\xf3\xbe\xad\xa1", "\xf3\xbe\xad\xa2", "\xf3\xbe\xad\xa5", "\xf3\xbe\xad\xa6", "\xf3\xbe\xad\xa3", "\xf3\xbe\xad\xa4", "\xf3\xbe\xad\xa7", "\xf3\xbe\xad\xa8", "\xf3\xbe\xad\xab", "\xf3\xbe\xad\xac", "\xf3\xbe\xad\xad", "\xf3\xbe\xad\xae", "\xf3\xbe\xad\xaf", "\xf3\xbe\xad\xb0", "\xf3\xbe\xad\xb1", "\xf3\xbe\xad\xb2", "\xf3\xbe\xad\xb3", "\xf3\xbe\xad\xb4", "\xf3\xbe\xad\xb5", "\xf3\xbe\xad\xb6", "\xf3\xbe\xad\xb7", "\xf3\xbe\xad\xba", "\xf3\xbe\xad\xbb", "\xf3\xbe\xae\x83", "\xf3\xbe\xae\x88", "\xf3\xbe\xae\x91", "\xf3\xbe\xa0\xa1", "\xf3\xbe\x93\xbc", "\xf3\xbe\x93\xbe", "\xf3\xbe\xae\x85", "\xf3\xbe\xae\x8d", "\xf3\xbe\xae\x86", "\xf3\xbe\xae\x87", "\xf3\xbe\xae\x90", "\xf3\xbe\xae\x8a", "\xf3\xbe\xae\x82", "\xf3\xbe\x93\xb2", "\xf3\xbe\xae\x8b", "\xf3\xbe\xae\x8c", "\xf3\xbe\xae\x8f", "\xf3\xbe\xad\x8b", "\xf3\xbe\xae\x8e", "\xf3\xbe\x80\x9a", "\xf3\xbe\x80\x99", "\xf3\xbe\x80\x98", "\xf3\xbe\xad\x82", "\xf3\xbe\xad\x8a", "\xf3\xbe\xae\x93", "\xf3\xbe\xae\x95", "\xf3\xbe\xae\x94", "\xf3\xbe\xae\x96", "\xf3\xbe\xae\x97", "\xf3\xbe\xae\x98", "\xf3\xbe\xae\x99", "\xf3\xbe\xae\x9a", "\xf3\xbe\xae\x9b", "\xf3\xbe\xae\x9c", "\xf3\xbe\xae\x9d", "\xf3\xbe\xae\x9e", "\xf3\xbe\xae\x9f", "\xf3\xbe\xae\xa0", "\xf3\xbe\xae\xa1"
		);
	}

}

class WeChatHook {

	public static function bindOpenId($uid, $openid, $isregister = 0) {
		C::t('#wechat#common_member_wechat')->insert(array('uid' => $uid, 'status' => 2, 'openid' => $openid, 'isregister' => $isregister), false, true);
	}

	public static function updateAppInfo($extId, $appId = '', $appSecret = '') {
		global $_G;
		$wechatappInfos = unserialize($_G['setting']['wechatappInfos']);
		if ($appId) {
			$wechatappInfos[$extId] = array('appId' => $appId, 'appSecret' => $appSecret);
		} else {
			unset($wechatappInfos[$extId]);
		}
		$settings = array('wechatappInfos' => serialize($wechatappInfos));
		C::t('common_setting')->update_batch($settings);
		updatecache('setting');
	}

	public static function getAppInfo($extId) {
		global $_G;
		$wechatappInfos = unserialize($_G['setting']['wechatappInfos']);
		if (isset($wechatappInfos[$extId])) {
			return $wechatappInfos[$extId];
		} else {
			return array();
		}
	}

	public static function updateResponse($data, $extId = '') {
		$response = self::getResponse($extId);
		foreach ($data as $key => $value) {
			if ($value) {
				if ($value['plugin'] && $value['include'] && $value['class'] && $value['method']) {
					$response[$key] = $value;
				}
			} else {
				unset($response[$key]);
			}
		}
		if (!$extId) {
			$settings = array('wechatresponse' => serialize($response));
		} else {
			global $_G;
			$wechatresponseExts = unserialize($_G['setting']['wechatresponseExts']);
			if ($data) {
				$wechatresponseExts[$extId] = $response;
			} else {
				unset($wechatresponseExts[$extId]);
			}
			$settings = array('wechatresponseExts' => serialize($wechatresponseExts));
		}
		C::t('common_setting')->update_batch($settings);
		updatecache('setting');
		return $response;
	}

	public static function getResponse($extId = '') {
		global $_G;
		if (!$extId) {
			return unserialize($_G['setting']['wechatresponse']);
		} else {
			$wechatresponseExts = unserialize($_G['setting']['wechatresponseExts']);
			return $wechatresponseExts[$extId];
		}
	}

	public static function updateRedirect($value) {
		if (!$value || $value['plugin'] && $value['include'] && $value['class'] && $value['method']) {
			$settings = array('wechatredirect' => $value);
			C::t('common_setting')->update_batch($settings);
			updatecache('setting');
		}
	}

	public static function getRedirect() {
		global $_G;
		return unserialize($_G['setting']['wechatredirect']);
	}

	public static function getViewPluginId() {
		global $_G;
		return $_G['setting']['wechatviewpluginid'];
	}

	public static function updateViewPluginId($value) {
		$settings = array('wechatviewpluginid' => $value);
		C::t('common_setting')->update_batch($settings);
		updatecache('setting');
	}

	public static function updateAPIHook($datas) {
		$apihook = self::getAPIHook();
		foreach ($datas as $data) {
			foreach ($data as $key => $value) {
				if (!$value['plugin']) {
					continue;
				}
				list($module, $hookname) = explode('_', $key);
				if ($value['include'] && $value['class'] && $value['method']) {
					$v = $value;
					unset($v['plugin']);
					$v['allow'] = 1;
					$apihook[$module][$hookname][$value['plugin']] = $v;
				} else {
					unset($apihook[$module][$hookname][$value['plugin']]);
				}
			}
		}
		$settings = array('mobileapihook' => serialize($apihook));
		C::t('common_setting')->update_batch($settings);
		updatecache('setting');
		return $apihook;
	}

	public static function getAPIHook($getplugin = '') {
		global $_G;
		$data = unserialize($_G['setting']['mobileapihook']);
		if (!$getplugin) {
			return $data;
		} else {
			foreach ($data as $key => $hooknames) {
				foreach ($hooknames as $hookname => $plugins) {
					foreach ($plugins as $plugin => $value) {
						if ($getplugin != $plugin) {
							unset($data[$key][$hookname][$plugin]);
						}
					}
				}
			}
			return $data;
		}
	}

	public static function delAPIHook($getplugin) {
		if (!$getplugin) {
			return;
		}
		$getplugins = (array) $getplugin;
		$apihook = self::getAPIHook();
		foreach ($apihook as $key => $hooknames) {
			foreach ($hooknames as $hookname => $plugins) {
				foreach ($plugins as $plugin => $value) {
					if (in_array($plugin, $getplugins)) {
						unset($apihook[$key][$hookname][$plugin]);
					}
				}
			}
		}
		$settings = array('mobileapihook' => serialize($apihook));
		C::t('common_setting')->update_batch($settings);
		updatecache('setting');
		return $apihook;
	}

	public static function getPluginUrl($pluginid, $param = array()) {
		global $_G;
		if (in_array('plugin', $_G['setting']['rewritestatus'])) {
			$url = $_G['siteurl'] . rewriteoutput('plugin', 1, 'wechat', 'access') . '?';
		} else {
			$url = $_G['siteurl'] . 'plugin.php?id=wechat:access&';
		}
		$url .= 'pluginid=' . urlencode($pluginid) . '&param=' . urlencode(base64_encode(http_build_query($param)));
		return $url;
	}

}