<?php

class navModel extends Model
{

    /**
     * 读取导航信息写入缓存
     */
    public function nav_cache() {
        $nav_list = array();
        $nav_data = $this->field('type,name,alias,link,target,class')->where('status=1')->order('ordid')->select();
        foreach ($nav_data as $val) {
            switch ($val['type']) {
                case 'main':
                    $nav_list['main'][] = $val;
                    break;
					
				case 'cate':
                    $nav_list['cate'][] = $val;
                    break;
					
				case 'fs':
                    $nav_list['fs'][] = $val;
                    break;
                
                case 'top':
                    $nav_list['top'][] = $val;
                    break;
					
				case 'jiu':
                    $nav_list['jiu'][] = $val;
                    break;
            }
        }
        F('nav_list', $nav_list);
        return $nav_list;
    }

    /**
     * 更新则删除缓存
     */
    protected function _before_write(&$data) {
        F('nav_list', NULL);
    }

    /**
     * 删除也删除缓存
     */
    protected function _after_delete($data, $options) {
        F('nav_list', NULL);
    }
}