/*
 * Copyright 2018 Diffblue Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.parser.JSONScanner;
import com.diffblue.deeptestutils.Reflector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Locale;


public class JSONScannerTest {

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  /* testedClasses: JSONScanner */


  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 82 branch to line 83
   */

  @Test
  public void charArrayCompare1() throws Throwable {

    // Arrange
    String src = "";
    int offset = 7;
    char[] dest = { '\u0000' };

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("charArrayCompare", Reflector.forName("java.lang.String"), Reflector.forName("int"), Reflector.forName("char []"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, src, offset, dest);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.This test covers `boolean
   * charArrayCompare(String, char [])' block 2 (line 81)
   * This test covers `boolean charArrayCompare(String, char [])' block 3 (line
   * 82)
   * This test covers `boolean charArrayCompare(String, char [])' block 4 (line
   * 82)
   * This test covers `boolean charArrayCompare(String, char [])' block 5 (line
   * 86)
   * This test covers `boolean charArrayCompare(String, char [])' block 7 (line
   * 86)
   * This test covers `boolean charArrayCompare(String, char [])' block 8 (line
   * 86)
   * This test covers `boolean charArrayCompare(String, char [])' block 10
   * (line 87)
   * This test covers `boolean charArrayCompare(String, char [])' block 11
   * (line 87)
   * This test covers `boolean charArrayCompare(String, char [])' block 13
   * (line 88)
   *
   */

  @Test
  public void charArrayCompare3() throws Throwable {

    // Arrange
    String src = "!!!!!!!\"&&";
    int offset = 6;
    char[] dest = { '\u0000' };

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("charArrayCompare", Reflector.forName("java.lang.String"), Reflector.forName("int"), Reflector.forName("char []"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, src, offset, dest);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 82 branch to line 86
   *
   */

  @Test
  public void charArrayCompare4() throws Throwable {

    // Arrange
    String src = "!\"&&&&&";
    int offset = 0;
    char[] dest = { };

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("charArrayCompare", Reflector.forName("java.lang.String"), Reflector.forName("int"), Reflector.forName("char []"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, src, offset, dest);

    // Assert result
    Assert.assertEquals(true, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 719
   *  - conditional line 719 branch to line 723
   *  - conditional line 723 branch to line 724
   *  - conditional line 724 branch to line 731
   */

  @Test
  public void checkDate1() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 51;
    int d1 = 48;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(true, retval);

  }
  
  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 704
   *  - conditional line 704 branch to line 704
   *  - conditional line 704 branch to line 705
   */

  @Test
  public void checkDate2() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '0';
    char M1 = '\u8031';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 720
   *  - conditional line 720 branch to line 720
   *  - conditional line 720 branch to line 721
   */

  @Test
  public void checkDate3() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 49;
    int d1 = 32810;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }


  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 719
   *  - conditional line 719 branch to line 720
   *  - conditional line 720 branch to line 720
   *  - conditional line 720 branch to line 721
   */

  @Test
  public void checkDate4() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 50;
    int d1 = 32810;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 691
   */

  @Test
  public void checkDate5() throws Throwable {

    // Arrange
    char y0 = '4';
    char y1 = '\u0000';
    char y2 = '\u0000';
    char y3 = '\u0000';
    char M0 = '\u0000';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 691
   */

  @Test
  public void checkDate6() throws Throwable {

    // Arrange
    char y0 = '\u0000';
    char y1 = '\u0000';
    char y2 = '\u0000';
    char y3 = '\u0000';
    char M0 = '\u0000';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 704
   *  - conditional line 704 branch to line 705
   */

  @Test
  public void checkDate7() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '0';
    char y3 = '0';
    char M0 = '0';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 694
   */

  @Test
  public void checkDate8() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '\u0011';
    char y2 = '0';
    char y3 = '\u0830';
    char M0 = '1';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 720
   *  - conditional line 720 branch to line 720
   *  - conditional line 720 branch to line 731
   */

  @Test
  public void checkDate9() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 49;
    int d1 = 49;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(true, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 719
   *  - conditional line 719 branch to line 723
   *  - conditional line 723 branch to line 728
   */

  @Test
  public void checkDate10() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 8388658;
    int d1 = 32810;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 716
   *  - conditional line 716 branch to line 716
   *  - conditional line 716 branch to line 731
   */

  @Test
  public void checkDate11() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 48;
    int d1 = 49;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(true, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 697
   */

  @Test
  public void checkDate12() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '\u8030';
    char y3 = '\u0830';
    char M0 = '1';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 716
   *  - conditional line 716 branch to line 717
   */

  @Test
  public void checkDate13() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 48;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 715
   *  - conditional line 715 branch to line 719
   *  - conditional line 719 branch to line 719
   *  - conditional line 719 branch to line 723
   *  - conditional line 723 branch to line 724
   *  - conditional line 724 branch to line 724
   *  - conditional line 724 branch to line 725
   */

  @Test
  public void checkDate14() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '0';
    int d0 = 51;
    int d1 = -2147483600;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 708
   *  - conditional line 708 branch to line 708
   *  - conditional line 708 branch to line 709
   */

  @Test
  public void checkDate15() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '1';
    char y3 = '1';
    char M0 = '1';
    char M1 = '\u8031';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 700
   */

  @Test
  public void checkDate16() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '0';
    char y3 = '\u0830';
    char M0 = '1';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 690 branch to line 690
   *  - conditional line 690 branch to line 693
   *  - conditional line 693 branch to line 693
   *  - conditional line 693 branch to line 696
   *  - conditional line 696 branch to line 696
   *  - conditional line 696 branch to line 699
   *  - conditional line 699 branch to line 699
   *  - conditional line 699 branch to line 703
   *  - conditional line 703 branch to line 707
   *  - conditional line 707 branch to line 712
   */

  @Test
  public void checkDate17() throws Throwable {

    // Arrange
    char y0 = '2';
    char y1 = '1';
    char y2 = '0';
    char y3 = '0';
    char M0 = '\u0000';
    char M1 = '\u0000';
    int d0 = 0;
    int d1 = 0;

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkDate", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("int"), Reflector.forName("int"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(null, y0, y1, y2, y3, M0, M1, d0, d1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 643
   *  - conditional line 643 branch to line 648
   */

  @Test
  public void checkTime1() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '\u0000';
    char h1 = '\u0000';
    char m0 = '\u0000';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 643
   *  - conditional line 643 branch to line 644
   *  - conditional line 644 branch to line 645
   */

  @Test
  public void checkTime2() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '2';
    char h1 = '\u0000';
    char m0 = '\u0000';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 636
   *  - conditional line 636 branch to line 636
   *  - conditional line 636 branch to line 637
   */

  @Test
  public void checkTime3() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '0';
    char h1 = '<';
    char m0 = '\u0000';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 636
   *  - conditional line 636 branch to line 637
   */

  @Test
  public void checkTime4() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '0';
    char h1 = ' ';
    char m0 = '\u0000';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 643
   *  - conditional line 643 branch to line 644
   *  - conditional line 644 branch to line 644
   *  - conditional line 644 branch to line 645
   */

  @Test
  public void checkTime5() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '2';
    char h1 = '5';
    char m0 = '\u0000';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 636
   *  - conditional line 636 branch to line 636
   *  - conditional line 636 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 652
   *  - conditional line 652 branch to line 653
   */

  @Test
  public void checkTime6() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '0';
    char h1 = '9';
    char m0 = '1';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 641
   */

  @Test
  public void checkTime7() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '=';
    char m0 = '1';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 652
   *  - conditional line 652 branch to line 653
   */

  @Test
  public void checkTime8() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '1';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 660
   */

  @Test
  public void checkTime9() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = ' ';
    char m1 = '\u0000';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 652
   *  - conditional line 652 branch to line 652
   *  - conditional line 652 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 664
   *  - conditional line 664 branch to line 665
   */

  @Test
  public void checkTime10() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '4';
    char m1 = '3';
    char s0 = '1';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 656
   *  - conditional line 656 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 664
   *  - conditional line 664 branch to line 664
   *  - conditional line 664 branch to line 665
   */

  @Test
  public void checkTime11() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '6';
    char m1 = '0';
    char s0 = '1';
    char s1 = '\u0430';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 656
   *  - conditional line 656 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 667
   *  - conditional line 667 branch to line 668
   *  - conditional line 668 branch to line 669
   */

  @Test
  public void checkTime12() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '6';
    char m1 = '0';
    char s0 = '6';
    char s1 = '\u0430';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 656
   *  - conditional line 656 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 667
   *  - conditional line 667 branch to line 672
   */

  @Test
  public void checkTime13() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '6';
    char m1 = '0';
    char s0 = '>';
    char s1 = '\u0430';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 656
   *  - conditional line 656 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 667
   *  - conditional line 667 branch to line 668
   *  - conditional line 668 branch to line 675
   */

  @Test
  public void checkTime14() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '6';
    char m1 = '0';
    char s0 = '6';
    char s1 = '0';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(true, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 652
   *  - conditional line 652 branch to line 652
   *  - conditional line 652 branch to line 663
   *  - conditional line 663 branch to line 663
   *  - conditional line 663 branch to line 664
   *  - conditional line 664 branch to line 664
   *  - conditional line 664 branch to line 665
   */

  @Test
  public void checkTime15() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '4';
    char m1 = '3';
    char s0 = '1';
    char s1 = '\u0430';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 652
   *  - conditional line 652 branch to line 652
   *  - conditional line 652 branch to line 653
   */

  @Test
  public void checkTime16() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '4';
    char m1 = ':';
    char s0 = '\u0000';
    char s1 = '\u0000';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 635 branch to line 639
   *  - conditional line 639 branch to line 640
   *  - conditional line 640 branch to line 640
   *  - conditional line 640 branch to line 651
   *  - conditional line 651 branch to line 651
   *  - conditional line 651 branch to line 655
   *  - conditional line 655 branch to line 656
   *  - conditional line 656 branch to line 657
   */

  @Test
  public void checkTime17() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;
    char h0 = '1';
    char h1 = '9';
    char m0 = '6';
    char m1 = '1';
    char s0 = '1';
    char s1 = '\u0430';

    // Act
    Class<?> c = Reflector.forName("com.alibaba.fastjson.parser.JSONScanner");
    Method m = c.getDeclaredMethod("checkTime", Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"), Reflector.forName("char"));
    m.setAccessible(true);
    boolean retval = (Boolean)m.invoke(objectUnderTest, h0, h1, m0, m1, s0, s1);

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 2040 branch to line 2040
   */

  @Test
  public void info1() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    Locale locale = ((Locale)Reflector.getInstance("java.util.Locale"));
    objectUnderTest.locale = locale;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", "((((");
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 7;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = "!!!!";
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    char[] charArray = { '\u0000' };
    objectUnderTest.sbuf = charArray;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;

    // Act
    String retval = objectUnderTest.info();

    // Assert result
    Assert.assertEquals("pos 7, json : ((((", retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 736 branch to line 736
   */

  @Test
  public void isEOF1() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", null);
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 0;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = null;
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u001a';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;

    // Act
    boolean retval = objectUnderTest.isEOF();

    // Assert result
    Assert.assertEquals(true, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 736 branch to line 736
   */

  @Test
  public void isEOF2() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", null);
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 1;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = null;
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u0000';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;

    // Act
    boolean retval = objectUnderTest.isEOF();

    // Assert result
    Assert.assertEquals(false, retval);

  }

  /*
   * Test generated by Diffblue Deeptest.
   * This test case covers:
   *  - conditional line 736 branch to line 736
   */

  @Test
  public void isEOF3() throws Throwable {

    // Arrange
    JSONScanner objectUnderTest = ((JSONScanner)Reflector.getInstance("com.alibaba.fastjson.parser.JSONScanner"));
    objectUnderTest.hasSpecial = false;
    objectUnderTest.token = 0;
    objectUnderTest.locale = null;
    objectUnderTest.np = 0;
    objectUnderTest.features = 0;
    Reflector.setField(objectUnderTest, "text", null);
    objectUnderTest.calendar = null;
    objectUnderTest.matchStat = 0;
    objectUnderTest.bp = 1;
    Reflector.setField(objectUnderTest, "len", 0);
    objectUnderTest.stringDefaultValue = null;
    objectUnderTest.pos = 0;
    objectUnderTest.sp = 0;
    objectUnderTest.sbuf = null;
    objectUnderTest.ch = '\u001a';
    objectUnderTest.timeZone = null;
    objectUnderTest.eofPos = 0;

    // Act
    boolean retval = objectUnderTest.isEOF();

    // Assert result
    Assert.assertEquals(false, retval);

  }
}
