﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace smartDog
{
    public partial class Form1 : Form
    {
        private string appPath;
        public Form1()
        {
            InitializeComponent();
            this.appPath = System.Windows.Forms.Application.StartupPath;
            Control.CheckForIllegalCrossThreadCalls = false; //关闭安全线程访问
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            this.webBrowser1.Navigate(ConfigurationManager.AppSettings["url"]);
            //this.Text = ConfigurationManager.AppSettings["formTitle"];
            //IEVersion ie = new IEVersion();
            //ie.BrowserEmulationSet();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MessageBox.Show("如果报错，请以管理员身份运行此程序。");
            IEVersion ie = new IEVersion();
            ie.BrowserEmulationSet();
        }
        /// <summary>
        /// 填充表单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BtnFill_Click(object sender, EventArgs e)
        {
            Soubu.Helper.IniHelper ini = new Soubu.Helper.IniHelper(this.appPath + "\\soubu.ini");
            HtmlDocument hDoc = GetFrameDocument(ini.ReadIni("formData", "iFrame1"), ini.ReadIni("formData", "iFrame2"));
            if (hDoc == null) return;
            JToken json = (JToken)Newtonsoft.Json.JsonConvert.DeserializeObject(ini.ReadIni("formData", "values"));
            foreach (JToken item in json)
            {
                SetVal(hDoc, item.Path.ToString(), item.First.ToString());
            }
        }
        /// <summary>
        /// 一键登录按钮
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            Soubu.Helper.IniHelper ini = new Soubu.Helper.IniHelper(this.appPath + "\\soubu.ini");
            HtmlDocument hDoc = GetFrameDocument(ini.ReadIni("userLogin", "iFrame1"), ini.ReadIni("userLogin", "iFrame2"));
            if (hDoc == null) return;
            JToken json = (JToken)Newtonsoft.Json.JsonConvert.DeserializeObject(ini.ReadIni("userLogin", "values"));
            foreach (JToken item in json)
            {
                SetVal(hDoc, item.Path.ToString(), item.First.ToString());
            }
        }
        /// <summary>
        /// 获得iFrame内的iFrame
        /// <para>frameId1为空时返回根HtmlDocument，this.webBrowser1.Document</para>
        /// <para>frameId1或frameId2失败时，直接返回根HtmlDocument，this.webBrowser1.Document</para>
        /// </summary>
        /// <param name="frameId1">第一层iFrame的Id，为空时返回根HtmlDocument，this.webBrowser1.Document
        /// <para>frameId1不为空，frameId2为空时，返回第一层的iFrame</para>
        /// </param>
        /// <param name="frameId2">第二层iFrame的Id和frameId1均不为空时，返回第二层的iFrame</param>
        /// <returns></returns>
        private HtmlDocument GetFrameDocument(string frameId1, string frameId2)
        {
            Soubu.Helper.LogHelper log = new Soubu.Helper.LogHelper(this.appPath, false);
            HtmlDocument hDoc = this.webBrowser1.Document;
            if (string.IsNullOrWhiteSpace(frameId1))
            {
                return hDoc;
            }
            else if (!string.IsNullOrWhiteSpace(frameId1) && !string.IsNullOrWhiteSpace(frameId2))
            {//第二层iFrame
                try
                {
                    return hDoc.Window.Frames[frameId1].Document.Window.Frames[frameId2].Document;
                }
                catch (Exception ex)
                {
                    log.CreateLog(string.Format("frameId1:{0}，frameId2:{1}，error：\r\n\r\n", frameId1, frameId2, ex.ToString()));
                    return hDoc;
                }
            }
            else if (!string.IsNullOrWhiteSpace(frameId1))
            { //第一层iFrame
                try
                {
                    return hDoc.Window.Frames[frameId1].Document;
                }
                catch (Exception ex)
                {
                    log.CreateLog(string.Format("frameId1:{0}，error：\r\n\r\n", frameId1, ex.ToString()));
                    return hDoc;
                }
            }
            else
            {
                return hDoc;
            }
        }
        /// <summary>
        /// 给文本框赋值
        /// </summary>
        /// <param name="htmDoc">HtmlDocument对象</param>
        /// <param name="propName">html控件的属性名称</param>
        /// <param name="value">html控件的值</param>
        private void SetVal(HtmlDocument htmDoc, string propName, string value)
        {
            if (htmDoc.All[propName] != null) htmDoc.All[propName].SetAttribute("value", value);
        }



    }
}
