/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMJavaBeanDeserializer
implements ObjectDeserializer {
    protected InnerJavaBeanDeserializer serializer;

    public ASMJavaBeanDeserializer(JavaBeanMapping mapping, Class<?> clazz) {
        this.serializer = new InnerJavaBeanDeserializer(mapping, clazz);
        this.serializer.getFieldDeserializerMap();
    }

    public Object createInstance(DefaultExtJSONParser parser, Type type) {
        return this.serializer.createInstance(parser, type);
    }

    public InnerJavaBeanDeserializer getInnterSerializer() {
        return this.serializer;
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        return this.serializer.deserialze(parser, type);
    }

    @Override
    public int getFastMatchToken() {
        return this.serializer.getFastMatchToken();
    }

    public FieldDeserializer createFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        return mapping.createFieldDeserializer(mapping, clazz, method);
    }

    public boolean parseField(DefaultExtJSONParser parser, String key, Object object) {
        JSONScanner lexer = (JSONScanner)parser.getLexer();
        FieldDeserializer fieldDeserializer = this.serializer.getFieldDeserializerMap().get(key);
        if (fieldDeserializer == null) {
            if (!parser.isIgnoreNotMatch()) {
                throw new JSONException("setter not found, class " + this.serializer.getClass() + ", property " + key);
            }
            lexer.nextTokenWithColon();
            parser.parse();
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object);
        return true;
    }

    public static List parseArray(DefaultExtJSONParser parser, ObjectDeserializer itemDeserializer) {
        ArrayList array = new ArrayList();
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("exepct '[', but " + lexer.token());
        }
        lexer.nextToken(itemDeserializer.getFastMatchToken());
        while (true) {
            if (lexer.isEnabled(Feature.AllowArbitraryCommas)) {
                while (lexer.token() == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token() == 15) break;
            Object value = itemDeserializer.deserialze(parser, null);
            array.add(value);
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        if (lexer.token() != 15) {
            throw new JSONException("exepct ']', but " + lexer.token());
        }
        lexer.nextToken(16);
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class InnerJavaBeanDeserializer
    extends JavaBeanDeserializer {
        private InnerJavaBeanDeserializer(JavaBeanMapping mapping, Class<?> clazz) {
            super(mapping, clazz);
        }

        @Override
        public boolean parseField(DefaultExtJSONParser parser, String key, Object object) {
            return ASMJavaBeanDeserializer.this.parseField(parser, key, object);
        }

        @Override
        public FieldDeserializer createFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
            return ASMJavaBeanDeserializer.this.createFieldDeserializer(mapping, clazz, method);
        }

        public FieldDeserializer createFieldDeserializer0(JavaBeanMapping mapping, Class<?> clazz, Method method) {
            return mapping.createFieldDeserializer(mapping, clazz, method);
        }
    }
}

