/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultExtJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JavaBeanMapping;
import com.alibaba.fastjson.parser.TypeUtils;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongFieldDeserializer
extends FieldDeserializer {
    private final ObjectDeserializer fieldValueDeserilizer;

    public LongFieldDeserializer(JavaBeanMapping mapping, Class<?> clazz, Method method) {
        super(clazz, method);
        this.fieldValueDeserilizer = mapping.getDeserializer(this.fieldClass, this.fieldType);
    }

    @Override
    public void parseField(DefaultExtJSONParser parser, Object object) {
        Long value;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            long val = lexer.longValue();
            lexer.nextToken(16);
            this.setValue(object, val);
            return;
        }
        if (lexer.token() == 8) {
            value = null;
            lexer.nextToken(16);
        } else {
            Object obj = parser.parse();
            value = TypeUtils.castToLong(obj);
        }
        if (value == null && this.fieldClass == Long.TYPE) {
            return;
        }
        this.setValue(object, value);
    }

    @Override
    public int getFastMatchToken() {
        return this.fieldValueDeserilizer.getFastMatchToken();
    }
}

